﻿using System.Collections.Generic;

using Android.Content;
using Android.Database;
using Android.Net;
using Android.Provider;

namespace Kontakty
{
    class Kontakt
    {
        public string NazwaWyswietlana;
        public string TelefonKomorkowy;
        public string TelefonDomowy;
        public string TelefonWPracy;
        public string EmailWPracy;
        public string Firma;
        public string Tytul;
        //mozna uzupelnic m.in. o zdjecie

        public Kontakt(
                string nazwaWyswietlana,
                string telefonKomorkowy,
                string telefonDomowy,
                string telefonWPracy,
                string emailWPracy,
                string firma,
                string tytul)
        {
            this.NazwaWyswietlana = nazwaWyswietlana;
            this.TelefonKomorkowy = telefonKomorkowy;
            this.TelefonDomowy = telefonDomowy;
            this.TelefonWPracy = telefonWPracy;
            this.EmailWPracy = emailWPracy;
            this.Firma = firma;
            this.Tytul = tytul;
        }

        public static List<string> ListaNazwWszystkichKontaktow(ContentResolver contentResolver)
        {
            List<string> lista = new List<string>();
            ICursor cursor = contentResolver.Query(ContactsContract.Contacts.ContentUri, null, null, null, null);
            if (cursor.Count > 0)
            {
                while (cursor.MoveToNext())
                {
                    string nazwa = cursor.GetString(cursor.GetColumnIndex(ContactsContract.Contacts.InterfaceConsts.DisplayName));
                    string id = cursor.GetString(cursor.GetColumnIndex(ContactsContract.Contacts.InterfaceConsts.Id));
                    lista.Add("[" + id + "] " + nazwa);
                }
            }
            else
            {
                lista = null;
            }
            cursor.Close();
            return lista;
        }

        public static void UsuńWszystkieKontakty(ContentResolver contentResolver)
        {
            ICursor cursor = contentResolver.Query(ContactsContract.Contacts.ContentUri, null, null, null, null);
            while (cursor.MoveToNext())
            {
                string klucz = cursor.GetString(cursor.GetColumnIndex(ContactsContract.Contacts.InterfaceConsts.LookupKey));
                Uri uri = Uri.WithAppendedPath(ContactsContract.Contacts.ContentLookupUri, klucz);
                contentResolver.Delete(uri, null, null);
            }
            cursor.Close();
        }

        //Zrodlo: http://stackoverflow.com/questions/4744187/how-to-add-new-contacts-in-android
        private static void dodajNowyKontaktDoBazy(ContentResolver contentResolver, Kontakt kontakt)
        {

            List<ContentProviderOperation> dodawanyKontakt = new List<ContentProviderOperation>();

            dodawanyKontakt.Add(ContentProviderOperation.NewInsert(
                ContactsContract.RawContacts.ContentUri)
                    .WithValue(ContactsContract.RawContacts.InterfaceConsts.AccountType, null)
                    .WithValue(ContactsContract.RawContacts.InterfaceConsts.AccountName, null)
                    .Build());

            if (kontakt.NazwaWyswietlana != null)
            {
                dodawanyKontakt.Add(ContentProviderOperation.NewInsert(ContactsContract.Data.ContentUri)
                         .WithValueBackReference(ContactsContract.Data.InterfaceConsts.RawContactId, 0)
                         .WithValue(ContactsContract.Data.InterfaceConsts.Mimetype, ContactsContract.CommonDataKinds.StructuredName.ContentItemType)
                         .WithValue(ContactsContract.CommonDataKinds.StructuredName.DisplayName, kontakt.NazwaWyswietlana)
                         .Build());
            }

            if (kontakt.TelefonKomorkowy != null)
            {
                dodawanyKontakt.Add(ContentProviderOperation.NewInsert(ContactsContract.Data.ContentUri)
                     .WithValueBackReference(ContactsContract.Data.InterfaceConsts.RawContactId, 0)
                     .WithValue(ContactsContract.Data.InterfaceConsts.Mimetype, ContactsContract.CommonDataKinds.Phone.ContentItemType)
                     .WithValue(ContactsContract.CommonDataKinds.Phone.Number, kontakt.TelefonKomorkowy)
                     //.WithValue(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Phone.GetTypeLabelResource(PhoneDataKind.Mobile))
                     .WithValue(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Phone.InterfaceConsts.TypeCustom)
                     .WithValue(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Label, "Mobile")
                     .Build());
            }

            if (kontakt.TelefonDomowy != null)
            {
                dodawanyKontakt.Add(ContentProviderOperation.NewInsert(ContactsContract.Data.ContentUri)
                     .WithValueBackReference(ContactsContract.Data.InterfaceConsts.RawContactId, 0)
                     .WithValue(ContactsContract.Data.InterfaceConsts.Mimetype, ContactsContract.CommonDataKinds.Phone.ContentItemType)
                     .WithValue(ContactsContract.CommonDataKinds.Phone.Number, kontakt.TelefonDomowy)
                     //.WithValue(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Phone.GetTypeLabelResource(PhoneDataKind.Home))
                     .WithValue(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Phone.InterfaceConsts.TypeCustom)
                     .WithValue(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Label, "Home")
                     .Build());
            }

            if (kontakt.TelefonWPracy != null)
            {
                dodawanyKontakt.Add(ContentProviderOperation.NewInsert(ContactsContract.Data.ContentUri)
                     .WithValueBackReference(ContactsContract.Data.InterfaceConsts.RawContactId, 0)
                     .WithValue(ContactsContract.Data.InterfaceConsts.Mimetype, ContactsContract.CommonDataKinds.Phone.ContentItemType)
                     .WithValue(ContactsContract.CommonDataKinds.Phone.Number, kontakt.TelefonWPracy)
                     //.WithValue(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Phone.GetTypeLabelResource(PhoneDataKind.Work))                     
                     .WithValue(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Phone.InterfaceConsts.TypeCustom)
                     .WithValue(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Label, "Work")
                     .Build());
            }

            if (kontakt.EmailWPracy != null)
            {
                dodawanyKontakt.Add(ContentProviderOperation.NewInsert(ContactsContract.Data.ContentUri)
                     .WithValueBackReference(ContactsContract.Data.InterfaceConsts.RawContactId, 0)
                     .WithValue(ContactsContract.Data.InterfaceConsts.Mimetype, ContactsContract.CommonDataKinds.Email.ContentItemType)
                     .WithValue(ContactsContract.CommonDataKinds.Email.InterfaceConsts.Data, kontakt.EmailWPracy)
                     //.WithValue(ContactsContract.CommonDataKinds.Email.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Email.GetTypeLabelResource(EmailDataKind.Work))
                     .WithValue(ContactsContract.CommonDataKinds.Email.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Phone.InterfaceConsts.TypeCustom)
                     .WithValue(ContactsContract.CommonDataKinds.Email.InterfaceConsts.Label, "Work")
                     .Build());
            }

            if (string.IsNullOrEmpty(kontakt.Firma) && string.IsNullOrEmpty(kontakt.Tytul))
            {
                dodawanyKontakt.Add(ContentProviderOperation.NewInsert(ContactsContract.Data.ContentUri)
                     .WithValueBackReference(ContactsContract.Data.InterfaceConsts.RawContactId, 0)
                     .WithValue(ContactsContract.Data.InterfaceConsts.Mimetype, ContactsContract.CommonDataKinds.Organization.ContentItemType)
                     .WithValue(ContactsContract.CommonDataKinds.Organization.Company, kontakt.Firma)
                     //.WithValue(ContactsContract.CommonDataKinds.Organization.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Organization.GetTypeLabelResource(OrganizationDataKind.Work))
                     .WithValue(ContactsContract.CommonDataKinds.Organization.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Phone.InterfaceConsts.TypeCustom)
                     .WithValue(ContactsContract.CommonDataKinds.Organization.InterfaceConsts.Label, "Work")
                     .WithValue(ContactsContract.CommonDataKinds.Organization.Title, kontakt.Tytul)
                     //.WithValue(ContactsContract.CommonDataKinds.Organization.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Organization.GetTypeLabelResource(OrganizationDataKind.Work))
                     .WithValue(ContactsContract.CommonDataKinds.Organization.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Phone.InterfaceConsts.TypeCustom)
                     .WithValue(ContactsContract.CommonDataKinds.Organization.InterfaceConsts.Label, "Work")
                     .Build());
            }

            //prosba do dostawcy kontaktaktow o utworzenie nowego kontaktu
            //try 
            //{
            contentResolver.ApplyBatch(ContactsContract.Authority, dodawanyKontakt);
            //return true;
            //} 
            //catch (Exception e) 
            //{
            //e.printStackTrace();
            //return false;
            //} 
        }

        public void Zapisz(ContentResolver contentResolver)
        {
            dodajNowyKontaktDoBazy(contentResolver, this);
        }
    }
}