﻿using Android.App;
using Android.OS;
using Android.Support.V7.App;
using Android.Runtime;
using Android.Widget;
using Android.Media;

namespace Grafika2D
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true, ScreenOrientation = Android.Content.PM.ScreenOrientation.Unspecified)]
    public class MainActivity : AppCompatActivity
    {
        private MediaPlayer mp = null;

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            // Set our view from the "main" layout resource
            //SetContentView(Resource.Layout.activity_main);
            SetContentView(new Grafika2DView(ApplicationContext, null));

            try
            {
                if (mp != null && mp.IsPlaying)
                {
                    mp.Stop();
                    mp.Reset();
                }
                else if (mp != null)
                {
                    mp.Reset();
                    mp.Release();
                }

                //z zasobow
                //mp = MediaPlayer.Create(ApplicationContext, Resource.Raw.tada);
                //mp = MediaPlayer.Create(ApplicationContext, Resource.Raw.Frasier);

                //*
                //z systemu plikow                

                //Android.Net.Uri uri = Android.Net.Uri.Parse("file:///sdcard/Frasier.mp3");                                                
                //Android.Net.Uri uri = Android.Net.Uri.Parse("file:///storage/emulated/0/Download/Frasier.mp3");

                string externalStoragePath = Android.OS.Environment.ExternalStorageDirectory.AbsolutePath;
                string path = System.IO.Path.Combine(externalStoragePath, "Frasier.mp3");
                Android.Net.Uri uri = Android.Net.Uri.Parse(path);

                //mp = new MediaPlayer(); mp.SetDataSource(ApplicationContext, uri); mp.Prepare();
                mp = MediaPlayer.Create(ApplicationContext, uri);
                //*/

                mp.Completion += (object sender, System.EventArgs e) => { Toast.MakeText(ApplicationContext, "Odtwarzanie utworu zostało zakończone", ToastLength.Long).Show(); };

                mp.Start(); //asynchroniczne
            }
            catch (Java.Lang.Exception exc)
            {
                Toast.MakeText(ApplicationContext, "Odtworzenie utworu nie powiodło się\n" + exc.Message, ToastLength.Long).Show();
            }
            catch (System.Exception exc)
            {
                Toast.MakeText(ApplicationContext, "Odtworzenie utworu nie powiodło się\n" + exc.Message, ToastLength.Long).Show();
            }    
        }

        protected override void OnPause()
        {
            mp.Pause();
            base.OnPause();
        }

        protected override void OnResume()
        {
            mp.Start();
            base.OnResume();
        }

        protected override void OnDestroy()
        {
            mp.Stop();
            base.OnDestroy();
        }
    }
}