﻿using Android.App;
using Android.OS;
using Android.Support.V7.App;
using Android.Widget;

namespace BazaDanychSQLite
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true)]
    public class MainActivity : AppCompatActivity
    {
        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.activity_main);

            //usuwam bazę danych - ma sens tylko do nauki
            bool wynik = this.DeleteDatabase(Osoba.NazwaBazyDanych);
            Toast.MakeText(ApplicationContext, "Usunięcie bazy danych: " + wynik.ToString(), ToastLength.Short).Show();

            //tworzę bazę danych i dodaję rekordy
            BazaDanychOsob dbm = new BazaDanychOsob(this);
            dbm.DodajRekord(new Osoba(0, "Jacek", "Matulewski", 45, 123456789));
            dbm.DodajRekord(new Osoba(1, "Jan", "Kowalski", 46, 987654321));
            dbm.DodajRekord(new Osoba(2, "John", "Smith", 20, 987654321));
            dbm.DodajRekord(new Osoba(3, "Hans", "Muller", 32, 564738219));

            //dbm.dodajRekord(new Osoba(0, "Jacek2", "Matulewski2", 32, 564738219));

            //czytam zawartość bazy danych
            Osoba[] osoby = dbm.PobierzWszystkieRekordy("Imię");
            pokażOsoby(osoby);

            dbm.UsuńRekord(1);

            osoby = dbm.PobierzWszystkieRekordy(null);
            pokażOsoby(osoby);

            dbm.ZmieńRekord(0, new Osoba(4, "Jean", "Dupont", 50, 1230198318));

            osoby = dbm.PobierzWszystkieRekordy("Imię");
            pokażOsoby(osoby);

            //dbm.Close();
        }

        private void pokażOsoby(Osoba[] osoby)
        {
            TextView tv = FindViewById<TextView>(Resource.Id.textView);
            //tv.setText(Integer.toString(osoby.length));
            string sRekordy = "Rekordy:";
            foreach (Osoba osoba in osoby)
                sRekordy += "\n" + osoba.ToString();
            tv.Text = sRekordy;
        }
    }
}