﻿using Java.Net;
using Java.Util;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Tcp
{
    public static class AdresyIP
    {
        public static List<string> PobierzAdresyIp(bool useIPv4 = true)
        {
            try
            {
                List<string> ips = new List<string>();
                System.Collections.IList nis = Collections.List(NetworkInterface.NetworkInterfaces);
                foreach (NetworkInterface ni in nis)
                {
                    System.Collections.IList addresses = Collections.List(ni.InetAddresses);
                    foreach (InetAddress address in addresses)
                    {
                        if (!address.IsLoopbackAddress)
                        {
                            string sAddress = address.HostAddress;
                            //boolean isIPv4 = InetAddressUtils.isIPv4Address(sAddr);
                            bool isIPv4 = sAddress.IndexOf(':') < 0;

                            if (useIPv4)
                            {
                                //if (isIPv4) return sAddress;
                                if (isIPv4) ips.Add(sAddress + " (" + ni.DisplayName + ")");
                            }
                            else
                            {
                                if (!isIPv4)
                                {
                                    int delim = sAddress.IndexOf('%'); // drop ip6 zone suffix
                                    string s = delim < 0 ? sAddress.ToUpper() : sAddress.Substring(0, delim).ToUpper();
                                    ips.Add(s + " (" + ni.DisplayName + ")");
                                }
                            }
                        }
                    }
                }
                return ips;
            }
            catch (Exception exc)
            {
                throw new Exception("Błąd podczas pobierania adresów IP", exc);                
            }
        }
    }
}
