unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Menus, ExtCtrls, ComCtrls, Math, ExtDlgs, Cellular_automation;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Opengamefile1: TMenuItem;
    Savegamestate1: TMenuItem;
    Savegameasbmp1: TMenuItem;
    Quit1: TMenuItem;
    Panel2: TPanel;
    ComboBox1: TComboBox;
    StatusBar: TStatusBar;
    Board: TImage;
    Start_Button: TButton;
    Timer: TTimer;
    Chart_Button: TImage;
    ComboBox2: TComboBox;
    Game1: TMenuItem;
    Start1: TMenuItem;
    Reset1: TMenuItem;
    TrackBar: TTrackBar;
    About1: TMenuItem;
    About2: TMenuItem;
    N1: TMenuItem;
    SavePicture: TSavePictureDialog;
    Open: TOpenDialog;
    Save: TSaveDialog;
    Label1: TLabel;
    N2: TMenuItem;
    Randomseed1: TMenuItem;
    Notify: TMenuItem;
    Newgame1: TMenuItem;
    Step_Button: TButton;
    Onestepforward1: TMenuItem;
    N3: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure Quit1Click(Sender: TObject);
    procedure BoardMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Start_ButtonClick(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure Chart_ButtonMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Chart_ButtonMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BoardMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure ComboBox2Change(Sender: TObject);
    procedure Reset1Click(Sender: TObject);
    procedure TrackBarChange(Sender: TObject);
    procedure Savegameasbmp1Click(Sender: TObject);
    procedure Opengamefile1Click(Sender: TObject);
    procedure Savegamestate1Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure Randomseed1Click(Sender: TObject);
    procedure About2Click(Sender: TObject);
    procedure NotifyClick(Sender: TObject);
    procedure Newgame1Click(Sender: TObject);
    procedure Step_ButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  cell,copy:table;
  info:Tinfo;
  options:Toptions;

implementation

uses Unit2, Unit3, Unit4;

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
var filename:string;
var input_file:TextFile;
var i,j:byte;
var chr:char;
begin
  cells_clear();
  copy_board();
  init_board();
  clear_board();
  draw_on_board();

  options.game_in_progress := False;
  options.step_mode := False;

  //Convays Game of Life
  with options do
  begin
    neighbourhood := NEUMANN;
    b[0]:=0; b[1]:=0; b[2]:=0; b[3]:=1; b[4]:=0; b[5]:=0; b[6]:=0; b[7]:=0; b[8]:=0;
    d[0]:=0; d[1]:=0; d[2]:=1; d[3]:=1; d[4]:=0; d[5]:=0; d[6]:=0; d[7]:=0; d[8]:=0;
  end;

  if (ParamCount() = 1) then
  begin
    filename := ParamStr(1);
    if (filename <> '') then
    begin
      if (FileExists(filename)) then
      begin
        assignFile(input_file,filename);
        reset(input_file);
        for j := 0 to cells_y do
        begin
          for i := 0 to cells_x do
          begin
            if (NOT EoF(input_file)) then read(input_file,chr) else chr := ' ';
            if (chr = ' ') then cell[i][j] := 0 else cell[i][j] := 1;
          end;
          readln(input_file);
        end;
        closeFile(input_file);
        draw_on_board();
        Form1.Caption := 'Cellular automation - ['+ExtractFileName(ParamStr(1))+']';
      end;
    end;
  end;
end;

procedure TForm1.Quit1Click(Sender: TObject);
begin
  Form1.Close();
end;

procedure TForm1.BoardMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  change_cell_state(X div 10, Y div 10);
  draw_on_board();
end;

procedure TForm1.Start_ButtonClick(Sender: TObject);
begin
  if (Timer.Enabled = False) then
  begin
    if (options.game_in_progress = False) then
    begin
      copy_board();
      options.game_in_progress := True;
    end;
    resume_game();
  end else pause_game();
end;

procedure TForm1.TimerTimer(Sender: TObject);
begin
  game_of_life();
  draw_on_board();
  stat_info();

  if (info.changes = 0) AND (Notify.Checked) then
  begin
    pause_game(); //Symulation halt

    if (info.alive <> 0) then MessageDlg('That state is stable and there will be no futher changes.', mtInformation, [mbOk], 0)
    else MessageDlg('All cells are dead and there will be no futher changes.', mtInformation, [mbOk], 0);
  end;

  if (options.step_mode = True) then
  begin
    pause_game();
    options.step_mode := False;
  end;
end;

procedure TForm1.Chart_ButtonMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  Chart_Button.Left := Chart_Button.Left+1;
  Chart_Button.Top  := Chart_Button.Top+1;
end;

procedure TForm1.Chart_ButtonMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  Chart_Button.Left := Chart_Button.Left-1;
  Chart_Button.Top  := Chart_Button.Top-1;
  Info_Form.Show();
end;

procedure TForm1.BoardMouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer);
var neighbours: byte;
begin
  if (options.neighbourhood = NEUMANN) then
    neighbours := von_neumann_neighbour(X div 10,Y div 10)
  else
    neighbours := moore_neighbour(X div 10,Y div 10);

  StatusBar.Panels[0].Text := 'Coordinates: ['+IntToStr((X div 10)+1)+','+IntToStr((Y div 10)+1)+']';
  StatusBar.Panels[1].Text := 'Neighbours: '+IntToStr(neighbours);
end;

procedure TForm1.ComboBox2Change(Sender: TObject);
begin
  case ComboBox2.ItemIndex of
  0: options.neighbourhood := NEUMANN;
  1: options.neighbourhood := MOORE;
  end;
end;

procedure TForm1.Reset1Click(Sender: TObject);
begin
  reset_game();
  restore_board();
  clear_board();
  draw_on_board();
  options.game_in_progress := False;
end;

procedure TForm1.TrackBarChange(Sender: TObject);
begin
  Timer.Interval := TrackBar.Position * 50;
  StatusBar.Panels[3].Text := 'Time interval: '+IntToStr(Timer.Interval)+'ms';
end;

procedure TForm1.Savegameasbmp1Click(Sender: TObject);
var filename:string;
begin
  pause_game();
  if (SavePicture.Execute()) then
  begin
    filename := SavePicture.FileName;
    if (filename <> '') then
    begin
      if (ExtractFileExt(filename) <> '.bmp') then filename := filename + '.bmp';
    end;
    Board.Picture.Bitmap.SaveToFile(filename);
  end;
end;

procedure TForm1.Opengamefile1Click(Sender: TObject);
var filename:string;
var input_file:TextFile;
var i,j:byte;
var chr:char;
begin
  if (Open.Execute()) then
  begin
    filename := Open.FileName;
    if (filename <> '') then
    begin
      if (FileExists(filename)) then
      begin
        reset_game();
        assignFile(input_file,filename);
        reset(input_file);
        for j := 0 to cells_y do
        begin
          for i := 0 to cells_x do
          begin
            if (NOT EoF(input_file)) then read(input_file,chr) else chr := ' ';
            if (chr = ' ') then cell[i][j] := 0 else cell[i][j] := 1;
          end;
          readln(input_file);
        end;
        closeFile(input_file);
        draw_on_board();
        Form1.Caption := 'Cellular automation - ['+ExtractFileName(filename)+']';
      end;
    end;
  end;
end;

procedure TForm1.Savegamestate1Click(Sender: TObject);
var filename:string;
var input_file:TextFile;
var i,j:byte;
begin
  if (Save.Execute()) then
  begin
    filename := Save.FileName;
    if (filename <> '') then
    begin
      pause_game();
      if (ExtractFileExt(filename) <> '.life') then filename := filename + '.life';
      assignFile(input_file,filename);
      rewrite(input_file);
      for j := 0 to cells_y do
      begin
        for i := 0 to cells_x do
        begin
          if (cell[i][j] = 1) then write(input_file,'x') else write(input_file,' ');
        end;
       writeln(input_file);
      end;
      closeFile(input_file);
    end;
  end;
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
  with options do
  begin
    case ComboBox1.ItemIndex of
       0: //Game of life
          begin
          d[0]:=0; d[1]:=0; d[2]:=1; d[3]:=1; d[4]:=0; d[5]:=0; d[6]:=0; d[7]:=0; d[8]:=0;
          b[0]:=0; b[1]:=0; b[2]:=0; b[3]:=1; b[4]:=0; b[5]:=0; b[6]:=0; b[7]:=0; b[8]:=0;
          end;
       1: //Labirynth
          begin
          d[0]:=0; d[1]:=1; d[2]:=1; d[3]:=1; d[4]:=1; d[5]:=1; d[6]:=0; d[7]:=0; d[8]:=0;
          b[0]:=0; b[1]:=0; b[2]:=0; b[3]:=1; b[4]:=0; b[5]:=0; b[6]:=0; b[7]:=0; b[8]:=0;
          end;
       2: //Cities and walls
          begin
          d[0]:=0; d[1]:=0; d[2]:=1; d[3]:=1; d[4]:=1; d[5]:=1; d[6]:=0; d[7]:=0; d[8]:=0;
          b[0]:=0; b[1]:=0; b[2]:=0; b[3]:=0; b[4]:=1; b[5]:=1; b[6]:=1; b[7]:=1; b[8]:=1;
          end;
       3: //Replicator
          begin
          d[0]:=0; d[1]:=1; d[2]:=0; d[3]:=1; d[4]:=0; d[5]:=1; d[6]:=0; d[7]:=1; d[8]:=0;
          b[0]:=0; b[1]:=1; b[2]:=0; b[3]:=1; b[4]:=0; b[5]:=1; b[6]:=0; b[7]:=1; b[8]:=0;
          end;
       4: //Seeds
          begin
          d[0]:=0; d[1]:=0; d[2]:=0; d[3]:=0; d[4]:=0; d[5]:=0; d[6]:=0; d[7]:=0; d[8]:=0;
          b[0]:=0; b[1]:=0; b[2]:=1; b[3]:=0; b[4]:=0; b[5]:=0; b[6]:=0; b[7]:=0; b[8]:=0;
          end;
       5: //Tableclothes
          begin
          d[0]:=0; d[1]:=0; d[2]:=0; d[3]:=0; d[4]:=0; d[5]:=0; d[6]:=0; d[7]:=0; d[8]:=0;
          b[0]:=0; b[1]:=0; b[2]:=1; b[3]:=1; b[4]:=1; b[5]:=0; b[6]:=0; b[7]:=0; b[8]:=0;
          end;
       6: //Pyramides
          begin
          d[0]:=0; d[1]:=1; d[2]:=1; d[3]:=1; d[4]:=1; d[5]:=1; d[6]:=0; d[7]:=0; d[8]:=0;
          b[0]:=0; b[1]:=1; b[2]:=1; b[3]:=0; b[4]:=0; b[5]:=0; b[6]:=0; b[7]:=0; b[8]:=0;
          end;
       7: //Growth
          begin
          d[0]:=0; d[1]:=1; d[2]:=0; d[3]:=0; d[4]:=0; d[5]:=0; d[6]:=0; d[7]:=0; d[8]:=0;
          b[0]:=0; b[1]:=1; b[2]:=0; b[3]:=0; b[4]:=0; b[5]:=0; b[6]:=0; b[7]:=0; b[8]:=0;
          end;
       8: //Custom
          begin
          Custom_Select.ShowModal();
          end;
    end;
  end;
end;

procedure TForm1.Randomseed1Click(Sender: TObject);
var i:integer;
begin
  pause_game();
  for i:=1 to 360 do cell[random(60)][random(60)] := 1;
  clear_board();
  draw_on_board();
end;

procedure TForm1.About2Click(Sender: TObject);
begin
  About.ShowModal();
end;

procedure TForm1.NotifyClick(Sender: TObject);
begin
  if (Notify.Checked) then Notify.Checked := False else Notify.Checked := True;
end;

procedure TForm1.Newgame1Click(Sender: TObject);
begin
  reset_game();
  copy_board();
end;

procedure TForm1.Step_ButtonClick(Sender: TObject);
begin
  options.step_mode := True;
  resume_game();
end;

end.
