#include "fsdl.h"
#include <cmath>
#include <cstdio>

#include <vector>

// wymiary mapy
#define WIDTH  100
#define HEIGHT 100

fsdl m(100, 640, 480, 32, "MICRO DRIFT");

const char* map_file       = "maps/3.map"; // podloze
const char* map_item_file  = "maps/3.det"; // przeszkody - itp
const char* map_point_file = "maps/3.ptn"; // check pointy


#define GAME_STATE_CODE 0
#define GAME_STATE_MENU 1
#define GAME_STATE_GAME 2
int game_state = GAME_STATE_CODE;

// wczytywanie tekstur
tekstura ground        (m.okno(), "gfx/teren.bmp");
tekstura point         (m.okno(), "gfx/bramka.bmp", 0xff00ff);
tekstura nums          (m.okno(), "gfx/nums.bmp");
tekstura chars         (m.okno(), "gfx/chars.bmp", 0xff00ff);
tekstura code_masters  (m.okno(), "gfx/code_masters_lod_logo.bmp");
tekstura micro_machine (m.okno(), "gfx/micro_machine_nes.bmp");
tekstura car           (m.okno(), "gfx/samochod.bmp", 0xff00ff);
tekstura bot           (m.okno(), "gfx/bot3.bmp", 0xff00ff);
tekstura duch          (m.okno(), "gfx/duch.bmp", 0xff00ff);
tekstura strzalka      (m.okno(), "gfx/strzalka.bmp", 0xff00ff);
prostokat prostok      (m.okno(), 80, 40, 0); // prostokaty do menu
prostokat prostok2     (m.okno(), 200, 80, 0);

//temp - sprawdzanie check pointow dal bota
//prostokat prost (m.okno(), 3, 3, 0xff0000);
//kolo      kol   (m.okno(), 15, 0x0000ff);
//  WYSZLO WSZYSTKO OK !! - srodki bramek

// tablica terenow
char mapa[HEIGHT][WIDTH]       = {0};
char mapa_point[HEIGHT][WIDTH] = {0};
// itemy (TODO)

// pozycja gracza jest zafixowana
// (ustawienie punktu kamery na srodek erkanu)
int player_pos_x = m.szerokosc()/2;
int player_pos_y = m.wysokosc()/2;



// obsluga bramek (check pointow)
struct chkptn{
 int x;
 int y;
 int i; 
};
std::vector<chkptn> check_pointy;


void wypisz(const char* t, int x, int y){
  int i = 0;
  for(i=0; t[i]; i++){
    if(t[i]==' ') continue;
    if(t[i]>='0' && t[i]<='9')
      chars.umiesc_ramke(x+i*10, y, t[i]-'0');
    else 
      chars.umiesc_ramke(x+i*10, y, t[i]-'a'+10);
  }
}
int menu_strzalka = 0;
int menu_pauza    = 0;
int menu_quit     = 0;
int menu_34ry     = 3;
int menu_counter  = 0;
int menu_lap      = 0;
int menu_result   = 0;
int window_full   = 0;

// 180* = pi
// rad => 1* = pi/180 rad
float to_rad(float alfa){
  return alfa*M_PI/180;
}
// pi/180 rad => 1* w radianach
float to_deg(float tetha){
  return tetha*180/M_PI;
}

class Vector{
 public:
   float _x;
   float _y;
   Vector(){_x=0.0; _y=0.0;}
   float mod2(){return _x*_x + _y*_y;}
   float mod() {return sqrt(_x*_x + _y*_y);}
};

// klasa zapamietujaca zdobyta bramke (check point)
class Check_Point_Snap_Shoot{
public:
 int    _n; // numer
 Vector _x; // pozycja pojazdu
 float  _a; // kat pojazdu
 Check_Point_Snap_Shoot():_x(){_n=0; _a=0.0;}
};

class Duch{
public:
 Vector _x;
 float  _a;
 int    time;
 Duch(Vector& x, float a, int t):_x(x),_a(a),time(t){
   printf("Utworzono ducha %p\n", this);
 }
 ~Duch(){
   printf("Usunieto ducha %p\n", this);
 }
};
std::vector<Duch*> Duchy;

class Pojazd {
 public:
   float   _m;    // masa pojazdu
   float   _a;    // kat obrotu (alfa),(w stopniach)

   Vector  _f;    // sila       tn
   Vector  _v;    // predkosc   tn
   Vector  _x;    // polozenie  tn

   Vector  _f1;    // sila       t(n+1)
   Vector  _v1;    // predkosc   t(n+1)
   Vector  _x1;    // polozenie  t(n+1)


   float    add_friction; // tarcie na trawie
   // snap shot 
   Check_Point_Snap_Shoot p;// check pointy (info o akt. zdobytym)
   int  lap; // okrazenie

   // mase przypisuje na stale tu aby gra byla uczciwa
   Pojazd():_f(),_v(),_x(),p(){_m=15.0;_a=0.0;add_friction=0.0;}



   void Fizyka(){

     // sila ustawiana jest wczesniej Gaz, Hamulec, Luz
     //
     // sila tarcia kol o podloze (pozwala sie rozpedzac i troche zwalnia)
     _f1._x -= 0.17 * _v.mod() * sin( to_rad(_a) );
     _f1._y -= 0.17 * _v.mod() * cos( to_rad(_a) );
  
  
     //sila oporu powietrza (zwalnia samochod)
     //   sila areodynamiczna D = -6PIvuR dla kuli => D = -v * (C)
     _f1._x -= _v._x * (0.21 + add_friction);
     _f1._y -= _v._y * (0.21 + add_friction);
     //                        ^ tarcie na trawie (z zasady gry)
   
/*
     // Poprawiony Euler (dt=1)
     // polozenie
     //       x(t) +v(t)dt + 1/2 F(t)/m dt^2
     _x._x = _x._x + _v._x + 0.5*_f._x/_m;
     _x._y = _x._y + _v._y + 0.5*_f._y/_m;

     // predksc
     //      v(t)  +   F(t)/m dt
     _v._x = _v._x + _f._x/_m;
     _v._y = _v._y + _f._y/_m;
*/

     float dt=1.0;
     // Verlet Predkosciowy 
     // polozenie
     // x(t+dt)=x(t) +v(t)dt + 1/2 F(t)/m dt^2
     _x1._x =  _x._x + _v._x*dt + 0.5*_f._x/_m*dt*dt;
     _x1._y =  _x._y + _v._y*dt + 0.5*_f._y/_m*dt*dt;

     // predksc
     //v(t+dt)=v(t)  +   (F(t+dt)+F(t))/2m dt
     _v1._x =  _v._x + 0.5*(_f._x + _f1._x)/_m*dt;
     _v1._y =  _v._y + 0.5*(_f._y + _f1._y)/_m*dt;



     //przejscie w czasie
     _x = _x1;
     _v = _v1;
     _f = _f1;

   }//Fizyka



   void Zasady_Gry(){


     // zbieranie check pointow
     // pozycja pojazdu wzgledem poczatku mapy (0,0 na mapie)
     //   jeszcze chyba trzeba bedzie poprawic
     int px = ((int)_x._x)/40;
     int py = ((int)_x._y)/40;
  
     // sprawdzam czy nie wypadlem za mape
     if(px < 0 || px > WIDTH || py < 0 || py > HEIGHT){
         // przywracanie pozycji do ostatniej bramki
         _x = p._x;
         _a = p._a;
	 _v._x = 0;
         _v._y = 0;
         printf("%p => %d (%d) <-- out of range\n", this, p._n, (p._n+1)/2);
     }

     // zwolnienie na trawie
     if(mapa[py][px] == 0){ // trawa = 0
       add_friction = 0.2;
     }else{
       add_friction = 0.0;
     }
  
     // sprawdzam co jest podemna na terenie
     if(mapa_point[py][px] > 0 &&  mapa_point[py][px] != p._n){
       // ... wjechalem w bramke (check point)
  
       
       // zbieranie bramki
       if( ( (mapa_point[py][px]+1)/2 == (p._n+1)/2 + 1 )   // kazda kolejna
           || (  (mapa_point[py][px]+1)/2 == 1              // lub po ostat.
             && (p._n+1)/2 + 1 >= (int)check_pointy.size() )// jest pierw.
       ){


         // zapis nowych pozycji bramki
         p._x = _x;
         p._a = _a;
         p._n = mapa_point[py][px];
         printf("%p => %d (%d)\n", this, p._n, (p._n+1)/2 );


         if ((p._n+1)/2 == 1)  lap ++;
        
 
      }else{
         // bramka pominieta
         // przywracanie pozycji do ostatniej bramki

         // dodanie ducha
         Duch* tmp = new Duch(_x, _a, 500);
         Duchy.push_back(tmp);
  
         _x = p._x;
         _a = p._a;
	 _v._x = 0;
         _v._y = 0;
         printf("%p => %d (%d)  <-- %d (%d)\n", this, p._n, (p._n+1)/2,
		mapa_point[py][px], (mapa_point[py][px]+1)/2
	 );
 
       }

     }

   }//Zasady_Gry


   // sterowanie - zasady gry
   void Redukcja_Kata(){
          if(_a > 180.0)  _a -= 360.0;
     else if(_a < -180.0) _a += 360.0;
   }
   void W_lewo(){
     _a += 0.7 * _v.mod();
     Redukcja_Kata(); 
   }
   void W_prawo(){
     _a -= 0.7 * _v.mod();
     Redukcja_Kata(); 
   }
   void Wolno(){
     _f1._x = -0.05 * sin( to_rad( _a ) );
     _f1._y = -0.05 * cos( to_rad( _a ) );
   }
   void Gazuj(){ 
     _f1._x = -0.2 * sin( to_rad( _a ) );
     _f1._y = -0.2 * cos( to_rad( _a ) );
   }
   void Hamuj(){
     _f1._x =  0.2 * sin( to_rad( _a ) );
     _f1._y =  0.2 * cos( to_rad( _a ) );
   }
   void Luz(){
     _f1._x = 0.0;
     _f1._y = 0.0;
   }




} Gracz, Bot;




void detektor_kolizji(Pojazd& pojazdA, Pojazd& pojazdB){

     //  narazie jak kulki bilardowe
     float bx = pojazdA._x._x - pojazdB._x._x;
     float by = pojazdA._x._y - pojazdB._x._y;
     // kwadrat odleglosci
     float odleglosc_2 = bx*bx + by*by;
     float r_pojazdu = 15.0; // polowa wysokosci pojazdu
     float r_pojazdu_2 = r_pojazdu * r_pojazdu; // narazie na stale
     // dla uproszczen klikzja zaklada jednakowe masy jednostkowe 
     if(odleglosc_2 < 4*r_pojazdu_2){ // warunek detekcji kolizji


       //odbicie
       
       // wektor b - kierunek dzialania sily
       // |b| = odleglosc miedzy kulkami
       // b ma skladowe bx i by

       // iloczny skalarne
       // a.b = a1b1 + a2b2 + ...
       // rzut wektora a na b to |a|cosT
       // a.b = |a||b|cosT
       // => rzut wektora a na b to (a.b)/|b|


       // iloczny skalarne
       // wspolczynnik dla b i v1
       float g1 = (bx * pojazdA._v._x + by * pojazdA._v._y) / odleglosc_2;
       // wspolczynnik dla b i v2
       float g2 = (bx * pojazdB._v._x + by * pojazdB._v._y) / odleglosc_2;

       // b1 - czesc wektora rownoleglego do b
       // b2 - czesc wektora prostopadlego do b
       // b1x to skladowa x wektora b1
       // b1y to skladowa y wektora b1
       // b2x to skladowa x wektora b2
       // b2y to skladowa y wektora b2

       // rzut wektora v1 na wektor b
       float v1b1x = g1 * bx;
       float v1b1y = g1 * by;
       // rzut wektora v1 na wektor prostopadly do b
       float v1b2x = pojazdA._v._x - v1b1x;
       float v1b2y = pojazdA._v._y - v1b1y;

       // rzut wektora v2 na wektor b
       float v2b1x = g2 * bx;
       float v2b1y = g2 * by;
       // rzut wektora v2 na wektor prostopadly do b
       float v2b2x = pojazdB._v._x - v2b1x;
       float v2b2y = pojazdB._v._y - v2b1y;

       // ustalanie nowych predkosci
       //   normalnie wektory v1 = v1b1 + v1b2
       //                     v2 = v2b1 + v2b2
       //   po odbiciu        v1 = v2b1 + v1b2
       //                     v2 = v1b1 + v2b2
       //                           ^ to sie zamoenia z v1 do v2 i vv.
       //        === czyli odbijam na lini akcji  ===

       pojazdA._v._x = v2b1x + v1b2x;
       pojazdA._v._y = v2b1y + v1b2y;

       pojazdB._v._x = v1b1x + v2b2x;
       pojazdB._v._y = v1b1y + v2b2y;



       // stara sie naprawic problem "sklejenia"
       // odsuwam od siebie na odleglosc R = (r1+r2) => R = 2*r

       float odleglosc = sqrt(abs(odleglosc_2)); // ta nie poprawna
       float promienie = sqrt(abs(4*r_pojazdu_2));
       float delta_na_b = (promienie - odleglosc)/2; // polowa bo
              // chce odsunac porowna oba obiekty

       pojazdA._x._x += bx * delta_na_b / odleglosc;
       pojazdA._x._y += by * delta_na_b / odleglosc;

       pojazdB._x._x -= bx * delta_na_b / odleglosc;
       pojazdB._x._y -= by * delta_na_b / odleglosc;


       // debug ...
       printf("[+] Zderzenie %p <--> %p\n", &pojazdA, &pojazdB);


     }





}





void player_reset(){
  // poczatkowe parametry Gracza
  Gracz._a = 180;
  Gracz._x._x = player_pos_x;
  Gracz._x._y = player_pos_y;
  Gracz._v._x = 0;
  Gracz._v._y = 0;
  Gracz._f._x = 0;
  Gracz._f._y = 0;
  // poczatkowy snap shot (naprawia bugga)
  Gracz.p._x = Gracz._x;
  Gracz.p._a = Gracz._a;
  Gracz.p._n = 0;
  // okrazenia
  Gracz.lap = 0;
 
  // poczatkowe parametry Bota
  Bot._a = 180;
  Bot._x._x = player_pos_x - 60;
  Bot._x._y = player_pos_y;
  Bot._v._x = 0;
  Bot._v._y = 0;
  Bot._f._x = 0;
  Bot._f._y = 0;
  // poczatkowy snap shot (naprawia bugga)
  Bot.p._x = Bot._x;
  Bot.p._a = Bot._a;
  Bot.p._n = 0;

  Bot.lap = 0;
 
  menu_34ry     = 3;
  menu_lap      = 0;
  menu_counter  = 0;
  menu_result   = 0;
}


// przez rozpoczeciem gry
void pre(){

  // szybkie wczytanie mapy terenu
  FILE* file = fopen(map_file, "rb");
  fread(mapa, 1, sizeof(mapa), file);
  fclose(file);

  // szybkie wczytanie mapy check pointow
  file = fopen(map_point_file, "rb");
  fread(mapa_point, 1, sizeof(mapa_point), file);
  fclose(file);


  // ustawiam ramke wyswietlania dla tekstury ground
  ground.ustaw_ramke(40,40);
  point.ustaw_ramke(40,40);
  chars.ustaw_ramke(10,14);

  
  player_reset();


  // szukanie check pointow na mapie
  //    bot musi wiedziec jak jechac :)
  chkptn tmp;
  for(int y=0; y<HEIGHT; y++){
    for(int x=0; x<WIDTH; x++){
      if(mapa_point[y][x] > 0){
        tmp.x = x;
        tmp.y = y;
        tmp.i = mapa_point[y][x];
        check_pointy.push_back(tmp);
      }
    }
  }

  //wyliczanie "srednich" pozycji check pointow / sortowanie
  chkptn pointy[50];// narazie
  memset(pointy, 0, sizeof(pointy));
  for(unsigned int i=0; i<check_pointy.size(); i++){

    int n = (check_pointy[i].i+1)/2;

    if(!pointy[n].x){
      pointy[n].x = check_pointy[i].x;
      pointy[n].y = check_pointy[i].y;
      pointy[n].i = n;
    }else{
      pointy[n].x += check_pointy[i].x;
      pointy[n].y += check_pointy[i].y;
      pointy[n].x /= 2;
      pointy[n].y /= 2;
    }

  }

  // przepisanie pointow do wektora check pointow
  check_pointy.clear();
  check_pointy.push_back(pointy[0]); // zerowy 
  for(int i=1; i<50; i++){
    if(pointy[i].i == 0) break;
    check_pointy.push_back(pointy[i]);
  }

  // zamiana koordynatow z pozycji tablichowych na pixele
  //    nie potrzeba wtedy obliczac w petli dla botow
  //    przyspiesza obliczenia
  for(unsigned int i=1; i<check_pointy.size(); i++){

    check_pointy[i].x = 20+check_pointy[i].x*40;
    check_pointy[i].y = 20+check_pointy[i].y*40;

    // wypisanie
    printf("%d - %d, %d\n",
	check_pointy[i].i,
	check_pointy[i].x,
	check_pointy[i].y
    );
  }
  

}

// po zaonczeniu gry
void po(){
  check_pointy.clear();
  for(size_t i=0; i<Duchy.size(); i++) delete Duchy[i];
  Duchy.clear();
  if(window_full) m.pelenEkran(false); // naprawia probleny rozdzielczosci po wylaczeniu gry
}




// narazie dla debugu
     float nx;
     float ny;

void logika(){

 if(m.klawiatura['f']){
   m.klawiatura['f'] = false;
   if(!window_full){
     m.pelenEkran(true);
     window_full = 1;
   }else{
     m.pelenEkran(false);
     window_full = 0;
   }
   
 }

 switch(game_state){
  
   case GAME_STATE_CODE:
     if(m.klawiatura[K_ENTER]){
       m.klawiatura[K_ENTER] = false;
       game_state = GAME_STATE_MENU;
     }
     break;
  
  
   case GAME_STATE_MENU:

    if(m.klawiatura[K_UP] && menu_strzalka>0){
      m.klawiatura[K_UP] = false;
      menu_strzalka--;
    }
    if(m.klawiatura[K_DOWN] && menu_strzalka<1){
      m.klawiatura[K_DOWN] = false;
      menu_strzalka++;
    }

     if(m.klawiatura[K_ENTER]){
       m.klawiatura[K_ENTER] = false;
       if(menu_strzalka == 0){
         game_state = GAME_STATE_GAME;
         player_reset();
       }
       if(menu_strzalka == 1) m.wyjdz();
     }
     break;
  
  
   case GAME_STATE_GAME:

     // wlaczenie pauzy
     if(m.klawiatura['p']){
        m.klawiatura['p'] = false;
        if(menu_pauza) menu_pauza = 0; else menu_pauza = 1;
     }
     if(menu_pauza) return;

     // menu quit
     if(m.klawiatura['q']){
        m.klawiatura['q'] = false;
        if(menu_quit) menu_quit = 0; else menu_quit = 1;
     }
     if(menu_quit){
        if(m.klawiatura[K_ENTER]){
          m.klawiatura[K_ENTER] = false;
          menu_quit = 0;
          game_state = GAME_STATE_MENU;
        }
        return;
     }

     // odliczanie
     if(menu_34ry){
       menu_counter++;
       if(menu_counter > 100){
         menu_counter = 0;
         menu_34ry--;
       }
       return;
     }

     // sterowanie 
     //
     // ##################
     // ### DLA GRACZA ###
     // ##################
 
     // obracanie
     if(m.klawiatura[K_LEFT])      Gracz.W_lewo();
     if(m.klawiatura[K_RIGHT])     Gracz.W_prawo();

     // gazu!
          if(!menu_result && m.klawiatura[K_UP])   Gracz.Gazuj();
     else if(!menu_result && m.klawiatura[K_DOWN]) Gracz.Hamuj();
     else                          Gracz.Luz();


     // sterowanie
     //
     // ################
     // ### DLA BOTA ###
     // ################
     //
     // do sledzniea uzyte jest kilka bramek
     //   kat obierany jest wybierany na podstawie 
     //   odleglosci czym blizej celu tym bardziej ta nastepna
     //   bramka jest wazna
     //
     
     float eps = 2.0;

     // bramka docelowa
     unsigned int target_check = (Bot.p._n+1)/2+1;
     if(target_check >= check_pointy.size()) target_check=1;
     // bramka nastepna
     unsigned int next_check = target_check+1;
     if(next_check >= check_pointy.size())   next_check=1;


     // pozycje
     float bx   = Bot._x._x;
     float by   = Bot._x._y;
     float cpx2 = check_pointy[target_check].x;
     float cpy2 = check_pointy[target_check].y;
     float cpx3 = check_pointy[next_check].x;
     float cpy3 = check_pointy[next_check].y;

     // delty
     float dx2  = bx - cpx2; // bot - target
     float dy2  = by - cpy2; // bot - target


     // kwadraty odleglosci
     float r2   = dx2*dx2 + dy2*dy2; // bot - target


     // obliczenie kata wyrowania
     //   (szukanie nowego punktu do sledzenia)


     // czasem jest problem gdy bot ominie bramke nie moze do
     //  niej podjechac
     // okreslanie punktu sledzenia - koordynaty bramki + poprawka
     if(r2 > 25000){
       nx = cpx2 - 25*Bot._v._x; // 25 - wspolczynnik czulosci na predkosc
       ny = cpy2 - 25*Bot._v._y; // proba korekty kata - drift : )
     }else{
       nx = cpx3 - 25*Bot._v._x;
       ny = cpy3 - 25*Bot._v._y;
     }

     // kat miedzy odleglosciamy x i y bota i noergo punktu "sledzenia"
     float dx = bx - nx;
     float dy = by - ny;

     float a   = to_deg( atan2(dx , dy) );
     float ba  = Bot._a;                     // kat bota
     float da  = ba - a;

     // wyrownanie katow
     if(abs(da) > eps){
       if(da > 0.0){
         if(abs(da) < 180.0) Bot.W_prawo();
         else                Bot.W_lewo();
       }else{
         if(abs(da) < 180.0) Bot.W_lewo();
         else                Bot.W_prawo();
       }
     }


     // regulacja gazu
     if(abs(da) > 10.0 && Bot._v.mod() > 0.5){
       Bot.Luz();
     }else{
       if(!menu_result) Bot.Gazuj(); else Bot.Luz();
     }

 

     
     // ###############
     // ### KOLIZJE ###
     // ###############


     detektor_kolizji(Gracz, Bot);



     // ##############
     // ### FIZYKA ###
     // ##############


     Bot.Fizyka();
     Gracz.Fizyka(); 


     // ##################
     // ### ZASADY GRY ###
     // ##################

     Bot.Zasady_Gry();
     Gracz.Zasady_Gry();



     // usuwanie duchow
     for(size_t i = 0; i<Duchy.size(); i++){
       Duchy[i]->time--;
       if(Duchy[i]->time < 0){
         delete Duchy[i];
         Duchy.erase(Duchy.begin()+i);
         i=0;// od pocatku sprawdzanie
       }
     }

     // sprawdzanie kto pierwszy przejechal 4 okrazenia
     if(!menu_result){
       if(Gracz.lap == 4) menu_result = 1;
       if(Bot.lap   == 4) menu_result = 2;
     }

     break;

 } // switch
  
}

void scena(){
  int mpx = 0;
  int mpy = 0;


 switch(game_state){
 case GAME_STATE_CODE:
   code_masters.umiesc(player_pos_x, player_pos_y);//moje krypto ;]
   break;
 case GAME_STATE_MENU:
   micro_machine.umiesc(player_pos_x, player_pos_y);

   wypisz("szybka gra", 300, 300);
   wypisz("wyjscie", 300, 320);

   if(menu_strzalka == 0) strzalka.umiesc(260, 300);
   if(menu_strzalka == 1) strzalka.umiesc(260, 320);

   break;
 case GAME_STATE_GAME:

  // ======================
  // === RYSOWANIE MAPY ===
  // ======================


  mpx = Gracz._x._x / 40;
  mpy = Gracz._x._y / 40;


  int minx = 0;
  int maxx = WIDTH;
  int miny = 0;
  int maxy = HEIGHT;

  // ile wyswietlac mapy w x i y
  #define _X 9
  #define _Y 7

  if(mpx - _X > 0)      minx = mpx - _X;
  if(mpx + _X < WIDTH)  maxx = mpx + _X;

  if(mpy - _Y > 0)      miny = mpy - _Y;
  if(mpy + _Y < HEIGHT) maxy = mpy + _Y;



  // petle zredukowane z ilosci iteracji WIDTH*HEIGHT = 100*100 = 10000
  //  do 9*7 = 64 !!!!!!
  for(int y=miny; y<maxy; y++){
    for(int x=minx; x<maxx; x++){

      // wzgledem kamery
      //  zmiana koordynatow tablicowych na pixelowe
      mpx = 20+x*40 - Gracz._x._x + player_pos_x;
      mpy = 20+y*40 - Gracz._x._y + player_pos_y;

      // wyswietlanie terenu tylko gdy znajduje sie w obszacze roboczym
      //   to juz niepotrzebne bo reduguje petle gorna
      //       nie lece od 0 do WIDTH/HEIGHT
      //         wyswietlam tylko to oc potrzeba w danej chwili
      //if(mpx < m.szerokosc()+40 && mpx > -40
      //&& mpy < m.wysokosc()+40 && mpy > -40){

        // wyswietlanie podloza
        ground.umiesc_ramke(mpx,mpy, mapa[y][x]);

        // wyswietlanie check pointow
        if(mapa_point[y][x])
          point.umiesc_ramke(
		mpx,
		mpy,
		(mapa_point[y][x])%2
          );


        // wyswietlanie itemow itemy
        // TODO

      //} // zredukowano
    }
  }

  // temp
/*
  // sprawdzanie check pointow dla bota
  for(int i=1; i<check_pointy.size(); i++)
    prost.umiesc(
	check_pointy[i].x - (Gracz._x._x - player_pos_x),
	check_pointy[i].y - (Gracz._x._y - player_pos_y)
    );
*/


  // rysowanie duchow
  for(size_t i=0; i<Duchy.size(); i++){
    duch.obroc(Duchy[i]->_a);
    duch.umiesc(
      Duchy[i]->_x._x - (Gracz._x._x - player_pos_x),
      Duchy[i]->_x._y - (Gracz._x._y - player_pos_y)
    );
  }




  // rysowanie pojazdu Bota
  float bx = Bot._x._x - (Gracz._x._x - player_pos_x);
  float by = Bot._x._y - (Gracz._x._y - player_pos_y);


  // tylko gdy znajduje sie w obszarze roboczym
  if(bx > -40.0 && bx < m.szerokosc()+40 
  && by > -40.0 && by < m.wysokosc()+40){

    // debug detekcji kolizji
    //kol.umiesc(bx, by);

    bot.obroc(Bot._a);
    bot.umiesc(bx, by);
  }

 // debug detekcji kolizji
 // kol.umiesc(player_pos_x, player_pos_y);

  // rysowanie pojazdu Gracza
  car.obroc(Gracz._a);
  car.umiesc(player_pos_x, player_pos_y); // gracza wyswietlam na srodku



// debug punktu sledzenia bota
/*
     prost.umiesc(
	nx - (Gracz._x._x - player_pos_x),
	ny - (Gracz._x._y - player_pos_y)
    );
*/

  if(menu_result){
    prostok.umiesc(320, 240);
    if(menu_result == 1) wypisz("win", 320-20, 240);
    if(menu_result == 2) wypisz("loose", 320-20, 240);
  }


  if(menu_pauza){
    prostok.umiesc(320, 240);
    wypisz("pause", 320-20, 240);
  }
  if(menu_quit){
    prostok2.umiesc(320, 240);
    wypisz("quit menu", 320-40, 215);
    wypisz("enter  quit", 320-50, 245);
    wypisz("q  continue", 320-50, 265);
  }
  char l[] = "9";
  if(menu_34ry){
    prostok.umiesc(320, 240);
    *l = menu_34ry+'0';// szybka konwersja na stringa
    wypisz(l, 320, 240);
  }

  *l = Gracz.lap+'0';// szybka konwersja na stringa
  wypisz(l, 20, 20);
  *l = Bot.lap+'0';// szybka konwersja na stringa
  wypisz(l, 620, 20);
 

  break;
 }
}


int main(int argc, char **argv){
m.ustaw(logika,scena);pre();m.start();po();return 0;(void)argc;(void)argv;
}



