#include "SDL/SDL.h"
#include <cmath>

#define ROTOZOOMON ROTOZOOMON

// Opis dostepny pod adresem:
//   http://www.fizyka.umk.pl/~244647/frameworksdl/3.0/opis.html
//
//
//                  .-+*##+                        .-+#%-   .++##*.   
//                +%-                            +%-      -##.        
//              _%?+                           .%?-      +?%.         
//             .??#                            %?#      _??-          
//             #?%.        .-+*#*-       .-+###??.      %?#           
//        _+++*??#+++_   .#+   _-     .+#-   -??+      +??.           
//           .%?#       .??+         -?#     *?%       %?+            
//           *?%.        -%??#+.    _?%     _??-      *?%             
//          _??-           .+%?+    %?+     #?%    . .??-    .        
//          #?#     .#%*    _%+    -??+ _++*??*.---. #??-_---.        
//         -?%.      *%?#+--_      .%%#+_  +%#+_     *?#+_            
//        .%%.                                                        
//        ##.                                                         
//   .__+*_                                                           
//   _+-                                                              
//
// -- asciart
// by AdrianLaskowski
// 

#ifdef ROTOZOOMON
#include "SDL/SDL_rotozoom.h"
#include "SDL/SDL_rotozoom.c"
#endif

// v 3.0

// Wymagania: pliki SDL_rotozoom.h i SDL_rotozoom.c zainstalowany SDL
//   (jezeli jest w innej lokalizacji zmienic sciezke w #include ...
//     najlepiej w folderze z projektem.)
//
// plik SDL.dll lub SDL.so(linux) lub inny odpowiednik

#define K_UP 1
#define K_DOWN 2
#define K_LEFT 3
#define K_RIGHT 4
#define K_SPACE 5
#define K_ENTER 6
#define K_CONTROL 7
#undef main


class obiekt{
 public:
  int x;
  int y;
  int w;
  int h;
};

class tekstura : public obiekt{
 private:
  SDL_Surface* tex;
  SDL_Surface* org;
  SDL_Surface* _okno;
  SDL_Rect poz;
  SDL_Rect roz;
  float stare_alfa;
  int frame_w;
  int frame_h;
 public:
  tekstura(SDL_Surface* _okno, const char* n):_okno(_okno){
   SDL_Surface* t = SDL_LoadBMP(n);
   tex = SDL_DisplayFormat(t);
   SDL_FreeSurface(t);
   org = tex;
   obiekt::w = tex->w;
   obiekt::h = tex->h;
   frame_w = tex->w;
   frame_h = tex->h;
   stare_alfa = 0.0;
  }

  tekstura(SDL_Surface* _okno, const char* n, size_t c):_okno(_okno){
   SDL_Surface* t = SDL_LoadBMP(n);
   tex = SDL_DisplayFormat(t);
   stare_alfa = 0.0;
   org = tex; // nie wiem co za roznica jakbym zrobil SDL_DisplayFormat(t)
   // ale w pewnych przypadkach nie dziala dobrze !!!!!
   SDL_FreeSurface(t);
   obiekt::w = tex->w;
   obiekt::h = tex->h;
   frame_w = tex->w;
   frame_h = tex->h;
   Uint32 k = SDL_MapRGB( _okno->format, (c&0xff0000)>>16, (c&0xff00)>>8, c&0xff );
   SDL_SetColorKey(tex, SDL_SRCCOLORKEY | SDL_RLEACCEL, k);
  }


  ~tekstura(){
   SDL_FreeSurface(tex);
  }
  void ustaw_ramke(int fw, int fh){
    frame_w = fw;
    frame_h = fh;
  }

  void umiesc_ramke(float x, float y, int f){//f-przesuniecie klatki (nie mozna obracac!!!!)
   poz.x = x - frame_w/2;
   poz.y = y - frame_h/2;
   obiekt::x=x;
   obiekt::y=y;
   roz.w=frame_w;
   roz.h=frame_h;
   roz.x=frame_w*f;
   SDL_BlitSurface(tex, &roz, _okno, &poz);
  }
 
  void umiesc(float x, float y){
   poz.x = x - tex->w/2;
   poz.y = y - tex->h/2;
   obiekt::x=x;
   obiekt::y=y;
   SDL_BlitSurface(tex, 0, _okno, &poz);
  }


#ifdef ROTOZOOMON
  void obroc(float alfa){
   if(alfa == stare_alfa) return;
   tex = rotozoomSurface(org, (int)alfa % 360, 1, 0);
   obiekt::w = tex->w;
   obiekt::h = tex->h;
   stare_alfa = alfa;
  }
#endif


  void przezroczystosc(size_t c){
   Uint32 k = SDL_MapRGB( _okno->format, (c&0xff0000)>>16, (c&0xff00)>>8, c&0xff );
   SDL_SetColorKey(tex, SDL_SRCCOLORKEY | SDL_RLEACCEL, k);
  }

  float szerokosc(){   return tex->w;  }
  float wysokosc(){   return tex->h;  }
};


class prostokat : public obiekt{
 private:
  //int w;
  //int h;
  SDL_Rect poz;
  SDL_Surface* _okno;
  Uint32 _kolor;
 public:
  float szerokosc(){   return w;  }
  float wysokosc(){   return h;  }
  prostokat(SDL_Surface* _okno, int w, int h, size_t c){
   this->_okno = _okno;
   obiekt::w = w;
   obiekt::h = h;
   _kolor = SDL_MapRGB( _okno->format, (c&0xff0000)>>16, (c&0xff00)>>8, c&0xff );
  }

  void kolor(size_t c){
   _kolor = SDL_MapRGB( _okno->format, (c&0xff0000)>>16, (c&0xff00)>>8, c&0xff );
  }

  void umiesc(float x, float y){
   poz.w = w;
   poz.h = h;
   poz.x=x - w/2;
   poz.y=y - h/2;
   obiekt::x = x;
   obiekt::y = y;
   SDL_FillRect(_okno, &poz, _kolor);
  }
};



class linia{
 private:
  prostokat p;
 public:
  linia(SDL_Surface* okno, size_t c):p(okno, 1, 1, c){}

  void umiesc(float x1, float y1, float x2, float y2){
    float dx=x2-x1;
    float dy=y2-y1;
    if(abs(dx) - abs(dy) > 0 && abs(dx) + abs(dy) > 0 ){
     if(x1 > x2) for(int i=x2; i<=x1; i++) p.umiesc(i, y2+(i-x2)*dy/dx);
     else        for(int i=x1; i<=x2; i++) p.umiesc(i, y1+(i-x1)*dy/dx);
    }else{
     if(y1 > y2) for(int i=y2; i<=y1; i++) p.umiesc(x2+(i-y2)*dx/dy, i);
     else        for(int i=y1; i<=y2; i++) p.umiesc(x1+(i-y1)*dx/dy, i);
    }
  }
 
  void kolor(size_t c){
   p.kolor(c);
  }

};





class okrag : public obiekt{
 private:
  //prostokat* p;
  linia* l;
  SDL_Surface* _okno;
  float R;
 public:
  okrag(SDL_Surface* _okno, float r, size_t c=0xffffff){
   this->R = r;
   this->_okno = _okno;
   l = new linia(_okno, c);

  }
  ~okrag(){delete l;}
  void kolor(size_t c){
    l->kolor(c);
  }
  void promien(float r){
    this->R = r;
  }
  void umiesc(float x, float y){

   int r2 = (int)R*(int)R;
   int r = (int)R;
   
   // +
   //  x^2 + y^2 = r^2  =>   y = sqrt(r^2 - x^2);
   int x1 = (int)x - r;
   int y1 = (int)y;
   int x2;
   int y2;
   for(  int i = -r+1; i<r+1; i++){
     x2 = (int)x + i;
     y2 = (int)y + sqrt(r2 - i*i);
     l->umiesc(x1, y1, x2, y2);
     x1 = x2;
     y1 = y2;
   }

   // -
   x1 = (int)x - r;
   y1 = (int)y;
   for(  int i = -r+1; i<r+1; i++){
     x2 = (int)x + i;
     y2 = (int)y - sqrt(r2 - i*i);
     l->umiesc(x1, y1, x2, y2);
     x1 = x2;
     y1 = y2;
   }


  }
};








class kolo : public obiekt{
 private:
  //prostokat* p;
  linia* l;
  //SDL_Rect poz;
  //Uint32 _kolor;
  SDL_Surface* _okno;
  float R;
 public:
  kolo(SDL_Surface* _okno, float r, size_t c=0xffffff){
   this->R = r;
   this->_okno = _okno;
   //p = new prostokat(_okno, 1, 1, c);
   l = new linia(_okno, c);
   //poz.w = 1;
   //poz.h = 1;
   //_kolor = SDL_MapRGB( _okno->format, (c&0xff0000)>>16, (c&0xff00)>>8, c&0xff );
  }
  ~kolo(){delete l;}
  void kolor(size_t c){
   l->kolor(c);
   //_kolor = SDL_MapRGB( _okno->format, (c&0xff0000)>>16, (c&0xff00)>>8, c&0xff );
   //p->kolor(c);
  }
  void promien(float r){
    this->R = r;
  }
  void umiesc(float x, float y){
   //int r_2 = (int)R/2;
   int r2 = (int)R*(int)R;
   int r = (int)R;

   //int x1 = (int)x - r;
   int y2 = (int)y;
   //int x2;
//   int y2;
   for(  int i = -r; i<r; i++){
     //x2 = (int)x + i;
     y2 =  sqrt(r2 - i*i);
     l->umiesc((int)x + i, (int)y - y2, (int)x + i, (int)y + y2);
     //x1 = x2;
     //y1 = y2;
   }


/*
   for(  int i = -r; i<r; i++){
     for(int j = -r; j<r; j++){
       if(i*i + j*j < r2){//rownanie okregu
         poz.x = (int)x - r_2 + i;
         poz.y = (int)y - r_2 + j;
         SDL_FillRect(_okno, &poz, _kolor);
       }
     }
   }
*/

   //x+=promien;//wysrodkowanie koordynatow kola
   //float r = (promien); // 0.1 doswiadczalnie
   //float r2 = r*r;
/*
   for(float i=-promien+0.5; i<=promien-0.5; i++){
    p->h=2*sqrt(r2-i*i);
    p->umiesc(x+(i-r), y);
   }
*/
  }//umiesc
};


class fsdl{
 private:
  SDL_Surface* _okno;
  int w;
  int h;
  int bpp;
  size_t fps;
  const char* _tytul;
  bool full_scr;

  Uint32 _czas;
  Uint32 _czas_t;
  SDL_Event zdarzenie;
  int wlaczony;
  void (*logika)();
  void (*scena)();

 public:

  struct mysz{
   float x;
   float y;
   bool lewy;
   bool prawy;
  }myszka;
  bool klawiatura[0xff];

  fsdl(size_t fps, int w, int h, int bpp, const char* _tytul)
:w(w),h(h),bpp(bpp),_tytul(_tytul){
   this->fps = fps;
   SDL_Init(SDL_INIT_EVERYTHING);
   _okno=SDL_SetVideoMode(w, h, bpp, SDL_HWSURFACE);
   full_scr = false;
   SDL_WM_SetCaption(_tytul, NULL);
 //SDL_EnableKeyRepeat(SDL_DEFAULT_REPEAT_DELAY, SDL_DEFAULT_REPEAT_INTERVAL);
   _czas = 0;
   wlaczony = 0;
  }

  void pelenEkran(bool x){
    if(x){
      _okno=SDL_SetVideoMode(w, h, bpp, SDL_FULLSCREEN);
     full_scr = true;
    }else{
      _okno=SDL_SetVideoMode(w, h, bpp, SDL_HWSURFACE);
     full_scr = false;
	    }
  }

  unsigned int czas(){
   return SDL_GetTicks();
  }

  void ustaw(void (*logika)(), void (*scena)()){
   this->logika = logika;
   this->scena = scena;
 }
  ~fsdl(){
   SDL_Quit();
   (void)_okno;
  }
  SDL_Surface* okno(){  return _okno;  }
  int szerokosc(){   return w;  }
  int wysokosc(){   return h;  }
  void tytul(const char* t){   _tytul = t;  }
  void wyjdz(){   wlaczony = 0;  }
  void start(){
   wlaczony = 1;
   for(int i=0; i<0xff; i++) klawiatura[i]=false;
   while(wlaczony){

    _czas = SDL_GetTicks();
    if(_czas - _czas_t < 1000/fps) continue; 
    _czas_t = SDL_GetTicks();

    // obsluga rownomiernego opoznienia
/*
    if(1000/fps > SDL_GetTicks() - _czas)
     SDL_Delay(1000/fps-(SDL_GetTicks()-_czas));
    // powoduje problemy z wcisnieciami klawiszy
*/



    while(SDL_PollEvent(&zdarzenie)){
     switch(zdarzenie.type){
      case SDL_QUIT:
       wlaczony = 0;
       break;

      case SDL_KEYDOWN:
       if(zdarzenie.key.keysym.sym == SDLK_ESCAPE) wlaczony = 0;
       if(zdarzenie.key.keysym.sym == SDLK_UP) klawiatura[K_UP]=true;
       if(zdarzenie.key.keysym.sym == SDLK_DOWN) klawiatura[K_DOWN]=true;
       if(zdarzenie.key.keysym.sym == SDLK_LEFT) klawiatura[K_LEFT]=true;
       if(zdarzenie.key.keysym.sym == SDLK_RIGHT) klawiatura[K_RIGHT]=true;
       if(zdarzenie.key.keysym.sym == SDLK_SPACE) klawiatura[K_SPACE]=true;
       if(zdarzenie.key.keysym.sym == SDLK_RETURN) klawiatura[K_ENTER]=true;

       if(zdarzenie.key.keysym.sym == SDLK_a) klawiatura['a']=true;
       if(zdarzenie.key.keysym.sym == SDLK_b) klawiatura['b']=true;
       if(zdarzenie.key.keysym.sym == SDLK_c) klawiatura['c']=true;
       if(zdarzenie.key.keysym.sym == SDLK_d) klawiatura['d']=true;
       if(zdarzenie.key.keysym.sym == SDLK_e) klawiatura['e']=true;
       if(zdarzenie.key.keysym.sym == SDLK_f) klawiatura['f']=true;
       if(zdarzenie.key.keysym.sym == SDLK_g) klawiatura['g']=true;
       if(zdarzenie.key.keysym.sym == SDLK_h) klawiatura['h']=true;
       if(zdarzenie.key.keysym.sym == SDLK_i) klawiatura['i']=true;
       if(zdarzenie.key.keysym.sym == SDLK_j) klawiatura['j']=true;
       if(zdarzenie.key.keysym.sym == SDLK_k) klawiatura['k']=true;
       if(zdarzenie.key.keysym.sym == SDLK_l) klawiatura['l']=true;
       if(zdarzenie.key.keysym.sym == SDLK_m) klawiatura['m']=true;
       if(zdarzenie.key.keysym.sym == SDLK_n) klawiatura['n']=true;
       if(zdarzenie.key.keysym.sym == SDLK_o) klawiatura['o']=true;
       if(zdarzenie.key.keysym.sym == SDLK_p) klawiatura['p']=true;
       if(zdarzenie.key.keysym.sym == SDLK_q) klawiatura['q']=true;
       if(zdarzenie.key.keysym.sym == SDLK_r) klawiatura['r']=true;
       if(zdarzenie.key.keysym.sym == SDLK_s) klawiatura['s']=true;
       if(zdarzenie.key.keysym.sym == SDLK_t) klawiatura['t']=true;
       if(zdarzenie.key.keysym.sym == SDLK_u) klawiatura['u']=true;
       if(zdarzenie.key.keysym.sym == SDLK_v) klawiatura['v']=true;
       if(zdarzenie.key.keysym.sym == SDLK_w) klawiatura['w']=true;
       if(zdarzenie.key.keysym.sym == SDLK_x) klawiatura['x']=true;
       if(zdarzenie.key.keysym.sym == SDLK_y) klawiatura['y']=true;
       if(zdarzenie.key.keysym.sym == SDLK_z) klawiatura['z']=true;


       break;



      case SDL_KEYUP:
       if(zdarzenie.key.keysym.sym == SDLK_UP) klawiatura[K_UP]=false;
       if(zdarzenie.key.keysym.sym == SDLK_DOWN) klawiatura[K_DOWN]=false;
       if(zdarzenie.key.keysym.sym == SDLK_LEFT) klawiatura[K_LEFT]=false;
       if(zdarzenie.key.keysym.sym == SDLK_RIGHT) klawiatura[K_RIGHT]=false;
       if(zdarzenie.key.keysym.sym == SDLK_SPACE) klawiatura[K_SPACE]=false;
       if(zdarzenie.key.keysym.sym == SDLK_RETURN) klawiatura[K_ENTER]=false;

       if(zdarzenie.key.keysym.sym == SDLK_a) klawiatura['a']=false;
       if(zdarzenie.key.keysym.sym == SDLK_b) klawiatura['b']=false;
       if(zdarzenie.key.keysym.sym == SDLK_c) klawiatura['c']=false;
       if(zdarzenie.key.keysym.sym == SDLK_d) klawiatura['d']=false;
       if(zdarzenie.key.keysym.sym == SDLK_e) klawiatura['e']=false;
       if(zdarzenie.key.keysym.sym == SDLK_f) klawiatura['f']=false;
       if(zdarzenie.key.keysym.sym == SDLK_g) klawiatura['g']=false;
       if(zdarzenie.key.keysym.sym == SDLK_h) klawiatura['h']=false;
       if(zdarzenie.key.keysym.sym == SDLK_i) klawiatura['i']=false;
       if(zdarzenie.key.keysym.sym == SDLK_j) klawiatura['j']=false;
       if(zdarzenie.key.keysym.sym == SDLK_k) klawiatura['k']=false;
       if(zdarzenie.key.keysym.sym == SDLK_l) klawiatura['l']=false;
       if(zdarzenie.key.keysym.sym == SDLK_m) klawiatura['m']=false;
       if(zdarzenie.key.keysym.sym == SDLK_n) klawiatura['n']=false;
       if(zdarzenie.key.keysym.sym == SDLK_o) klawiatura['o']=false;
       if(zdarzenie.key.keysym.sym == SDLK_p) klawiatura['p']=false;
       if(zdarzenie.key.keysym.sym == SDLK_q) klawiatura['q']=false;
       if(zdarzenie.key.keysym.sym == SDLK_r) klawiatura['r']=false;
       if(zdarzenie.key.keysym.sym == SDLK_s) klawiatura['s']=false;
       if(zdarzenie.key.keysym.sym == SDLK_t) klawiatura['t']=false;
       if(zdarzenie.key.keysym.sym == SDLK_u) klawiatura['u']=false;
       if(zdarzenie.key.keysym.sym == SDLK_v) klawiatura['v']=false;
       if(zdarzenie.key.keysym.sym == SDLK_w) klawiatura['w']=false;
       if(zdarzenie.key.keysym.sym == SDLK_x) klawiatura['x']=false;
       if(zdarzenie.key.keysym.sym == SDLK_y) klawiatura['y']=false;
       if(zdarzenie.key.keysym.sym == SDLK_z) klawiatura['z']=false;


       break;

      case SDL_MOUSEMOTION:
       myszka.x = zdarzenie.motion.x;
       myszka.y = zdarzenie.motion.y;
       break;
      case SDL_MOUSEBUTTONDOWN:
       if(zdarzenie.button.button == SDL_BUTTON_LEFT)  myszka.lewy = true;
       if(zdarzenie.button.button == SDL_BUTTON_RIGHT) myszka.prawy = true;
       break;
      case SDL_MOUSEBUTTONUP:
       if(zdarzenie.button.button == SDL_BUTTON_LEFT)  myszka.lewy = false;
       if(zdarzenie.button.button == SDL_BUTTON_RIGHT) myszka.prawy = false;
       break;
     }
    }

    logika();

    SDL_FillRect(_okno, 0, 0); //czysci _okno
    scena(); 
    SDL_Flip(_okno); // wyswietla na ektranie bufor okna

   }
  } // end start()
};


