// Piatek1.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include <stdexcept>
#include <iostream>
#include <fstream>
using namespace std;

//fizyka
double rzut(int i,double* y,double t) //1D
{
	static const double g=9.81;

	double wynik=0;
	switch(i)
	{
	case 0:
		wynik=y[1];
		break;
	case 1:
		wynik=g;
		break;
	default:
		throw runtime_error("Zy numer rwnania");
	}

	return wynik;
}

double oscylator(int i,double* y,double t) //1D
{
	static const double w=1;

	double wynik=0;
	switch(i)
	{
	case 0:
		wynik=y[1];
		break;
	case 1:
		wynik=-w*w*y[0];
		break;
	default:
		throw runtime_error("Zy numer rwnania");
	}

	return wynik;
}


//numeryka
double* odeint_Euler(int N,double (*f)(int,double*,double),double* y,double t,double h,double* y_nast)
{
	for(int i=0;i<N;++i) y_nast[i]=y[i]+h*f(i,y,t);
	return y_nast;
}


double* odeint_MidPoint(int N,double (*f)(int,double*,double),double* y,double t,double h,double* y_nast)
{
	double* y_tmp=new double[N];	
	for(int i=0;i<N;++i)
	{
		double k1=h*f(i,y,t);
		y_tmp[i]=y[i]+0.5*k1;
	}
	for(int i=0;i<N;++i)
	{
		double k2=h*f(i,y_tmp,t+0.5*h);
		y_nast[i]=y[i]+k2;
	}
	delete [] y_tmp;
	return y_nast;
}

double* odeint_RK4(int N,double (*f)(int,double*,double),double* y,double t,double h,double* y_nast)
{
	double* y_tmp=new double[N];
	double* k1=new double[N];
	double* k2=new double[N];
	double* k3=new double[N];
	double* k4=new double[N];
	for(int i=0;i<N;++i)
	{
		k1[i]=h*f(i,y,t);
		y_tmp[i]=y[i]+0.5*k1[i];
	}
	for(int i=0;i<N;++i)
	{
		k2[i]=h*f(i,y_tmp,t+0.5*h);
		y_nast[i]=y[i]+0.5*k2[i];
	}
	for(int i=0;i<N;++i)
	{
		k3[i]=h*f(i,y_nast,t+0.5*h);
		y_tmp[i]=y[i]+k3[i];
	}
	for(int i=0;i<N;++i)
	{
		k4[i]=h*f(i,y_tmp,t+h);
		y_nast[i]=y[i]+(k1[i]+2.0*k2[i]+2.0*k3[i]+k4[i])/6.0;
	}
	delete [] y_tmp;
	delete [] k1;
	delete [] k2;
	delete [] k3;
	delete [] k4;
	return y_nast;
}

double* odeint_RK4F5(int N,double (*f)(int,double*,double),double* y,double t,/*out*/double& h,double* y_nast)
{
	const static double b31=3.0/32.0;
	const static double b32=9.0/32.0;
	const static double a3=3.0/8.0;

	const static double b41=1932.0/2197.0;
	const static double b42=-7200/2197.0;
	const static double b43=7296.0/2197.0;
	const static double a4=12.0/13.0;

	const static double b51=439.0/216.0;
	const static double b53=3680.0/513.0;
	const static double b54=-845.0/4104.0;

	const static double w41=25.0/216.0;
	const static double w43=1408.0/2565.0;
	const static double w44=2197.0/4104.0;

	const static double b61=-8.0/27.0;
	const static double b63=-3544.0/2565.0;
	const static double b64=1859.0/4104.0;
	const static double b65=-11.0/40.0;

	const static double w51=16.0/135.0;
	const static double w53=6656.0/12825.0;
	const static double w54=28561.0/56430.0;
	const static double w55=-9.0/50.0;
	const static double w56=2.0/55.0;

	double* y_tmp=new double[N];
	double* y4_nast=new double[N];
	double* k1=new double[N];
	double* k2=new double[N];
	double* k3=new double[N];
	double* k4=new double[N];
	double* k5=new double[N];
	double* k6=new double[N];
	double blad = 0;
	const double blad_min=1E-16;
	const double blad_max=1E-14;
	
	do
	{
	for(int i=0;i<N;++i)
	{
		k1[i]=h*f(i,y,t);
		y_tmp[i]=y[i]+0.25*k1[i];
	}
	for(int i=0;i<N;++i)
	{
		k2[i]=h*f(i,y_tmp,t+0.25*h);
		y_nast[i]=y[i]+b31*k1[i]+b32*k2[i];
	}
	for(int i=0;i<N;++i)
	{
		k3[i]=h*f(i,y_nast,t+a3*h);
		y_tmp[i]=y[i]+b41*k1[i]+b42*k2[i]+b43*k3[i];
	}
	for(int i=0;i<N;++i)
	{
		k4[i]=h*f(i,y_tmp,t+a4*h);
		y_nast[i]=y[i]+b51*k1[i]-8.0*k2[i]+b53*k3[i]+b54*k4[i];
	}
	for(int i=0;i<N;++i)
	{
		k5[i]=h*f(i,y_nast,t+h);
		y4_nast[i]=y[i]+w41*k1[i]+w43*k3[i]+w44*k4[i]-0.2*k5[i]; //RK4 (5 wyrazow)
		y_tmp[i]=y[i]+b61*k1[i]+2*k2[i]+b63*k3[i]+b64*k4[i]+b65*k5[i];
	}
	blad = 0;
	for(int i=0;i<N;++i)
	{
		k6[i]=h*f(i,y_tmp,t+0.5*h);
		y_nast[i]=y[i]+w51*k1[i]+w53*k3[i]+w54*k4[i]+w55*k5[i]+w56*k6[i]; //RK5 (6 wyrazow)
		blad+=fabs(y_nast[i]-y4_nast[i]);
	}
	if(blad>blad_max) h/=2;
	if(blad<blad_min) h*=2;
#ifdef _DEBUG
	cout << "blad=" << blad << ", h=" << h << "\n";
#endif
	}
	while(blad<blad_min || blad>blad_max);

	delete [] y_tmp;
	delete [] k1;
	delete [] k2;
	delete [] k3;
	delete [] k4;

	return y_nast;
}

/*
template<typename T>
T* odeint_Euler(int N,T (*f)(int,T*,T),T* y,T t,T h,T* y_nast)
{
	for(int i=0;i<N;++i) y_nast[i]=y[i]+h*f(i,y,t);
	return y_nast;
}
*/

int _tmain(int argc, _TCHAR* argv[])
{
	const int N=2; //1D
	double* y=new double[N];
	double* y_nast=new double[N];
	for(int i=0;i<N;++i)
	{
		y[i]=0;
		y_nast[i]=0;
	}
	y[0]=1;
	const double tmax=100;
	double h=0.001;

	ofstream plik_wy("wyniki.dat");
	plik_wy.precision(10);
	plik_wy.setf(ios::scientific);

	for(double t=0;t<tmax;t+=h)
	{
#ifdef _DEBUG
		cout << "t=" << t << ", x=" << y[0] << ", v=" << y[1] << "\n";
#endif
		plik_wy << t << "\t" << y[0] << "\t" << y[1] << "\t" << h << "\n";

		//odeint_Euler(N,rzut,y,t,h,y_nast);
		//odeint_MidPoint(N,rzut,y,t,h,y_nast);		
		//odeint_Euler(N,oscylator,y,t,h,y_nast);		
		//odeint_MidPoint(N,oscylator,y,t,h,y_nast);		
		//odeint_RK4(N,oscylator,y,t,h,y_nast);
		odeint_RK4F5(N,oscylator,y,t,h,y_nast);

		//brzydkie
		//for(int i=0;i<N;++i) y[i]=y_nast[i];
		
		double* y_tmp=y_nast;
		y_nast=y;
		y=y_tmp;

		//swap(y,y_nast);
	}

	plik_wy.close();

	delete [] y_nast;
	delete [] y;

	cout << "OK.\n\n";

	return 0;
}

