#include "SampleActorsGame.h"

SampleActorsGame::SampleActorsGame()
{
	this->preferAntialising(4);
}

void SampleActorsGame::initialize()
{
	SampleGame::initialize();

	planeMaterial = Material(Color::Black);

	camera->lookAt(PxVec3(40, 50, 40), PxVec3(0, 0, 0));

	//tu dodaj aktorow
}

void SampleActorsGame::release()
{
	SampleGame::release();
}

void SampleActorsGame::input(GxF32 elapsedTime)
{
	SampleGame::input(elapsedTime);

	//tu sterowanie

	const GxF32 fps = getStepper().getFps();
	std::stringstream stream;
	stream << "Sample Actors | Fps: " << std::fixed << std::setprecision(1) << fps 
		<< " | Dynamic actors: " << scene->getNbActors(PxActorTypeSelectionFlag::eRIGID_DYNAMIC)
		<< " | Static actors: " << scene->getNbActors(PxActorTypeSelectionFlag::eRIGID_STATIC)
		<< " | Camera position: " << camera->getPosition().x << " ; " << camera->getPosition().y << " ; " << camera->getPosition().z;

	this->setTitle(stream.str());
}

void SampleActorsGame::update(GxF32 elapsedTime)
{
	SampleGame::update(elapsedTime);
}

void SampleActorsGame::render(GxF32 elapsedTime)
{
	SampleGame::render(elapsedTime);

	graphics->clear(Color::CornflowerBlue);

	effect->bind();
	effect->setProjMatrix(projectionMtx);
	effect->setViewMatrix(camera->getViewMatrix());

	this->renderScene(scene);

	effect->unbind();
}

void SampleActorsGame::printHelp()
{
	SampleGame::printHelp();

	std::cout << "Spacja - rzucenie pudelkiem w kierunku patrzenia" << std::endl
		<< "K - przelaczenie miedzy trybami kamery FPP - TPP" << std::endl << std::endl
		<< "# Sterowanie aktorem kinetycznym" << std::endl
		<< "Aktorem kinetycznym sterujemy za pomoca klawiszy strzalek oraz myszki." << std::endl;
}
