#include "sampleboxgame.h"

SampleBoxGame::SampleBoxGame()
{
}

void SampleBoxGame::initialize()
{
	SampleGame::initialize();

	//dodaj material, ksztalt, pozycje, orientacje i aktora
	//stworz plaszczyzne i box w PhysX

	planeMesh = MeshHelper::createGrid(graphics, 20, 40);

	camera->lookAt(PxVec3(0, 30, 30), PxVec3(0,5,0));
}

void SampleBoxGame::release()
{
	SampleGame::release();
}

void SampleBoxGame::input(GxF32 elapsedTime)
{
	SampleGame::input(elapsedTime);
}

void SampleBoxGame::update(GxF32 elapsedTime)
{
	SampleGame::update(elapsedTime);
}

void SampleBoxGame::render(GxF32 elapsedTime)
{
	SampleGame::render(elapsedTime);

	graphics->clear(Color::CornflowerBlue);

	effect->bind();
	effect->setProjMatrix(projectionMtx);
	effect->setViewMatrix(camera->getViewMatrix());

	effect->setModelMatrix(MathHelper::createIdentity());
	graphics->renderMesh(effect, planeMesh);

	//uzyj pozycji do ustawienia szescianu

	effect->unbind();
}