﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Verlet
{
    class Program
    {
        static double ObliczPrzyspieszenieOscylatora(double x)
        {
            const double k = 1;
            const double m = 1;
            return -k * x / m;
        }

        static void OdeInt_Euler(double x, double v, double a, double h, out double x_nast, out double v_nast)
        {
            v_nast = v + a * h;
            x_nast = x + v * h;
        }

        static void OdeInt_EulerPoprawiony(double x, double v, double a, double h, out double x_nast, out double v_nast)
        {
            v_nast = v + a * h;
            x_nast = x + v_nast * h;
        }

        static void OdeInt_Verlet(double x, double x_poprz, double a, double h, out double x_nast/*, out double v*/)
        {
            x_nast = 2 * x - x_poprz + a * h * h;
            //v = (x_nast-x_poprz)/(2*h);
        }

        static void OdeInt_VerletPredkosciowy(double x, double v, Func<double,double> a, double h, out double x_nast, out double v_nast)
        {
            double _a = a(x);
            x_nast = x + v * h + _a * h * h / 2;
            v_nast = v + (_a + a(x_nast)) * h / 2;
        }

        static void OdeInt_VerletSkokowy(double x, double v, double a, double h, out double x_nast, out double v_nast)
        {
            //to samo, co Euler poprawiony, ale inna interpretacja prędkości (przesunięte w tył o h/2)
            v_nast = v + a * h;
            x_nast = x + v_nast * h;
        }

        static void Main(string[] args)
        {
            double x = 0, v = 1;

            double tmax = 10;
            double h = 0.01;

            double x_poprz = x;
            double x_nast,v_nast;
            
            for(double t = 0;t<tmax;t+=h)
            {
                //OdeInt_Euler(x, v, ObliczPrzyspieszenieOscylatora(x), h, out x_nast, out v_nast);
                //OdeInt_EulerPoprawiony(x, v, ObliczPrzyspieszenieOscylatora(x), h, out x_nast, out v_nast);
                OdeInt_VerletPredkosciowy(x, v, ObliczPrzyspieszenieOscylatora, h, out x_nast, out v_nast);
                
                //if (t == 0) OdeInt_EulerPoprawiony(x, v, ObliczPrzyspieszenieOscylatora(x), h, out x_nast, out v_nast);
                //else OdeInt_Verlet(x, x_poprz, ObliczPrzyspieszenieOscylatora(x), h, out x_nast);
                
                x_poprz = x;
                x = x_nast;
                v = v_nast;
                Console.WriteLine(("" + t + "\t" + x + "\t" + v).Replace(',', '.'));
            }
        }
    }
}
