#pragma once

#ifndef __texture_h__
	#define __texture_h__

#include "foundation.h"
#include "graphicsresource.h"
#include "gxopengl.h"

namespace Gx
{
	class GX_API Texture2D : public GraphicsResource
	{
	public:
		Texture2D();
		~Texture2D();

		void setWrap(GLenum wrapMode);
		void setWrapU(GLenum wrapMode);
		void setWrapV(GLenum wrapMode);

		void setMinifyFilter(GLenum filter);
		void setMagnifyFilter(GLenum filter);
		void setAnisotropicFilter(GLfloat anisotropy);

		void setData(GLenum dataFormat, GLuint width, GLuint height, GLint unpackAligment, const GLvoid* data, bool generateMipmap = false);

		void bind(GLuint textureUnit) const;

		GLuint getId() const {
			return m_texture;
		}

	private:
		GLuint m_texture;
	};
}

#endif /* __texture_h__ */