#include "wglext.h"
#include <string>
#include <assert.h>

/* ## WGL_ARB_buffer_region ## */
typedef HANDLE (WINAPI * PFNWGLCREATEBUFFERREGIONARBPROC) (HDC hDC, int iLayerPlane, UINT uType);
typedef VOID (WINAPI * PFNWGLDELETEBUFFERREGIONARBPROC) (HANDLE hRegion);
typedef BOOL (WINAPI * PFNWGLSAVEBUFFERREGIONARBPROC) (HANDLE hRegion, int x, int y, int width, int height);
typedef BOOL (WINAPI * PFNWGLRESTOREBUFFERREGIONARBPROC) (HANDLE hRegion, int x, int y, int width, int height, int xSrc, int ySrc);

/* ## WGL_ARB_multisample ## */

/* ## WGL_ARB_extensions_string ## */
typedef const char * (WINAPI * PFNWGLGETEXTENSIONSSTRINGARBPROC) (HDC hdc);

/* ## WGL_ARB_pixel_format ## */
typedef BOOL (WINAPI * PFNWGLGETPIXELFORMATATTRIBIVARBPROC) (HDC hdc, int iPixelFormat, int iLayerPlane, UINT nAttributes, const int *piAttributes, int *piValues);
typedef BOOL (WINAPI * PFNWGLGETPIXELFORMATATTRIBFVARBPROC) (HDC hdc, int iPixelFormat, int iLayerPlane, UINT nAttributes, const int *piAttributes, FLOAT *pfValues);
typedef BOOL (WINAPI * PFNWGLCHOOSEPIXELFORMATARBPROC) (HDC hdc, const int *piAttribIList, const FLOAT *pfAttribFList, UINT nMaxFormats, int *piFormats, UINT *nNumFormats);

/* ## WGL_ARB_make_current_read ## */
typedef BOOL (WINAPI * PFNWGLMAKECONTEXTCURRENTARBPROC) (HDC hDrawDC, HDC hReadDC, HGLRC hglrc);
typedef HDC (WINAPI * PFNWGLGETCURRENTREADDCARBPROC) (void);

/* ## WGL_ARB_pbuffer ## */
typedef HPBUFFERARB (WINAPI * PFNWGLCREATEPBUFFERARBPROC) (HDC hDC, int iPixelFormat, int iWidth, int iHeight, const int *piAttribList);
typedef HDC (WINAPI * PFNWGLGETPBUFFERDCARBPROC) (HPBUFFERARB hPbuffer);
typedef int (WINAPI * PFNWGLRELEASEPBUFFERDCARBPROC) (HPBUFFERARB hPbuffer, HDC hDC);
typedef BOOL (WINAPI * PFNWGLDESTROYPBUFFERARBPROC) (HPBUFFERARB hPbuffer);
typedef BOOL (WINAPI * PFNWGLQUERYPBUFFERARBPROC) (HPBUFFERARB hPbuffer, int iAttribute, int *piValue);

/* ## WGL_ARB_render_texture ## */
typedef BOOL (WINAPI * PFNWGLBINDTEXIMAGEARBPROC) (HPBUFFERARB hPbuffer, int iBuffer);
typedef BOOL (WINAPI * PFNWGLRELEASETEXIMAGEARBPROC) (HPBUFFERARB hPbuffer, int iBuffer);
typedef BOOL (WINAPI * PFNWGLSETPBUFFERATTRIBARBPROC) (HPBUFFERARB hPbuffer, const int *piAttribList);

/* ## WGL_ARB_pixel_format_float ## */

/* ## WGL_ARB_framebuffer_sRGB ## */

/* ## WGL_ARB_create_context ## */
typedef HGLRC (WINAPI * PFNWGLCREATECONTEXTATTRIBSARBPROC) (HDC hDC, HGLRC hShareContext, const int *attribList);

/* ## WGL_ARB_create_context_profile ## */

/* ## WGL_ARB_create_context_robustness ## */

/* ## WGL_EXT_display_color_table ## */
typedef GLboolean (WINAPI * PFNWGLCREATEDISPLAYCOLORTABLEEXTPROC) (GLushort id);
typedef GLboolean (WINAPI * PFNWGLLOADDISPLAYCOLORTABLEEXTPROC) (const GLushort *table, GLuint length);
typedef GLboolean (WINAPI * PFNWGLBINDDISPLAYCOLORTABLEEXTPROC) (GLushort id);
typedef VOID (WINAPI * PFNWGLDESTROYDISPLAYCOLORTABLEEXTPROC) (GLushort id);

/* ## WGL_EXT_extensions_string ## */
typedef const char * (WINAPI * PFNWGLGETEXTENSIONSSTRINGEXTPROC) (void);

/* ## WGL_EXT_make_current_read ## */
typedef BOOL (WINAPI * PFNWGLMAKECONTEXTCURRENTEXTPROC) (HDC hDrawDC, HDC hReadDC, HGLRC hglrc);
typedef HDC (WINAPI * PFNWGLGETCURRENTREADDCEXTPROC) (void);

/* ## WGL_EXT_pbuffer ## */
typedef HPBUFFEREXT (WINAPI * PFNWGLCREATEPBUFFEREXTPROC) (HDC hDC, int iPixelFormat, int iWidth, int iHeight, const int *piAttribList);
typedef HDC (WINAPI * PFNWGLGETPBUFFERDCEXTPROC) (HPBUFFEREXT hPbuffer);
typedef int (WINAPI * PFNWGLRELEASEPBUFFERDCEXTPROC) (HPBUFFEREXT hPbuffer, HDC hDC);
typedef BOOL (WINAPI * PFNWGLDESTROYPBUFFEREXTPROC) (HPBUFFEREXT hPbuffer);
typedef BOOL (WINAPI * PFNWGLQUERYPBUFFEREXTPROC) (HPBUFFEREXT hPbuffer, int iAttribute, int *piValue);

/* ## WGL_EXT_pixel_format ## */
typedef BOOL (WINAPI * PFNWGLGETPIXELFORMATATTRIBIVEXTPROC) (HDC hdc, int iPixelFormat, int iLayerPlane, UINT nAttributes, int *piAttributes, int *piValues);
typedef BOOL (WINAPI * PFNWGLGETPIXELFORMATATTRIBFVEXTPROC) (HDC hdc, int iPixelFormat, int iLayerPlane, UINT nAttributes, int *piAttributes, FLOAT *pfValues);
typedef BOOL (WINAPI * PFNWGLCHOOSEPIXELFORMATEXTPROC) (HDC hdc, const int *piAttribIList, const FLOAT *pfAttribFList, UINT nMaxFormats, int *piFormats, UINT *nNumFormats);

/* ## WGL_EXT_swap_control ## */
typedef BOOL (WINAPI * PFNWGLSWAPINTERVALEXTPROC) (int interval);
typedef int (WINAPI * PFNWGLGETSWAPINTERVALEXTPROC) (void);

/* ## WGL_EXT_depth_float ## */

/* ## WGL_NV_vertex_array_range ## */
typedef void* (WINAPI * PFNWGLALLOCATEMEMORYNVPROC) (GLsizei size, GLfloat readfreq, GLfloat writefreq, GLfloat priority);
typedef void (WINAPI * PFNWGLFREEMEMORYNVPROC) (void *pointer);

/* ## WGL_3DFX_multisample ## */

/* ## WGL_EXT_multisample ## */

/* ## WGL_OML_sync_control ## */
typedef BOOL (WINAPI * PFNWGLGETSYNCVALUESOMLPROC) (HDC hdc, INT64 *ust, INT64 *msc, INT64 *sbc);
typedef BOOL (WINAPI * PFNWGLGETMSCRATEOMLPROC) (HDC hdc, INT32 *numerator, INT32 *denominator);
typedef INT64 (WINAPI * PFNWGLSWAPBUFFERSMSCOMLPROC) (HDC hdc, INT64 target_msc, INT64 divisor, INT64 remainder);
typedef INT64 (WINAPI * PFNWGLSWAPLAYERBUFFERSMSCOMLPROC) (HDC hdc, int fuPlanes, INT64 target_msc, INT64 divisor, INT64 remainder);
typedef BOOL (WINAPI * PFNWGLWAITFORMSCOMLPROC) (HDC hdc, INT64 target_msc, INT64 divisor, INT64 remainder, INT64 *ust, INT64 *msc, INT64 *sbc);
typedef BOOL (WINAPI * PFNWGLWAITFORSBCOMLPROC) (HDC hdc, INT64 target_sbc, INT64 *ust, INT64 *msc, INT64 *sbc);

/* ## WGL_I3D_digital_video_control ## */
typedef BOOL (WINAPI * PFNWGLGETDIGITALVIDEOPARAMETERSI3DPROC) (HDC hDC, int iAttribute, int *piValue);
typedef BOOL (WINAPI * PFNWGLSETDIGITALVIDEOPARAMETERSI3DPROC) (HDC hDC, int iAttribute, const int *piValue);

/* ## WGL_I3D_gamma ## */
typedef BOOL (WINAPI * PFNWGLGETGAMMATABLEPARAMETERSI3DPROC) (HDC hDC, int iAttribute, int *piValue);
typedef BOOL (WINAPI * PFNWGLSETGAMMATABLEPARAMETERSI3DPROC) (HDC hDC, int iAttribute, const int *piValue);
typedef BOOL (WINAPI * PFNWGLGETGAMMATABLEI3DPROC) (HDC hDC, int iEntries, USHORT *puRed, USHORT *puGreen, USHORT *puBlue);
typedef BOOL (WINAPI * PFNWGLSETGAMMATABLEI3DPROC) (HDC hDC, int iEntries, const USHORT *puRed, const USHORT *puGreen, const USHORT *puBlue);

/* ## WGL_I3D_genlock ## */
typedef BOOL (WINAPI * PFNWGLENABLEGENLOCKI3DPROC) (HDC hDC);
typedef BOOL (WINAPI * PFNWGLDISABLEGENLOCKI3DPROC) (HDC hDC);
typedef BOOL (WINAPI * PFNWGLISENABLEDGENLOCKI3DPROC) (HDC hDC, BOOL *pFlag);
typedef BOOL (WINAPI * PFNWGLGENLOCKSOURCEI3DPROC) (HDC hDC, UINT uSource);
typedef BOOL (WINAPI * PFNWGLGETGENLOCKSOURCEI3DPROC) (HDC hDC, UINT *uSource);
typedef BOOL (WINAPI * PFNWGLGENLOCKSOURCEEDGEI3DPROC) (HDC hDC, UINT uEdge);
typedef BOOL (WINAPI * PFNWGLGETGENLOCKSOURCEEDGEI3DPROC) (HDC hDC, UINT *uEdge);
typedef BOOL (WINAPI * PFNWGLGENLOCKSAMPLERATEI3DPROC) (HDC hDC, UINT uRate);
typedef BOOL (WINAPI * PFNWGLGETGENLOCKSAMPLERATEI3DPROC) (HDC hDC, UINT *uRate);
typedef BOOL (WINAPI * PFNWGLGENLOCKSOURCEDELAYI3DPROC) (HDC hDC, UINT uDelay);
typedef BOOL (WINAPI * PFNWGLGETGENLOCKSOURCEDELAYI3DPROC) (HDC hDC, UINT *uDelay);
typedef BOOL (WINAPI * PFNWGLQUERYGENLOCKMAXSOURCEDELAYI3DPROC) (HDC hDC, UINT *uMaxLineDelay, UINT *uMaxPixelDelay);

/* ## WGL_I3D_image_buffer ## */
typedef LPVOID (WINAPI * PFNWGLCREATEIMAGEBUFFERI3DPROC) (HDC hDC, DWORD dwSize, UINT uFlags);
typedef BOOL (WINAPI * PFNWGLDESTROYIMAGEBUFFERI3DPROC) (HDC hDC, LPVOID pAddress);
typedef BOOL (WINAPI * PFNWGLASSOCIATEIMAGEBUFFEREVENTSI3DPROC) (HDC hDC, const HANDLE *pEvent, const LPVOID *pAddress, const DWORD *pSize, UINT count);
typedef BOOL (WINAPI * PFNWGLRELEASEIMAGEBUFFEREVENTSI3DPROC) (HDC hDC, const LPVOID *pAddress, UINT count);

/* ## WGL_I3D_swap_frame_lock ## */
typedef BOOL (WINAPI * PFNWGLENABLEFRAMELOCKI3DPROC) (void);
typedef BOOL (WINAPI * PFNWGLDISABLEFRAMELOCKI3DPROC) (void);
typedef BOOL (WINAPI * PFNWGLISENABLEDFRAMELOCKI3DPROC) (BOOL *pFlag);
typedef BOOL (WINAPI * PFNWGLQUERYFRAMELOCKMASTERI3DPROC) (BOOL *pFlag);

/* ## WGL_I3D_swap_frame_usage ## */
typedef BOOL (WINAPI * PFNWGLGETFRAMEUSAGEI3DPROC) (float *pUsage);
typedef BOOL (WINAPI * PFNWGLBEGINFRAMETRACKINGI3DPROC) (void);
typedef BOOL (WINAPI * PFNWGLENDFRAMETRACKINGI3DPROC) (void);
typedef BOOL (WINAPI * PFNWGLQUERYFRAMETRACKINGI3DPROC) (DWORD *pFrameCount, DWORD *pMissedFrames, float *pLastMissedUsage);

/* ## WGL_ATI_pixel_format_float ## */

/* ## WGL_NV_float_buffer ## */

/* ## WGL_3DL_stereo_control ## */
typedef BOOL (WINAPI * PFNWGLSETSTEREOEMITTERSTATE3DLPROC) (HDC hDC, UINT uState);

/* ## WGL_EXT_pixel_format_packed_float ## */

/* ## WGL_EXT_framebuffer_sRGB ## */

/* ## WGL_NV_present_video ## */
typedef int (WINAPI * PFNWGLENUMERATEVIDEODEVICESNVPROC) (HDC hDC, HVIDEOOUTPUTDEVICENV *phDeviceList);
typedef BOOL (WINAPI * PFNWGLBINDVIDEODEVICENVPROC) (HDC hDC, unsigned int uVideoSlot, HVIDEOOUTPUTDEVICENV hVideoDevice, const int *piAttribList);
typedef BOOL (WINAPI * PFNWGLQUERYCURRENTCONTEXTNVPROC) (int iAttribute, int *piValue);

/* ## WGL_NV_video_output ## */
typedef BOOL (WINAPI * PFNWGLGETVIDEODEVICENVPROC) (HDC hDC, int numDevices, HPVIDEODEV *hVideoDevice);
typedef BOOL (WINAPI * PFNWGLRELEASEVIDEODEVICENVPROC) (HPVIDEODEV hVideoDevice);
typedef BOOL (WINAPI * PFNWGLBINDVIDEOIMAGENVPROC) (HPVIDEODEV hVideoDevice, HPBUFFERARB hPbuffer, int iVideoBuffer);
typedef BOOL (WINAPI * PFNWGLRELEASEVIDEOIMAGENVPROC) (HPBUFFERARB hPbuffer, int iVideoBuffer);
typedef BOOL (WINAPI * PFNWGLSENDPBUFFERTOVIDEONVPROC) (HPBUFFERARB hPbuffer, int iBufferType, unsigned long *pulCounterPbuffer, BOOL bBlock);
typedef BOOL (WINAPI * PFNWGLGETVIDEOINFONVPROC) (HPVIDEODEV hpVideoDevice, unsigned long *pulCounterOutputPbuffer, unsigned long *pulCounterOutputVideo);

/* ## WGL_NV_swap_group ## */
typedef BOOL (WINAPI * PFNWGLJOINSWAPGROUPNVPROC) (HDC hDC, GLuint group);
typedef BOOL (WINAPI * PFNWGLBINDSWAPBARRIERNVPROC) (GLuint group, GLuint barrier);
typedef BOOL (WINAPI * PFNWGLQUERYSWAPGROUPNVPROC) (HDC hDC, GLuint *group, GLuint *barrier);
typedef BOOL (WINAPI * PFNWGLQUERYMAXSWAPGROUPSNVPROC) (HDC hDC, GLuint *maxGroups, GLuint *maxBarriers);
typedef BOOL (WINAPI * PFNWGLQUERYFRAMECOUNTNVPROC) (HDC hDC, GLuint *count);
typedef BOOL (WINAPI * PFNWGLRESETFRAMECOUNTNVPROC) (HDC hDC);

/* ## WGL_NV_gpu_affinity ## */
typedef BOOL (WINAPI * PFNWGLENUMGPUSNVPROC) (UINT iGpuIndex, HGPUNV *phGpu);
typedef BOOL (WINAPI * PFNWGLENUMGPUDEVICESNVPROC) (HGPUNV hGpu, UINT iDeviceIndex, PGPU_DEVICE lpGpuDevice);
typedef HDC (WINAPI * PFNWGLCREATEAFFINITYDCNVPROC) (const HGPUNV *phGpuList);
typedef BOOL (WINAPI * PFNWGLENUMGPUSFROMAFFINITYDCNVPROC) (HDC hAffinityDC, UINT iGpuIndex, HGPUNV *hGpu);
typedef BOOL (WINAPI * PFNWGLDELETEDCNVPROC) (HDC hdc);

/* ## WGL_AMD_gpu_association ## */
typedef UINT (WINAPI * PFNWGLGETGPUIDSAMDPROC) (UINT maxCount, UINT *ids);
typedef INT (WINAPI * PFNWGLGETGPUINFOAMDPROC) (UINT id, int property, GLenum dataType, UINT size, void *data);
typedef UINT (WINAPI * PFNWGLGETCONTEXTGPUIDAMDPROC) (HGLRC hglrc);
typedef HGLRC (WINAPI * PFNWGLCREATEASSOCIATEDCONTEXTAMDPROC) (UINT id);
typedef HGLRC (WINAPI * PFNWGLCREATEASSOCIATEDCONTEXTATTRIBSAMDPROC) (UINT id, HGLRC hShareContext, const int *attribList);
typedef BOOL (WINAPI * PFNWGLDELETEASSOCIATEDCONTEXTAMDPROC) (HGLRC hglrc);
typedef BOOL (WINAPI * PFNWGLMAKEASSOCIATEDCONTEXTCURRENTAMDPROC) (HGLRC hglrc);
typedef HGLRC (WINAPI * PFNWGLGETCURRENTASSOCIATEDCONTEXTAMDPROC) (void);
typedef VOID (WINAPI * PFNWGLBLITCONTEXTFRAMEBUFFERAMDPROC) (HGLRC dstCtx, GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter);

/* ## WGL_NV_video_capture ## */
typedef BOOL (WINAPI * PFNWGLBINDVIDEOCAPTUREDEVICENVPROC) (UINT uVideoSlot, HVIDEOINPUTDEVICENV hDevice);
typedef UINT (WINAPI * PFNWGLENUMERATEVIDEOCAPTUREDEVICESNVPROC) (HDC hDc, HVIDEOINPUTDEVICENV *phDeviceList);
typedef BOOL (WINAPI * PFNWGLLOCKVIDEOCAPTUREDEVICENVPROC) (HDC hDc, HVIDEOINPUTDEVICENV hDevice);
typedef BOOL (WINAPI * PFNWGLQUERYVIDEOCAPTUREDEVICENVPROC) (HDC hDc, HVIDEOINPUTDEVICENV hDevice, int iAttribute, int *piValue);
typedef BOOL (WINAPI * PFNWGLRELEASEVIDEOCAPTUREDEVICENVPROC) (HDC hDc, HVIDEOINPUTDEVICENV hDevice);

/* ## WGL_NV_copy_image ## */
typedef BOOL (WINAPI * PFNWGLCOPYIMAGESUBDATANVPROC) (HGLRC hSrcRC, GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, HGLRC hDstRC, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei width, GLsizei height, GLsizei depth);

/* ## WGL_NV_multisample_coverage ## */

/* ## WGL_NV_DX_interop ## */
typedef BOOL (WINAPI * PFNWGLDXSETRESOURCESHAREHANDLENVPROC) (void *dxObject, HANDLE shareHandle);
typedef HANDLE (WINAPI * PFNWGLDXOPENDEVICENVPROC) (void *dxDevice);
typedef BOOL (WINAPI * PFNWGLDXCLOSEDEVICENVPROC) (HANDLE hDevice);
typedef HANDLE (WINAPI * PFNWGLDXREGISTEROBJECTNVPROC) (HANDLE hDevice, void *dxObject, GLuint name, GLenum type, GLenum access);
typedef BOOL (WINAPI * PFNWGLDXUNREGISTEROBJECTNVPROC) (HANDLE hDevice, HANDLE hObject);
typedef BOOL (WINAPI * PFNWGLDXOBJECTACCESSNVPROC) (HANDLE hObject, GLenum access);
typedef BOOL (WINAPI * PFNWGLDXLOCKOBJECTSNVPROC) (HANDLE hDevice, GLint count, HANDLE *hObjects);
typedef BOOL (WINAPI * PFNWGLDXUNLOCKOBJECTSNVPROC) (HANDLE hDevice, GLint count, HANDLE *hObjects);

/* ## WGL_NV_DX_interop2 ## */

/* ## WGL_EXT_swap_control_tear ## */

/* ## WGL_ARB_buffer_region ## */
static PFNWGLCREATEBUFFERREGIONARBPROC wglCreateBufferRegionARBPtr = NULL;
HANDLE WINAPI wglCreateBufferRegionARB (HDC hDC, int iLayerPlane, UINT uType)
{
	assert(wglCreateBufferRegionARBPtr != NULL);
	return wglCreateBufferRegionARBPtr(hDC, iLayerPlane, uType);
}

static PFNWGLDELETEBUFFERREGIONARBPROC wglDeleteBufferRegionARBPtr = NULL;
VOID WINAPI wglDeleteBufferRegionARB (HANDLE hRegion)
{
	assert(wglDeleteBufferRegionARBPtr != NULL);
	return wglDeleteBufferRegionARBPtr(hRegion);
}

static PFNWGLSAVEBUFFERREGIONARBPROC wglSaveBufferRegionARBPtr = NULL;
BOOL WINAPI wglSaveBufferRegionARB (HANDLE hRegion, int x, int y, int width, int height)
{
	assert(wglSaveBufferRegionARBPtr != NULL);
	return wglSaveBufferRegionARBPtr(hRegion, x, y, width, height);
}

static PFNWGLRESTOREBUFFERREGIONARBPROC wglRestoreBufferRegionARBPtr = NULL;
BOOL WINAPI wglRestoreBufferRegionARB (HANDLE hRegion, int x, int y, int width, int height, int xSrc, int ySrc)
{
	assert(wglRestoreBufferRegionARBPtr != NULL);
	return wglRestoreBufferRegionARBPtr(hRegion, x, y, width, height, xSrc, ySrc);
}

/* ## WGL_ARB_extensions_string ## */
static PFNWGLGETEXTENSIONSSTRINGARBPROC wglGetExtensionsStringARBPtr = NULL;
const char * WINAPI wglGetExtensionsStringARB (HDC hdc)
{
	assert(wglGetExtensionsStringARBPtr != NULL);
	return wglGetExtensionsStringARBPtr(hdc);
}

/* ## WGL_ARB_pixel_format ## */
static PFNWGLGETPIXELFORMATATTRIBIVARBPROC wglGetPixelFormatAttribivARBPtr = NULL;
BOOL WINAPI wglGetPixelFormatAttribivARB (HDC hdc, int iPixelFormat, int iLayerPlane, UINT nAttributes, const int *piAttributes, int *piValues)
{
	assert(wglGetPixelFormatAttribivARBPtr != NULL);
	return wglGetPixelFormatAttribivARBPtr(hdc, iPixelFormat, iLayerPlane, nAttributes, piAttributes, piValues);
}

static PFNWGLGETPIXELFORMATATTRIBFVARBPROC wglGetPixelFormatAttribfvARBPtr = NULL;
BOOL WINAPI wglGetPixelFormatAttribfvARB (HDC hdc, int iPixelFormat, int iLayerPlane, UINT nAttributes, const int *piAttributes, FLOAT *pfValues)
{
	assert(wglGetPixelFormatAttribfvARBPtr != NULL);
	return wglGetPixelFormatAttribfvARBPtr(hdc, iPixelFormat, iLayerPlane, nAttributes, piAttributes, pfValues);
}

static PFNWGLCHOOSEPIXELFORMATARBPROC wglChoosePixelFormatARBPtr = NULL;
BOOL WINAPI wglChoosePixelFormatARB (HDC hdc, const int *piAttribIList, const FLOAT *pfAttribFList, UINT nMaxFormats, int *piFormats, UINT *nNumFormats)
{
	assert(wglChoosePixelFormatARBPtr != NULL);
	return wglChoosePixelFormatARBPtr(hdc, piAttribIList, pfAttribFList, nMaxFormats, piFormats, nNumFormats);
}

/* ## WGL_ARB_make_current_read ## */
static PFNWGLMAKECONTEXTCURRENTARBPROC wglMakeContextCurrentARBPtr = NULL;
BOOL WINAPI wglMakeContextCurrentARB (HDC hDrawDC, HDC hReadDC, HGLRC hglrc)
{
	assert(wglMakeContextCurrentARBPtr != NULL);
	return wglMakeContextCurrentARBPtr(hDrawDC, hReadDC, hglrc);
}

static PFNWGLGETCURRENTREADDCARBPROC wglGetCurrentReadDCARBPtr = NULL;
HDC WINAPI wglGetCurrentReadDCARB (void)
{
	assert(wglGetCurrentReadDCARBPtr != NULL);
	return wglGetCurrentReadDCARBPtr();
}

/* ## WGL_ARB_pbuffer ## */
static PFNWGLCREATEPBUFFERARBPROC wglCreatePbufferARBPtr = NULL;
HPBUFFERARB WINAPI wglCreatePbufferARB (HDC hDC, int iPixelFormat, int iWidth, int iHeight, const int *piAttribList)
{
	assert(wglCreatePbufferARBPtr != NULL);
	return wglCreatePbufferARBPtr(hDC, iPixelFormat, iWidth, iHeight, piAttribList);
}

static PFNWGLGETPBUFFERDCARBPROC wglGetPbufferDCARBPtr = NULL;
HDC WINAPI wglGetPbufferDCARB (HPBUFFERARB hPbuffer)
{
	assert(wglGetPbufferDCARBPtr != NULL);
	return wglGetPbufferDCARBPtr(hPbuffer);
}

static PFNWGLRELEASEPBUFFERDCARBPROC wglReleasePbufferDCARBPtr = NULL;
int WINAPI wglReleasePbufferDCARB (HPBUFFERARB hPbuffer, HDC hDC)
{
	assert(wglReleasePbufferDCARBPtr != NULL);
	return wglReleasePbufferDCARBPtr(hPbuffer, hDC);
}

static PFNWGLDESTROYPBUFFERARBPROC wglDestroyPbufferARBPtr = NULL;
BOOL WINAPI wglDestroyPbufferARB (HPBUFFERARB hPbuffer)
{
	assert(wglDestroyPbufferARBPtr != NULL);
	return wglDestroyPbufferARBPtr(hPbuffer);
}

static PFNWGLQUERYPBUFFERARBPROC wglQueryPbufferARBPtr = NULL;
BOOL WINAPI wglQueryPbufferARB (HPBUFFERARB hPbuffer, int iAttribute, int *piValue)
{
	assert(wglQueryPbufferARBPtr != NULL);
	return wglQueryPbufferARBPtr(hPbuffer, iAttribute, piValue);
}

/* ## WGL_ARB_render_texture ## */
static PFNWGLBINDTEXIMAGEARBPROC wglBindTexImageARBPtr = NULL;
BOOL WINAPI wglBindTexImageARB (HPBUFFERARB hPbuffer, int iBuffer)
{
	assert(wglBindTexImageARBPtr != NULL);
	return wglBindTexImageARBPtr(hPbuffer, iBuffer);
}

static PFNWGLRELEASETEXIMAGEARBPROC wglReleaseTexImageARBPtr = NULL;
BOOL WINAPI wglReleaseTexImageARB (HPBUFFERARB hPbuffer, int iBuffer)
{
	assert(wglReleaseTexImageARBPtr != NULL);
	return wglReleaseTexImageARBPtr(hPbuffer, iBuffer);
}

static PFNWGLSETPBUFFERATTRIBARBPROC wglSetPbufferAttribARBPtr = NULL;
BOOL WINAPI wglSetPbufferAttribARB (HPBUFFERARB hPbuffer, const int *piAttribList)
{
	assert(wglSetPbufferAttribARBPtr != NULL);
	return wglSetPbufferAttribARBPtr(hPbuffer, piAttribList);
}

/* ## WGL_ARB_create_context ## */
static PFNWGLCREATECONTEXTATTRIBSARBPROC wglCreateContextAttribsARBPtr = NULL;
HGLRC WINAPI wglCreateContextAttribsARB (HDC hDC, HGLRC hShareContext, const int *attribList)
{
	assert(wglCreateContextAttribsARBPtr != NULL);
	return wglCreateContextAttribsARBPtr(hDC, hShareContext, attribList);
}

/* ## WGL_EXT_display_color_table ## */
static PFNWGLCREATEDISPLAYCOLORTABLEEXTPROC wglCreateDisplayColorTableEXTPtr = NULL;
GLboolean WINAPI wglCreateDisplayColorTableEXT (GLushort id)
{
	assert(wglCreateDisplayColorTableEXTPtr != NULL);
	return wglCreateDisplayColorTableEXTPtr(id);
}

static PFNWGLLOADDISPLAYCOLORTABLEEXTPROC wglLoadDisplayColorTableEXTPtr = NULL;
GLboolean WINAPI wglLoadDisplayColorTableEXT (const GLushort *table, GLuint length)
{
	assert(wglLoadDisplayColorTableEXTPtr != NULL);
	return wglLoadDisplayColorTableEXTPtr(table, length);
}

static PFNWGLBINDDISPLAYCOLORTABLEEXTPROC wglBindDisplayColorTableEXTPtr = NULL;
GLboolean WINAPI wglBindDisplayColorTableEXT (GLushort id)
{
	assert(wglBindDisplayColorTableEXTPtr != NULL);
	return wglBindDisplayColorTableEXTPtr(id);
}

static PFNWGLDESTROYDISPLAYCOLORTABLEEXTPROC wglDestroyDisplayColorTableEXTPtr = NULL;
VOID WINAPI wglDestroyDisplayColorTableEXT (GLushort id)
{
	assert(wglDestroyDisplayColorTableEXTPtr != NULL);
	return wglDestroyDisplayColorTableEXTPtr(id);
}

/* ## WGL_EXT_extensions_string ## */
static PFNWGLGETEXTENSIONSSTRINGEXTPROC wglGetExtensionsStringEXTPtr = NULL;
const char * WINAPI wglGetExtensionsStringEXT (void)
{
	assert(wglGetExtensionsStringEXTPtr != NULL);
	return wglGetExtensionsStringEXTPtr();
}

/* ## WGL_EXT_make_current_read ## */
static PFNWGLMAKECONTEXTCURRENTEXTPROC wglMakeContextCurrentEXTPtr = NULL;
BOOL WINAPI wglMakeContextCurrentEXT (HDC hDrawDC, HDC hReadDC, HGLRC hglrc)
{
	assert(wglMakeContextCurrentEXTPtr != NULL);
	return wglMakeContextCurrentEXTPtr(hDrawDC, hReadDC, hglrc);
}

static PFNWGLGETCURRENTREADDCEXTPROC wglGetCurrentReadDCEXTPtr = NULL;
HDC WINAPI wglGetCurrentReadDCEXT (void)
{
	assert(wglGetCurrentReadDCEXTPtr != NULL);
	return wglGetCurrentReadDCEXTPtr();
}

/* ## WGL_EXT_pbuffer ## */
static PFNWGLCREATEPBUFFEREXTPROC wglCreatePbufferEXTPtr = NULL;
HPBUFFEREXT WINAPI wglCreatePbufferEXT (HDC hDC, int iPixelFormat, int iWidth, int iHeight, const int *piAttribList)
{
	assert(wglCreatePbufferEXTPtr != NULL);
	return wglCreatePbufferEXTPtr(hDC, iPixelFormat, iWidth, iHeight, piAttribList);
}

static PFNWGLGETPBUFFERDCEXTPROC wglGetPbufferDCEXTPtr = NULL;
HDC WINAPI wglGetPbufferDCEXT (HPBUFFEREXT hPbuffer)
{
	assert(wglGetPbufferDCEXTPtr != NULL);
	return wglGetPbufferDCEXTPtr(hPbuffer);
}

static PFNWGLRELEASEPBUFFERDCEXTPROC wglReleasePbufferDCEXTPtr = NULL;
int WINAPI wglReleasePbufferDCEXT (HPBUFFEREXT hPbuffer, HDC hDC)
{
	assert(wglReleasePbufferDCEXTPtr != NULL);
	return wglReleasePbufferDCEXTPtr(hPbuffer, hDC);
}

static PFNWGLDESTROYPBUFFEREXTPROC wglDestroyPbufferEXTPtr = NULL;
BOOL WINAPI wglDestroyPbufferEXT (HPBUFFEREXT hPbuffer)
{
	assert(wglDestroyPbufferEXTPtr != NULL);
	return wglDestroyPbufferEXTPtr(hPbuffer);
}

static PFNWGLQUERYPBUFFEREXTPROC wglQueryPbufferEXTPtr = NULL;
BOOL WINAPI wglQueryPbufferEXT (HPBUFFEREXT hPbuffer, int iAttribute, int *piValue)
{
	assert(wglQueryPbufferEXTPtr != NULL);
	return wglQueryPbufferEXTPtr(hPbuffer, iAttribute, piValue);
}

/* ## WGL_EXT_pixel_format ## */
static PFNWGLGETPIXELFORMATATTRIBIVEXTPROC wglGetPixelFormatAttribivEXTPtr = NULL;
BOOL WINAPI wglGetPixelFormatAttribivEXT (HDC hdc, int iPixelFormat, int iLayerPlane, UINT nAttributes, int *piAttributes, int *piValues)
{
	assert(wglGetPixelFormatAttribivEXTPtr != NULL);
	return wglGetPixelFormatAttribivEXTPtr(hdc, iPixelFormat, iLayerPlane, nAttributes, piAttributes, piValues);
}

static PFNWGLGETPIXELFORMATATTRIBFVEXTPROC wglGetPixelFormatAttribfvEXTPtr = NULL;
BOOL WINAPI wglGetPixelFormatAttribfvEXT (HDC hdc, int iPixelFormat, int iLayerPlane, UINT nAttributes, int *piAttributes, FLOAT *pfValues)
{
	assert(wglGetPixelFormatAttribfvEXTPtr != NULL);
	return wglGetPixelFormatAttribfvEXTPtr(hdc, iPixelFormat, iLayerPlane, nAttributes, piAttributes, pfValues);
}

static PFNWGLCHOOSEPIXELFORMATEXTPROC wglChoosePixelFormatEXTPtr = NULL;
BOOL WINAPI wglChoosePixelFormatEXT (HDC hdc, const int *piAttribIList, const FLOAT *pfAttribFList, UINT nMaxFormats, int *piFormats, UINT *nNumFormats)
{
	assert(wglChoosePixelFormatEXTPtr != NULL);
	return wglChoosePixelFormatEXTPtr(hdc, piAttribIList, pfAttribFList, nMaxFormats, piFormats, nNumFormats);
}

/* ## WGL_EXT_swap_control ## */
static PFNWGLSWAPINTERVALEXTPROC wglSwapIntervalEXTPtr = NULL;
BOOL WINAPI wglSwapIntervalEXT (int interval)
{
	assert(wglSwapIntervalEXTPtr != NULL);
	return wglSwapIntervalEXTPtr(interval);
}

static PFNWGLGETSWAPINTERVALEXTPROC wglGetSwapIntervalEXTPtr = NULL;
int WINAPI wglGetSwapIntervalEXT (void)
{
	assert(wglGetSwapIntervalEXTPtr != NULL);
	return wglGetSwapIntervalEXTPtr();
}

/* ## WGL_NV_vertex_array_range ## */
static PFNWGLALLOCATEMEMORYNVPROC wglAllocateMemoryNVPtr = NULL;
void* WINAPI wglAllocateMemoryNV (GLsizei size, GLfloat readfreq, GLfloat writefreq, GLfloat priority)
{
	assert(wglAllocateMemoryNVPtr != NULL);
	return wglAllocateMemoryNVPtr(size, readfreq, writefreq, priority);
}

static PFNWGLFREEMEMORYNVPROC wglFreeMemoryNVPtr = NULL;
void WINAPI wglFreeMemoryNV (void *pointer)
{
	assert(wglFreeMemoryNVPtr != NULL);
	return wglFreeMemoryNVPtr(pointer);
}

/* ## WGL_OML_sync_control ## */
static PFNWGLGETSYNCVALUESOMLPROC wglGetSyncValuesOMLPtr = NULL;
BOOL WINAPI wglGetSyncValuesOML (HDC hdc, INT64 *ust, INT64 *msc, INT64 *sbc)
{
	assert(wglGetSyncValuesOMLPtr != NULL);
	return wglGetSyncValuesOMLPtr(hdc, ust, msc, sbc);
}

static PFNWGLGETMSCRATEOMLPROC wglGetMscRateOMLPtr = NULL;
BOOL WINAPI wglGetMscRateOML (HDC hdc, INT32 *numerator, INT32 *denominator)
{
	assert(wglGetMscRateOMLPtr != NULL);
	return wglGetMscRateOMLPtr(hdc, numerator, denominator);
}

static PFNWGLSWAPBUFFERSMSCOMLPROC wglSwapBuffersMscOMLPtr = NULL;
INT64 WINAPI wglSwapBuffersMscOML (HDC hdc, INT64 target_msc, INT64 divisor, INT64 remainder)
{
	assert(wglSwapBuffersMscOMLPtr != NULL);
	return wglSwapBuffersMscOMLPtr(hdc, target_msc, divisor, remainder);
}

static PFNWGLSWAPLAYERBUFFERSMSCOMLPROC wglSwapLayerBuffersMscOMLPtr = NULL;
INT64 WINAPI wglSwapLayerBuffersMscOML (HDC hdc, int fuPlanes, INT64 target_msc, INT64 divisor, INT64 remainder)
{
	assert(wglSwapLayerBuffersMscOMLPtr != NULL);
	return wglSwapLayerBuffersMscOMLPtr(hdc, fuPlanes, target_msc, divisor, remainder);
}

static PFNWGLWAITFORMSCOMLPROC wglWaitForMscOMLPtr = NULL;
BOOL WINAPI wglWaitForMscOML (HDC hdc, INT64 target_msc, INT64 divisor, INT64 remainder, INT64 *ust, INT64 *msc, INT64 *sbc)
{
	assert(wglWaitForMscOMLPtr != NULL);
	return wglWaitForMscOMLPtr(hdc, target_msc, divisor, remainder, ust, msc, sbc);
}

static PFNWGLWAITFORSBCOMLPROC wglWaitForSbcOMLPtr = NULL;
BOOL WINAPI wglWaitForSbcOML (HDC hdc, INT64 target_sbc, INT64 *ust, INT64 *msc, INT64 *sbc)
{
	assert(wglWaitForSbcOMLPtr != NULL);
	return wglWaitForSbcOMLPtr(hdc, target_sbc, ust, msc, sbc);
}

/* ## WGL_I3D_digital_video_control ## */
static PFNWGLGETDIGITALVIDEOPARAMETERSI3DPROC wglGetDigitalVideoParametersI3DPtr = NULL;
BOOL WINAPI wglGetDigitalVideoParametersI3D (HDC hDC, int iAttribute, int *piValue)
{
	assert(wglGetDigitalVideoParametersI3DPtr != NULL);
	return wglGetDigitalVideoParametersI3DPtr(hDC, iAttribute, piValue);
}

static PFNWGLSETDIGITALVIDEOPARAMETERSI3DPROC wglSetDigitalVideoParametersI3DPtr = NULL;
BOOL WINAPI wglSetDigitalVideoParametersI3D (HDC hDC, int iAttribute, const int *piValue)
{
	assert(wglSetDigitalVideoParametersI3DPtr != NULL);
	return wglSetDigitalVideoParametersI3DPtr(hDC, iAttribute, piValue);
}

/* ## WGL_I3D_gamma ## */
static PFNWGLGETGAMMATABLEPARAMETERSI3DPROC wglGetGammaTableParametersI3DPtr = NULL;
BOOL WINAPI wglGetGammaTableParametersI3D (HDC hDC, int iAttribute, int *piValue)
{
	assert(wglGetGammaTableParametersI3DPtr != NULL);
	return wglGetGammaTableParametersI3DPtr(hDC, iAttribute, piValue);
}

static PFNWGLSETGAMMATABLEPARAMETERSI3DPROC wglSetGammaTableParametersI3DPtr = NULL;
BOOL WINAPI wglSetGammaTableParametersI3D (HDC hDC, int iAttribute, const int *piValue)
{
	assert(wglSetGammaTableParametersI3DPtr != NULL);
	return wglSetGammaTableParametersI3DPtr(hDC, iAttribute, piValue);
}

static PFNWGLGETGAMMATABLEI3DPROC wglGetGammaTableI3DPtr = NULL;
BOOL WINAPI wglGetGammaTableI3D (HDC hDC, int iEntries, USHORT *puRed, USHORT *puGreen, USHORT *puBlue)
{
	assert(wglGetGammaTableI3DPtr != NULL);
	return wglGetGammaTableI3DPtr(hDC, iEntries, puRed, puGreen, puBlue);
}

static PFNWGLSETGAMMATABLEI3DPROC wglSetGammaTableI3DPtr = NULL;
BOOL WINAPI wglSetGammaTableI3D (HDC hDC, int iEntries, const USHORT *puRed, const USHORT *puGreen, const USHORT *puBlue)
{
	assert(wglSetGammaTableI3DPtr != NULL);
	return wglSetGammaTableI3DPtr(hDC, iEntries, puRed, puGreen, puBlue);
}

/* ## WGL_I3D_genlock ## */
static PFNWGLENABLEGENLOCKI3DPROC wglEnableGenlockI3DPtr = NULL;
BOOL WINAPI wglEnableGenlockI3D (HDC hDC)
{
	assert(wglEnableGenlockI3DPtr != NULL);
	return wglEnableGenlockI3DPtr(hDC);
}

static PFNWGLDISABLEGENLOCKI3DPROC wglDisableGenlockI3DPtr = NULL;
BOOL WINAPI wglDisableGenlockI3D (HDC hDC)
{
	assert(wglDisableGenlockI3DPtr != NULL);
	return wglDisableGenlockI3DPtr(hDC);
}

static PFNWGLISENABLEDGENLOCKI3DPROC wglIsEnabledGenlockI3DPtr = NULL;
BOOL WINAPI wglIsEnabledGenlockI3D (HDC hDC, BOOL *pFlag)
{
	assert(wglIsEnabledGenlockI3DPtr != NULL);
	return wglIsEnabledGenlockI3DPtr(hDC, pFlag);
}

static PFNWGLGENLOCKSOURCEI3DPROC wglGenlockSourceI3DPtr = NULL;
BOOL WINAPI wglGenlockSourceI3D (HDC hDC, UINT uSource)
{
	assert(wglGenlockSourceI3DPtr != NULL);
	return wglGenlockSourceI3DPtr(hDC, uSource);
}

static PFNWGLGETGENLOCKSOURCEI3DPROC wglGetGenlockSourceI3DPtr = NULL;
BOOL WINAPI wglGetGenlockSourceI3D (HDC hDC, UINT *uSource)
{
	assert(wglGetGenlockSourceI3DPtr != NULL);
	return wglGetGenlockSourceI3DPtr(hDC, uSource);
}

static PFNWGLGENLOCKSOURCEEDGEI3DPROC wglGenlockSourceEdgeI3DPtr = NULL;
BOOL WINAPI wglGenlockSourceEdgeI3D (HDC hDC, UINT uEdge)
{
	assert(wglGenlockSourceEdgeI3DPtr != NULL);
	return wglGenlockSourceEdgeI3DPtr(hDC, uEdge);
}

static PFNWGLGETGENLOCKSOURCEEDGEI3DPROC wglGetGenlockSourceEdgeI3DPtr = NULL;
BOOL WINAPI wglGetGenlockSourceEdgeI3D (HDC hDC, UINT *uEdge)
{
	assert(wglGetGenlockSourceEdgeI3DPtr != NULL);
	return wglGetGenlockSourceEdgeI3DPtr(hDC, uEdge);
}

static PFNWGLGENLOCKSAMPLERATEI3DPROC wglGenlockSampleRateI3DPtr = NULL;
BOOL WINAPI wglGenlockSampleRateI3D (HDC hDC, UINT uRate)
{
	assert(wglGenlockSampleRateI3DPtr != NULL);
	return wglGenlockSampleRateI3DPtr(hDC, uRate);
}

static PFNWGLGETGENLOCKSAMPLERATEI3DPROC wglGetGenlockSampleRateI3DPtr = NULL;
BOOL WINAPI wglGetGenlockSampleRateI3D (HDC hDC, UINT *uRate)
{
	assert(wglGetGenlockSampleRateI3DPtr != NULL);
	return wglGetGenlockSampleRateI3DPtr(hDC, uRate);
}

static PFNWGLGENLOCKSOURCEDELAYI3DPROC wglGenlockSourceDelayI3DPtr = NULL;
BOOL WINAPI wglGenlockSourceDelayI3D (HDC hDC, UINT uDelay)
{
	assert(wglGenlockSourceDelayI3DPtr != NULL);
	return wglGenlockSourceDelayI3DPtr(hDC, uDelay);
}

static PFNWGLGETGENLOCKSOURCEDELAYI3DPROC wglGetGenlockSourceDelayI3DPtr = NULL;
BOOL WINAPI wglGetGenlockSourceDelayI3D (HDC hDC, UINT *uDelay)
{
	assert(wglGetGenlockSourceDelayI3DPtr != NULL);
	return wglGetGenlockSourceDelayI3DPtr(hDC, uDelay);
}

static PFNWGLQUERYGENLOCKMAXSOURCEDELAYI3DPROC wglQueryGenlockMaxSourceDelayI3DPtr = NULL;
BOOL WINAPI wglQueryGenlockMaxSourceDelayI3D (HDC hDC, UINT *uMaxLineDelay, UINT *uMaxPixelDelay)
{
	assert(wglQueryGenlockMaxSourceDelayI3DPtr != NULL);
	return wglQueryGenlockMaxSourceDelayI3DPtr(hDC, uMaxLineDelay, uMaxPixelDelay);
}

/* ## WGL_I3D_image_buffer ## */
static PFNWGLCREATEIMAGEBUFFERI3DPROC wglCreateImageBufferI3DPtr = NULL;
LPVOID WINAPI wglCreateImageBufferI3D (HDC hDC, DWORD dwSize, UINT uFlags)
{
	assert(wglCreateImageBufferI3DPtr != NULL);
	return wglCreateImageBufferI3DPtr(hDC, dwSize, uFlags);
}

static PFNWGLDESTROYIMAGEBUFFERI3DPROC wglDestroyImageBufferI3DPtr = NULL;
BOOL WINAPI wglDestroyImageBufferI3D (HDC hDC, LPVOID pAddress)
{
	assert(wglDestroyImageBufferI3DPtr != NULL);
	return wglDestroyImageBufferI3DPtr(hDC, pAddress);
}

static PFNWGLASSOCIATEIMAGEBUFFEREVENTSI3DPROC wglAssociateImageBufferEventsI3DPtr = NULL;
BOOL WINAPI wglAssociateImageBufferEventsI3D (HDC hDC, const HANDLE *pEvent, const LPVOID *pAddress, const DWORD *pSize, UINT count)
{
	assert(wglAssociateImageBufferEventsI3DPtr != NULL);
	return wglAssociateImageBufferEventsI3DPtr(hDC, pEvent, pAddress, pSize, count);
}

static PFNWGLRELEASEIMAGEBUFFEREVENTSI3DPROC wglReleaseImageBufferEventsI3DPtr = NULL;
BOOL WINAPI wglReleaseImageBufferEventsI3D (HDC hDC, const LPVOID *pAddress, UINT count)
{
	assert(wglReleaseImageBufferEventsI3DPtr != NULL);
	return wglReleaseImageBufferEventsI3DPtr(hDC, pAddress, count);
}

/* ## WGL_I3D_swap_frame_lock ## */
static PFNWGLENABLEFRAMELOCKI3DPROC wglEnableFrameLockI3DPtr = NULL;
BOOL WINAPI wglEnableFrameLockI3D (void)
{
	assert(wglEnableFrameLockI3DPtr != NULL);
	return wglEnableFrameLockI3DPtr();
}

static PFNWGLDISABLEFRAMELOCKI3DPROC wglDisableFrameLockI3DPtr = NULL;
BOOL WINAPI wglDisableFrameLockI3D (void)
{
	assert(wglDisableFrameLockI3DPtr != NULL);
	return wglDisableFrameLockI3DPtr();
}

static PFNWGLISENABLEDFRAMELOCKI3DPROC wglIsEnabledFrameLockI3DPtr = NULL;
BOOL WINAPI wglIsEnabledFrameLockI3D (BOOL *pFlag)
{
	assert(wglIsEnabledFrameLockI3DPtr != NULL);
	return wglIsEnabledFrameLockI3DPtr(pFlag);
}

static PFNWGLQUERYFRAMELOCKMASTERI3DPROC wglQueryFrameLockMasterI3DPtr = NULL;
BOOL WINAPI wglQueryFrameLockMasterI3D (BOOL *pFlag)
{
	assert(wglQueryFrameLockMasterI3DPtr != NULL);
	return wglQueryFrameLockMasterI3DPtr(pFlag);
}

/* ## WGL_I3D_swap_frame_usage ## */
static PFNWGLGETFRAMEUSAGEI3DPROC wglGetFrameUsageI3DPtr = NULL;
BOOL WINAPI wglGetFrameUsageI3D (float *pUsage)
{
	assert(wglGetFrameUsageI3DPtr != NULL);
	return wglGetFrameUsageI3DPtr(pUsage);
}

static PFNWGLBEGINFRAMETRACKINGI3DPROC wglBeginFrameTrackingI3DPtr = NULL;
BOOL WINAPI wglBeginFrameTrackingI3D (void)
{
	assert(wglBeginFrameTrackingI3DPtr != NULL);
	return wglBeginFrameTrackingI3DPtr();
}

static PFNWGLENDFRAMETRACKINGI3DPROC wglEndFrameTrackingI3DPtr = NULL;
BOOL WINAPI wglEndFrameTrackingI3D (void)
{
	assert(wglEndFrameTrackingI3DPtr != NULL);
	return wglEndFrameTrackingI3DPtr();
}

static PFNWGLQUERYFRAMETRACKINGI3DPROC wglQueryFrameTrackingI3DPtr = NULL;
BOOL WINAPI wglQueryFrameTrackingI3D (DWORD *pFrameCount, DWORD *pMissedFrames, float *pLastMissedUsage)
{
	assert(wglQueryFrameTrackingI3DPtr != NULL);
	return wglQueryFrameTrackingI3DPtr(pFrameCount, pMissedFrames, pLastMissedUsage);
}

/* ## WGL_3DL_stereo_control ## */
static PFNWGLSETSTEREOEMITTERSTATE3DLPROC wglSetStereoEmitterState3DLPtr = NULL;
BOOL WINAPI wglSetStereoEmitterState3DL (HDC hDC, UINT uState)
{
	assert(wglSetStereoEmitterState3DLPtr != NULL);
	return wglSetStereoEmitterState3DLPtr(hDC, uState);
}

/* ## WGL_NV_present_video ## */
static PFNWGLENUMERATEVIDEODEVICESNVPROC wglEnumerateVideoDevicesNVPtr = NULL;
int WINAPI wglEnumerateVideoDevicesNV (HDC hDC, HVIDEOOUTPUTDEVICENV *phDeviceList)
{
	assert(wglEnumerateVideoDevicesNVPtr != NULL);
	return wglEnumerateVideoDevicesNVPtr(hDC, phDeviceList);
}

static PFNWGLBINDVIDEODEVICENVPROC wglBindVideoDeviceNVPtr = NULL;
BOOL WINAPI wglBindVideoDeviceNV (HDC hDC, unsigned int uVideoSlot, HVIDEOOUTPUTDEVICENV hVideoDevice, const int *piAttribList)
{
	assert(wglBindVideoDeviceNVPtr != NULL);
	return wglBindVideoDeviceNVPtr(hDC, uVideoSlot, hVideoDevice, piAttribList);
}

static PFNWGLQUERYCURRENTCONTEXTNVPROC wglQueryCurrentContextNVPtr = NULL;
BOOL WINAPI wglQueryCurrentContextNV (int iAttribute, int *piValue)
{
	assert(wglQueryCurrentContextNVPtr != NULL);
	return wglQueryCurrentContextNVPtr(iAttribute, piValue);
}

/* ## WGL_NV_video_output ## */
static PFNWGLGETVIDEODEVICENVPROC wglGetVideoDeviceNVPtr = NULL;
BOOL WINAPI wglGetVideoDeviceNV (HDC hDC, int numDevices, HPVIDEODEV *hVideoDevice)
{
	assert(wglGetVideoDeviceNVPtr != NULL);
	return wglGetVideoDeviceNVPtr(hDC, numDevices, hVideoDevice);
}

static PFNWGLRELEASEVIDEODEVICENVPROC wglReleaseVideoDeviceNVPtr = NULL;
BOOL WINAPI wglReleaseVideoDeviceNV (HPVIDEODEV hVideoDevice)
{
	assert(wglReleaseVideoDeviceNVPtr != NULL);
	return wglReleaseVideoDeviceNVPtr(hVideoDevice);
}

static PFNWGLBINDVIDEOIMAGENVPROC wglBindVideoImageNVPtr = NULL;
BOOL WINAPI wglBindVideoImageNV (HPVIDEODEV hVideoDevice, HPBUFFERARB hPbuffer, int iVideoBuffer)
{
	assert(wglBindVideoImageNVPtr != NULL);
	return wglBindVideoImageNVPtr(hVideoDevice, hPbuffer, iVideoBuffer);
}

static PFNWGLRELEASEVIDEOIMAGENVPROC wglReleaseVideoImageNVPtr = NULL;
BOOL WINAPI wglReleaseVideoImageNV (HPBUFFERARB hPbuffer, int iVideoBuffer)
{
	assert(wglReleaseVideoImageNVPtr != NULL);
	return wglReleaseVideoImageNVPtr(hPbuffer, iVideoBuffer);
}

static PFNWGLSENDPBUFFERTOVIDEONVPROC wglSendPbufferToVideoNVPtr = NULL;
BOOL WINAPI wglSendPbufferToVideoNV (HPBUFFERARB hPbuffer, int iBufferType, unsigned long *pulCounterPbuffer, BOOL bBlock)
{
	assert(wglSendPbufferToVideoNVPtr != NULL);
	return wglSendPbufferToVideoNVPtr(hPbuffer, iBufferType, pulCounterPbuffer, bBlock);
}

static PFNWGLGETVIDEOINFONVPROC wglGetVideoInfoNVPtr = NULL;
BOOL WINAPI wglGetVideoInfoNV (HPVIDEODEV hpVideoDevice, unsigned long *pulCounterOutputPbuffer, unsigned long *pulCounterOutputVideo)
{
	assert(wglGetVideoInfoNVPtr != NULL);
	return wglGetVideoInfoNVPtr(hpVideoDevice, pulCounterOutputPbuffer, pulCounterOutputVideo);
}

/* ## WGL_NV_swap_group ## */
static PFNWGLJOINSWAPGROUPNVPROC wglJoinSwapGroupNVPtr = NULL;
BOOL WINAPI wglJoinSwapGroupNV (HDC hDC, GLuint group)
{
	assert(wglJoinSwapGroupNVPtr != NULL);
	return wglJoinSwapGroupNVPtr(hDC, group);
}

static PFNWGLBINDSWAPBARRIERNVPROC wglBindSwapBarrierNVPtr = NULL;
BOOL WINAPI wglBindSwapBarrierNV (GLuint group, GLuint barrier)
{
	assert(wglBindSwapBarrierNVPtr != NULL);
	return wglBindSwapBarrierNVPtr(group, barrier);
}

static PFNWGLQUERYSWAPGROUPNVPROC wglQuerySwapGroupNVPtr = NULL;
BOOL WINAPI wglQuerySwapGroupNV (HDC hDC, GLuint *group, GLuint *barrier)
{
	assert(wglQuerySwapGroupNVPtr != NULL);
	return wglQuerySwapGroupNVPtr(hDC, group, barrier);
}

static PFNWGLQUERYMAXSWAPGROUPSNVPROC wglQueryMaxSwapGroupsNVPtr = NULL;
BOOL WINAPI wglQueryMaxSwapGroupsNV (HDC hDC, GLuint *maxGroups, GLuint *maxBarriers)
{
	assert(wglQueryMaxSwapGroupsNVPtr != NULL);
	return wglQueryMaxSwapGroupsNVPtr(hDC, maxGroups, maxBarriers);
}

static PFNWGLQUERYFRAMECOUNTNVPROC wglQueryFrameCountNVPtr = NULL;
BOOL WINAPI wglQueryFrameCountNV (HDC hDC, GLuint *count)
{
	assert(wglQueryFrameCountNVPtr != NULL);
	return wglQueryFrameCountNVPtr(hDC, count);
}

static PFNWGLRESETFRAMECOUNTNVPROC wglResetFrameCountNVPtr = NULL;
BOOL WINAPI wglResetFrameCountNV (HDC hDC)
{
	assert(wglResetFrameCountNVPtr != NULL);
	return wglResetFrameCountNVPtr(hDC);
}

/* ## WGL_NV_gpu_affinity ## */
static PFNWGLENUMGPUSNVPROC wglEnumGpusNVPtr = NULL;
BOOL WINAPI wglEnumGpusNV (UINT iGpuIndex, HGPUNV *phGpu)
{
	assert(wglEnumGpusNVPtr != NULL);
	return wglEnumGpusNVPtr(iGpuIndex, phGpu);
}

static PFNWGLENUMGPUDEVICESNVPROC wglEnumGpuDevicesNVPtr = NULL;
BOOL WINAPI wglEnumGpuDevicesNV (HGPUNV hGpu, UINT iDeviceIndex, PGPU_DEVICE lpGpuDevice)
{
	assert(wglEnumGpuDevicesNVPtr != NULL);
	return wglEnumGpuDevicesNVPtr(hGpu, iDeviceIndex, lpGpuDevice);
}

static PFNWGLCREATEAFFINITYDCNVPROC wglCreateAffinityDCNVPtr = NULL;
HDC WINAPI wglCreateAffinityDCNV (const HGPUNV *phGpuList)
{
	assert(wglCreateAffinityDCNVPtr != NULL);
	return wglCreateAffinityDCNVPtr(phGpuList);
}

static PFNWGLENUMGPUSFROMAFFINITYDCNVPROC wglEnumGpusFromAffinityDCNVPtr = NULL;
BOOL WINAPI wglEnumGpusFromAffinityDCNV (HDC hAffinityDC, UINT iGpuIndex, HGPUNV *hGpu)
{
	assert(wglEnumGpusFromAffinityDCNVPtr != NULL);
	return wglEnumGpusFromAffinityDCNVPtr(hAffinityDC, iGpuIndex, hGpu);
}

static PFNWGLDELETEDCNVPROC wglDeleteDCNVPtr = NULL;
BOOL WINAPI wglDeleteDCNV (HDC hdc)
{
	assert(wglDeleteDCNVPtr != NULL);
	return wglDeleteDCNVPtr(hdc);
}

/* ## WGL_AMD_gpu_association ## */
static PFNWGLGETGPUIDSAMDPROC wglGetGPUIDsAMDPtr = NULL;
UINT WINAPI wglGetGPUIDsAMD (UINT maxCount, UINT *ids)
{
	assert(wglGetGPUIDsAMDPtr != NULL);
	return wglGetGPUIDsAMDPtr(maxCount, ids);
}

static PFNWGLGETGPUINFOAMDPROC wglGetGPUInfoAMDPtr = NULL;
INT WINAPI wglGetGPUInfoAMD (UINT id, int property, GLenum dataType, UINT size, void *data)
{
	assert(wglGetGPUInfoAMDPtr != NULL);
	return wglGetGPUInfoAMDPtr(id, property, dataType, size, data);
}

static PFNWGLGETCONTEXTGPUIDAMDPROC wglGetContextGPUIDAMDPtr = NULL;
UINT WINAPI wglGetContextGPUIDAMD (HGLRC hglrc)
{
	assert(wglGetContextGPUIDAMDPtr != NULL);
	return wglGetContextGPUIDAMDPtr(hglrc);
}

static PFNWGLCREATEASSOCIATEDCONTEXTAMDPROC wglCreateAssociatedContextAMDPtr = NULL;
HGLRC WINAPI wglCreateAssociatedContextAMD (UINT id)
{
	assert(wglCreateAssociatedContextAMDPtr != NULL);
	return wglCreateAssociatedContextAMDPtr(id);
}

static PFNWGLCREATEASSOCIATEDCONTEXTATTRIBSAMDPROC wglCreateAssociatedContextAttribsAMDPtr = NULL;
HGLRC WINAPI wglCreateAssociatedContextAttribsAMD (UINT id, HGLRC hShareContext, const int *attribList)
{
	assert(wglCreateAssociatedContextAttribsAMDPtr != NULL);
	return wglCreateAssociatedContextAttribsAMDPtr(id, hShareContext, attribList);
}

static PFNWGLDELETEASSOCIATEDCONTEXTAMDPROC wglDeleteAssociatedContextAMDPtr = NULL;
BOOL WINAPI wglDeleteAssociatedContextAMD (HGLRC hglrc)
{
	assert(wglDeleteAssociatedContextAMDPtr != NULL);
	return wglDeleteAssociatedContextAMDPtr(hglrc);
}

static PFNWGLMAKEASSOCIATEDCONTEXTCURRENTAMDPROC wglMakeAssociatedContextCurrentAMDPtr = NULL;
BOOL WINAPI wglMakeAssociatedContextCurrentAMD (HGLRC hglrc)
{
	assert(wglMakeAssociatedContextCurrentAMDPtr != NULL);
	return wglMakeAssociatedContextCurrentAMDPtr(hglrc);
}

static PFNWGLGETCURRENTASSOCIATEDCONTEXTAMDPROC wglGetCurrentAssociatedContextAMDPtr = NULL;
HGLRC WINAPI wglGetCurrentAssociatedContextAMD (void)
{
	assert(wglGetCurrentAssociatedContextAMDPtr != NULL);
	return wglGetCurrentAssociatedContextAMDPtr();
}

static PFNWGLBLITCONTEXTFRAMEBUFFERAMDPROC wglBlitContextFramebufferAMDPtr = NULL;
VOID WINAPI wglBlitContextFramebufferAMD (HGLRC dstCtx, GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter)
{
	assert(wglBlitContextFramebufferAMDPtr != NULL);
	return wglBlitContextFramebufferAMDPtr(dstCtx, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
}

/* ## WGL_NV_video_capture ## */
static PFNWGLBINDVIDEOCAPTUREDEVICENVPROC wglBindVideoCaptureDeviceNVPtr = NULL;
BOOL WINAPI wglBindVideoCaptureDeviceNV (UINT uVideoSlot, HVIDEOINPUTDEVICENV hDevice)
{
	assert(wglBindVideoCaptureDeviceNVPtr != NULL);
	return wglBindVideoCaptureDeviceNVPtr(uVideoSlot, hDevice);
}

static PFNWGLENUMERATEVIDEOCAPTUREDEVICESNVPROC wglEnumerateVideoCaptureDevicesNVPtr = NULL;
UINT WINAPI wglEnumerateVideoCaptureDevicesNV (HDC hDc, HVIDEOINPUTDEVICENV *phDeviceList)
{
	assert(wglEnumerateVideoCaptureDevicesNVPtr != NULL);
	return wglEnumerateVideoCaptureDevicesNVPtr(hDc, phDeviceList);
}

static PFNWGLLOCKVIDEOCAPTUREDEVICENVPROC wglLockVideoCaptureDeviceNVPtr = NULL;
BOOL WINAPI wglLockVideoCaptureDeviceNV (HDC hDc, HVIDEOINPUTDEVICENV hDevice)
{
	assert(wglLockVideoCaptureDeviceNVPtr != NULL);
	return wglLockVideoCaptureDeviceNVPtr(hDc, hDevice);
}

static PFNWGLQUERYVIDEOCAPTUREDEVICENVPROC wglQueryVideoCaptureDeviceNVPtr = NULL;
BOOL WINAPI wglQueryVideoCaptureDeviceNV (HDC hDc, HVIDEOINPUTDEVICENV hDevice, int iAttribute, int *piValue)
{
	assert(wglQueryVideoCaptureDeviceNVPtr != NULL);
	return wglQueryVideoCaptureDeviceNVPtr(hDc, hDevice, iAttribute, piValue);
}

static PFNWGLRELEASEVIDEOCAPTUREDEVICENVPROC wglReleaseVideoCaptureDeviceNVPtr = NULL;
BOOL WINAPI wglReleaseVideoCaptureDeviceNV (HDC hDc, HVIDEOINPUTDEVICENV hDevice)
{
	assert(wglReleaseVideoCaptureDeviceNVPtr != NULL);
	return wglReleaseVideoCaptureDeviceNVPtr(hDc, hDevice);
}

/* ## WGL_NV_copy_image ## */
static PFNWGLCOPYIMAGESUBDATANVPROC wglCopyImageSubDataNVPtr = NULL;
BOOL WINAPI wglCopyImageSubDataNV (HGLRC hSrcRC, GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, HGLRC hDstRC, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei width, GLsizei height, GLsizei depth)
{
	assert(wglCopyImageSubDataNVPtr != NULL);
	return wglCopyImageSubDataNVPtr(hSrcRC, srcName, srcTarget, srcLevel, srcX, srcY, srcZ, hDstRC, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, width, height, depth);
}

/* ## WGL_NV_DX_interop ## */
static PFNWGLDXSETRESOURCESHAREHANDLENVPROC wglDXSetResourceShareHandleNVPtr = NULL;
BOOL WINAPI wglDXSetResourceShareHandleNV (void *dxObject, HANDLE shareHandle)
{
	assert(wglDXSetResourceShareHandleNVPtr != NULL);
	return wglDXSetResourceShareHandleNVPtr(dxObject, shareHandle);
}

static PFNWGLDXOPENDEVICENVPROC wglDXOpenDeviceNVPtr = NULL;
HANDLE WINAPI wglDXOpenDeviceNV (void *dxDevice)
{
	assert(wglDXOpenDeviceNVPtr != NULL);
	return wglDXOpenDeviceNVPtr(dxDevice);
}

static PFNWGLDXCLOSEDEVICENVPROC wglDXCloseDeviceNVPtr = NULL;
BOOL WINAPI wglDXCloseDeviceNV (HANDLE hDevice)
{
	assert(wglDXCloseDeviceNVPtr != NULL);
	return wglDXCloseDeviceNVPtr(hDevice);
}

static PFNWGLDXREGISTEROBJECTNVPROC wglDXRegisterObjectNVPtr = NULL;
HANDLE WINAPI wglDXRegisterObjectNV (HANDLE hDevice, void *dxObject, GLuint name, GLenum type, GLenum access)
{
	assert(wglDXRegisterObjectNVPtr != NULL);
	return wglDXRegisterObjectNVPtr(hDevice, dxObject, name, type, access);
}

static PFNWGLDXUNREGISTEROBJECTNVPROC wglDXUnregisterObjectNVPtr = NULL;
BOOL WINAPI wglDXUnregisterObjectNV (HANDLE hDevice, HANDLE hObject)
{
	assert(wglDXUnregisterObjectNVPtr != NULL);
	return wglDXUnregisterObjectNVPtr(hDevice, hObject);
}

static PFNWGLDXOBJECTACCESSNVPROC wglDXObjectAccessNVPtr = NULL;
BOOL WINAPI wglDXObjectAccessNV (HANDLE hObject, GLenum access)
{
	assert(wglDXObjectAccessNVPtr != NULL);
	return wglDXObjectAccessNVPtr(hObject, access);
}

static PFNWGLDXLOCKOBJECTSNVPROC wglDXLockObjectsNVPtr = NULL;
BOOL WINAPI wglDXLockObjectsNV (HANDLE hDevice, GLint count, HANDLE *hObjects)
{
	assert(wglDXLockObjectsNVPtr != NULL);
	return wglDXLockObjectsNVPtr(hDevice, count, hObjects);
}

static PFNWGLDXUNLOCKOBJECTSNVPROC wglDXUnlockObjectsNVPtr = NULL;
BOOL WINAPI wglDXUnlockObjectsNV (HANDLE hDevice, GLint count, HANDLE *hObjects)
{
	assert(wglDXUnlockObjectsNVPtr != NULL);
	return wglDXUnlockObjectsNVPtr(hDevice, count, hObjects);
}

inline bool loadWGL_ARB_buffer_region()
{
	wglCreateBufferRegionARBPtr = reinterpret_cast<PFNWGLCREATEBUFFERREGIONARBPROC>(::wglGetProcAddress("wglCreateBufferRegionARB"));
	wglDeleteBufferRegionARBPtr = reinterpret_cast<PFNWGLDELETEBUFFERREGIONARBPROC>(::wglGetProcAddress("wglDeleteBufferRegionARB"));
	wglSaveBufferRegionARBPtr = reinterpret_cast<PFNWGLSAVEBUFFERREGIONARBPROC>(::wglGetProcAddress("wglSaveBufferRegionARB"));
	wglRestoreBufferRegionARBPtr = reinterpret_cast<PFNWGLRESTOREBUFFERREGIONARBPROC>(::wglGetProcAddress("wglRestoreBufferRegionARB"));

	return wglCreateBufferRegionARBPtr != NULL && wglDeleteBufferRegionARBPtr != NULL && wglSaveBufferRegionARBPtr != NULL && wglRestoreBufferRegionARBPtr != NULL;
}

inline bool loadWGL_ARB_extensions_string()
{
	wglGetExtensionsStringARBPtr = reinterpret_cast<PFNWGLGETEXTENSIONSSTRINGARBPROC>(::wglGetProcAddress("wglGetExtensionsStringARB"));

	return wglGetExtensionsStringARBPtr != NULL;
}

inline bool loadWGL_ARB_pixel_format()
{
	wglGetPixelFormatAttribivARBPtr = reinterpret_cast<PFNWGLGETPIXELFORMATATTRIBIVARBPROC>(::wglGetProcAddress("wglGetPixelFormatAttribivARB"));
	wglGetPixelFormatAttribfvARBPtr = reinterpret_cast<PFNWGLGETPIXELFORMATATTRIBFVARBPROC>(::wglGetProcAddress("wglGetPixelFormatAttribfvARB"));
	wglChoosePixelFormatARBPtr = reinterpret_cast<PFNWGLCHOOSEPIXELFORMATARBPROC>(::wglGetProcAddress("wglChoosePixelFormatARB"));

	return wglGetPixelFormatAttribivARBPtr != NULL && wglGetPixelFormatAttribfvARBPtr != NULL && wglChoosePixelFormatARBPtr != NULL;
}

inline bool loadWGL_ARB_make_current_read()
{
	wglMakeContextCurrentARBPtr = reinterpret_cast<PFNWGLMAKECONTEXTCURRENTARBPROC>(::wglGetProcAddress("wglMakeContextCurrentARB"));
	wglGetCurrentReadDCARBPtr = reinterpret_cast<PFNWGLGETCURRENTREADDCARBPROC>(::wglGetProcAddress("wglGetCurrentReadDCARB"));

	return wglMakeContextCurrentARBPtr != NULL && wglGetCurrentReadDCARBPtr != NULL;
}

inline bool loadWGL_ARB_pbuffer()
{
	wglCreatePbufferARBPtr = reinterpret_cast<PFNWGLCREATEPBUFFERARBPROC>(::wglGetProcAddress("wglCreatePbufferARB"));
	wglGetPbufferDCARBPtr = reinterpret_cast<PFNWGLGETPBUFFERDCARBPROC>(::wglGetProcAddress("wglGetPbufferDCARB"));
	wglReleasePbufferDCARBPtr = reinterpret_cast<PFNWGLRELEASEPBUFFERDCARBPROC>(::wglGetProcAddress("wglReleasePbufferDCARB"));
	wglDestroyPbufferARBPtr = reinterpret_cast<PFNWGLDESTROYPBUFFERARBPROC>(::wglGetProcAddress("wglDestroyPbufferARB"));
	wglQueryPbufferARBPtr = reinterpret_cast<PFNWGLQUERYPBUFFERARBPROC>(::wglGetProcAddress("wglQueryPbufferARB"));

	return wglCreatePbufferARBPtr != NULL && wglGetPbufferDCARBPtr != NULL && wglReleasePbufferDCARBPtr != NULL && wglDestroyPbufferARBPtr != NULL && wglQueryPbufferARBPtr != NULL;
}

inline bool loadWGL_ARB_render_texture()
{
	wglBindTexImageARBPtr = reinterpret_cast<PFNWGLBINDTEXIMAGEARBPROC>(::wglGetProcAddress("wglBindTexImageARB"));
	wglReleaseTexImageARBPtr = reinterpret_cast<PFNWGLRELEASETEXIMAGEARBPROC>(::wglGetProcAddress("wglReleaseTexImageARB"));
	wglSetPbufferAttribARBPtr = reinterpret_cast<PFNWGLSETPBUFFERATTRIBARBPROC>(::wglGetProcAddress("wglSetPbufferAttribARB"));

	return wglBindTexImageARBPtr != NULL && wglReleaseTexImageARBPtr != NULL && wglSetPbufferAttribARBPtr != NULL;
}

inline bool loadWGL_ARB_create_context()
{
	wglCreateContextAttribsARBPtr = reinterpret_cast<PFNWGLCREATECONTEXTATTRIBSARBPROC>(::wglGetProcAddress("wglCreateContextAttribsARB"));

	return wglCreateContextAttribsARBPtr != NULL;
}

inline bool loadWGL_EXT_display_color_table()
{
	wglCreateDisplayColorTableEXTPtr = reinterpret_cast<PFNWGLCREATEDISPLAYCOLORTABLEEXTPROC>(::wglGetProcAddress("wglCreateDisplayColorTableEXT"));
	wglLoadDisplayColorTableEXTPtr = reinterpret_cast<PFNWGLLOADDISPLAYCOLORTABLEEXTPROC>(::wglGetProcAddress("wglLoadDisplayColorTableEXT"));
	wglBindDisplayColorTableEXTPtr = reinterpret_cast<PFNWGLBINDDISPLAYCOLORTABLEEXTPROC>(::wglGetProcAddress("wglBindDisplayColorTableEXT"));
	wglDestroyDisplayColorTableEXTPtr = reinterpret_cast<PFNWGLDESTROYDISPLAYCOLORTABLEEXTPROC>(::wglGetProcAddress("wglDestroyDisplayColorTableEXT"));

	return wglCreateDisplayColorTableEXTPtr != NULL && wglLoadDisplayColorTableEXTPtr != NULL && wglBindDisplayColorTableEXTPtr != NULL && wglDestroyDisplayColorTableEXTPtr != NULL;
}

inline bool loadWGL_EXT_extensions_string()
{
	wglGetExtensionsStringEXTPtr = reinterpret_cast<PFNWGLGETEXTENSIONSSTRINGEXTPROC>(::wglGetProcAddress("wglGetExtensionsStringEXT"));

	return wglGetExtensionsStringEXTPtr != NULL;
}

inline bool loadWGL_EXT_make_current_read()
{
	wglMakeContextCurrentEXTPtr = reinterpret_cast<PFNWGLMAKECONTEXTCURRENTEXTPROC>(::wglGetProcAddress("wglMakeContextCurrentEXT"));
	wglGetCurrentReadDCEXTPtr = reinterpret_cast<PFNWGLGETCURRENTREADDCEXTPROC>(::wglGetProcAddress("wglGetCurrentReadDCEXT"));

	return wglMakeContextCurrentEXTPtr != NULL && wglGetCurrentReadDCEXTPtr != NULL;
}

inline bool loadWGL_EXT_pbuffer()
{
	wglCreatePbufferEXTPtr = reinterpret_cast<PFNWGLCREATEPBUFFEREXTPROC>(::wglGetProcAddress("wglCreatePbufferEXT"));
	wglGetPbufferDCEXTPtr = reinterpret_cast<PFNWGLGETPBUFFERDCEXTPROC>(::wglGetProcAddress("wglGetPbufferDCEXT"));
	wglReleasePbufferDCEXTPtr = reinterpret_cast<PFNWGLRELEASEPBUFFERDCEXTPROC>(::wglGetProcAddress("wglReleasePbufferDCEXT"));
	wglDestroyPbufferEXTPtr = reinterpret_cast<PFNWGLDESTROYPBUFFEREXTPROC>(::wglGetProcAddress("wglDestroyPbufferEXT"));
	wglQueryPbufferEXTPtr = reinterpret_cast<PFNWGLQUERYPBUFFEREXTPROC>(::wglGetProcAddress("wglQueryPbufferEXT"));

	return wglCreatePbufferEXTPtr != NULL && wglGetPbufferDCEXTPtr != NULL && wglReleasePbufferDCEXTPtr != NULL && wglDestroyPbufferEXTPtr != NULL && wglQueryPbufferEXTPtr != NULL;
}

inline bool loadWGL_EXT_pixel_format()
{
	wglGetPixelFormatAttribivEXTPtr = reinterpret_cast<PFNWGLGETPIXELFORMATATTRIBIVEXTPROC>(::wglGetProcAddress("wglGetPixelFormatAttribivEXT"));
	wglGetPixelFormatAttribfvEXTPtr = reinterpret_cast<PFNWGLGETPIXELFORMATATTRIBFVEXTPROC>(::wglGetProcAddress("wglGetPixelFormatAttribfvEXT"));
	wglChoosePixelFormatEXTPtr = reinterpret_cast<PFNWGLCHOOSEPIXELFORMATEXTPROC>(::wglGetProcAddress("wglChoosePixelFormatEXT"));

	return wglGetPixelFormatAttribivEXTPtr != NULL && wglGetPixelFormatAttribfvEXTPtr != NULL && wglChoosePixelFormatEXTPtr != NULL;
}

inline bool loadWGL_EXT_swap_control()
{
	wglSwapIntervalEXTPtr = reinterpret_cast<PFNWGLSWAPINTERVALEXTPROC>(::wglGetProcAddress("wglSwapIntervalEXT"));
	wglGetSwapIntervalEXTPtr = reinterpret_cast<PFNWGLGETSWAPINTERVALEXTPROC>(::wglGetProcAddress("wglGetSwapIntervalEXT"));

	return wglSwapIntervalEXTPtr != NULL && wglGetSwapIntervalEXTPtr != NULL;
}

inline bool loadWGL_NV_vertex_array_range()
{
	wglAllocateMemoryNVPtr = reinterpret_cast<PFNWGLALLOCATEMEMORYNVPROC>(::wglGetProcAddress("wglAllocateMemoryNV"));
	wglFreeMemoryNVPtr = reinterpret_cast<PFNWGLFREEMEMORYNVPROC>(::wglGetProcAddress("wglFreeMemoryNV"));

	return wglAllocateMemoryNVPtr != NULL && wglFreeMemoryNVPtr != NULL;
}

inline bool loadWGL_OML_sync_control()
{
	wglGetSyncValuesOMLPtr = reinterpret_cast<PFNWGLGETSYNCVALUESOMLPROC>(::wglGetProcAddress("wglGetSyncValuesOML"));
	wglGetMscRateOMLPtr = reinterpret_cast<PFNWGLGETMSCRATEOMLPROC>(::wglGetProcAddress("wglGetMscRateOML"));
	wglSwapBuffersMscOMLPtr = reinterpret_cast<PFNWGLSWAPBUFFERSMSCOMLPROC>(::wglGetProcAddress("wglSwapBuffersMscOML"));
	wglSwapLayerBuffersMscOMLPtr = reinterpret_cast<PFNWGLSWAPLAYERBUFFERSMSCOMLPROC>(::wglGetProcAddress("wglSwapLayerBuffersMscOML"));
	wglWaitForMscOMLPtr = reinterpret_cast<PFNWGLWAITFORMSCOMLPROC>(::wglGetProcAddress("wglWaitForMscOML"));
	wglWaitForSbcOMLPtr = reinterpret_cast<PFNWGLWAITFORSBCOMLPROC>(::wglGetProcAddress("wglWaitForSbcOML"));

	return wglGetSyncValuesOMLPtr != NULL && wglGetMscRateOMLPtr != NULL && wglSwapBuffersMscOMLPtr != NULL && wglSwapLayerBuffersMscOMLPtr != NULL && wglWaitForMscOMLPtr != NULL && 
		wglWaitForSbcOMLPtr != NULL;
}

inline bool loadWGL_I3D_digital_video_control()
{
	wglGetDigitalVideoParametersI3DPtr = reinterpret_cast<PFNWGLGETDIGITALVIDEOPARAMETERSI3DPROC>(::wglGetProcAddress("wglGetDigitalVideoParametersI3D"));
	wglSetDigitalVideoParametersI3DPtr = reinterpret_cast<PFNWGLSETDIGITALVIDEOPARAMETERSI3DPROC>(::wglGetProcAddress("wglSetDigitalVideoParametersI3D"));

	return wglGetDigitalVideoParametersI3DPtr != NULL && wglSetDigitalVideoParametersI3DPtr != NULL;
}

inline bool loadWGL_I3D_gamma()
{
	wglGetGammaTableParametersI3DPtr = reinterpret_cast<PFNWGLGETGAMMATABLEPARAMETERSI3DPROC>(::wglGetProcAddress("wglGetGammaTableParametersI3D"));
	wglSetGammaTableParametersI3DPtr = reinterpret_cast<PFNWGLSETGAMMATABLEPARAMETERSI3DPROC>(::wglGetProcAddress("wglSetGammaTableParametersI3D"));
	wglGetGammaTableI3DPtr = reinterpret_cast<PFNWGLGETGAMMATABLEI3DPROC>(::wglGetProcAddress("wglGetGammaTableI3D"));
	wglSetGammaTableI3DPtr = reinterpret_cast<PFNWGLSETGAMMATABLEI3DPROC>(::wglGetProcAddress("wglSetGammaTableI3D"));

	return wglGetGammaTableParametersI3DPtr != NULL && wglSetGammaTableParametersI3DPtr != NULL && wglGetGammaTableI3DPtr != NULL && wglSetGammaTableI3DPtr != NULL;
}

inline bool loadWGL_I3D_genlock()
{
	wglEnableGenlockI3DPtr = reinterpret_cast<PFNWGLENABLEGENLOCKI3DPROC>(::wglGetProcAddress("wglEnableGenlockI3D"));
	wglDisableGenlockI3DPtr = reinterpret_cast<PFNWGLDISABLEGENLOCKI3DPROC>(::wglGetProcAddress("wglDisableGenlockI3D"));
	wglIsEnabledGenlockI3DPtr = reinterpret_cast<PFNWGLISENABLEDGENLOCKI3DPROC>(::wglGetProcAddress("wglIsEnabledGenlockI3D"));
	wglGenlockSourceI3DPtr = reinterpret_cast<PFNWGLGENLOCKSOURCEI3DPROC>(::wglGetProcAddress("wglGenlockSourceI3D"));
	wglGetGenlockSourceI3DPtr = reinterpret_cast<PFNWGLGETGENLOCKSOURCEI3DPROC>(::wglGetProcAddress("wglGetGenlockSourceI3D"));
	wglGenlockSourceEdgeI3DPtr = reinterpret_cast<PFNWGLGENLOCKSOURCEEDGEI3DPROC>(::wglGetProcAddress("wglGenlockSourceEdgeI3D"));
	wglGetGenlockSourceEdgeI3DPtr = reinterpret_cast<PFNWGLGETGENLOCKSOURCEEDGEI3DPROC>(::wglGetProcAddress("wglGetGenlockSourceEdgeI3D"));
	wglGenlockSampleRateI3DPtr = reinterpret_cast<PFNWGLGENLOCKSAMPLERATEI3DPROC>(::wglGetProcAddress("wglGenlockSampleRateI3D"));
	wglGetGenlockSampleRateI3DPtr = reinterpret_cast<PFNWGLGETGENLOCKSAMPLERATEI3DPROC>(::wglGetProcAddress("wglGetGenlockSampleRateI3D"));
	wglGenlockSourceDelayI3DPtr = reinterpret_cast<PFNWGLGENLOCKSOURCEDELAYI3DPROC>(::wglGetProcAddress("wglGenlockSourceDelayI3D"));
	wglGetGenlockSourceDelayI3DPtr = reinterpret_cast<PFNWGLGETGENLOCKSOURCEDELAYI3DPROC>(::wglGetProcAddress("wglGetGenlockSourceDelayI3D"));
	wglQueryGenlockMaxSourceDelayI3DPtr = reinterpret_cast<PFNWGLQUERYGENLOCKMAXSOURCEDELAYI3DPROC>(::wglGetProcAddress("wglQueryGenlockMaxSourceDelayI3D"));

	return wglEnableGenlockI3DPtr != NULL && wglDisableGenlockI3DPtr != NULL && wglIsEnabledGenlockI3DPtr != NULL && wglGenlockSourceI3DPtr != NULL && wglGetGenlockSourceI3DPtr != NULL && 
		wglGenlockSourceEdgeI3DPtr != NULL && wglGetGenlockSourceEdgeI3DPtr != NULL && wglGenlockSampleRateI3DPtr != NULL && wglGetGenlockSampleRateI3DPtr != NULL && wglGenlockSourceDelayI3DPtr != NULL && 
		wglGetGenlockSourceDelayI3DPtr != NULL && wglQueryGenlockMaxSourceDelayI3DPtr != NULL;
}

inline bool loadWGL_I3D_image_buffer()
{
	wglCreateImageBufferI3DPtr = reinterpret_cast<PFNWGLCREATEIMAGEBUFFERI3DPROC>(::wglGetProcAddress("wglCreateImageBufferI3D"));
	wglDestroyImageBufferI3DPtr = reinterpret_cast<PFNWGLDESTROYIMAGEBUFFERI3DPROC>(::wglGetProcAddress("wglDestroyImageBufferI3D"));
	wglAssociateImageBufferEventsI3DPtr = reinterpret_cast<PFNWGLASSOCIATEIMAGEBUFFEREVENTSI3DPROC>(::wglGetProcAddress("wglAssociateImageBufferEventsI3D"));
	wglReleaseImageBufferEventsI3DPtr = reinterpret_cast<PFNWGLRELEASEIMAGEBUFFEREVENTSI3DPROC>(::wglGetProcAddress("wglReleaseImageBufferEventsI3D"));

	return wglCreateImageBufferI3DPtr != NULL && wglDestroyImageBufferI3DPtr != NULL && wglAssociateImageBufferEventsI3DPtr != NULL && wglReleaseImageBufferEventsI3DPtr != NULL;
}

inline bool loadWGL_I3D_swap_frame_lock()
{
	wglEnableFrameLockI3DPtr = reinterpret_cast<PFNWGLENABLEFRAMELOCKI3DPROC>(::wglGetProcAddress("wglEnableFrameLockI3D"));
	wglDisableFrameLockI3DPtr = reinterpret_cast<PFNWGLDISABLEFRAMELOCKI3DPROC>(::wglGetProcAddress("wglDisableFrameLockI3D"));
	wglIsEnabledFrameLockI3DPtr = reinterpret_cast<PFNWGLISENABLEDFRAMELOCKI3DPROC>(::wglGetProcAddress("wglIsEnabledFrameLockI3D"));
	wglQueryFrameLockMasterI3DPtr = reinterpret_cast<PFNWGLQUERYFRAMELOCKMASTERI3DPROC>(::wglGetProcAddress("wglQueryFrameLockMasterI3D"));

	return wglEnableFrameLockI3DPtr != NULL && wglDisableFrameLockI3DPtr != NULL && wglIsEnabledFrameLockI3DPtr != NULL && wglQueryFrameLockMasterI3DPtr != NULL;
}

inline bool loadWGL_I3D_swap_frame_usage()
{
	wglGetFrameUsageI3DPtr = reinterpret_cast<PFNWGLGETFRAMEUSAGEI3DPROC>(::wglGetProcAddress("wglGetFrameUsageI3D"));
	wglBeginFrameTrackingI3DPtr = reinterpret_cast<PFNWGLBEGINFRAMETRACKINGI3DPROC>(::wglGetProcAddress("wglBeginFrameTrackingI3D"));
	wglEndFrameTrackingI3DPtr = reinterpret_cast<PFNWGLENDFRAMETRACKINGI3DPROC>(::wglGetProcAddress("wglEndFrameTrackingI3D"));
	wglQueryFrameTrackingI3DPtr = reinterpret_cast<PFNWGLQUERYFRAMETRACKINGI3DPROC>(::wglGetProcAddress("wglQueryFrameTrackingI3D"));

	return wglGetFrameUsageI3DPtr != NULL && wglBeginFrameTrackingI3DPtr != NULL && wglEndFrameTrackingI3DPtr != NULL && wglQueryFrameTrackingI3DPtr != NULL;
}

inline bool loadWGL_3DL_stereo_control()
{
	wglSetStereoEmitterState3DLPtr = reinterpret_cast<PFNWGLSETSTEREOEMITTERSTATE3DLPROC>(::wglGetProcAddress("wglSetStereoEmitterState3DL"));

	return wglSetStereoEmitterState3DLPtr != NULL;
}

inline bool loadWGL_NV_present_video()
{
	wglEnumerateVideoDevicesNVPtr = reinterpret_cast<PFNWGLENUMERATEVIDEODEVICESNVPROC>(::wglGetProcAddress("wglEnumerateVideoDevicesNV"));
	wglBindVideoDeviceNVPtr = reinterpret_cast<PFNWGLBINDVIDEODEVICENVPROC>(::wglGetProcAddress("wglBindVideoDeviceNV"));
	wglQueryCurrentContextNVPtr = reinterpret_cast<PFNWGLQUERYCURRENTCONTEXTNVPROC>(::wglGetProcAddress("wglQueryCurrentContextNV"));

	return wglEnumerateVideoDevicesNVPtr != NULL && wglBindVideoDeviceNVPtr != NULL && wglQueryCurrentContextNVPtr != NULL;
}

inline bool loadWGL_NV_video_output()
{
	wglGetVideoDeviceNVPtr = reinterpret_cast<PFNWGLGETVIDEODEVICENVPROC>(::wglGetProcAddress("wglGetVideoDeviceNV"));
	wglReleaseVideoDeviceNVPtr = reinterpret_cast<PFNWGLRELEASEVIDEODEVICENVPROC>(::wglGetProcAddress("wglReleaseVideoDeviceNV"));
	wglBindVideoImageNVPtr = reinterpret_cast<PFNWGLBINDVIDEOIMAGENVPROC>(::wglGetProcAddress("wglBindVideoImageNV"));
	wglReleaseVideoImageNVPtr = reinterpret_cast<PFNWGLRELEASEVIDEOIMAGENVPROC>(::wglGetProcAddress("wglReleaseVideoImageNV"));
	wglSendPbufferToVideoNVPtr = reinterpret_cast<PFNWGLSENDPBUFFERTOVIDEONVPROC>(::wglGetProcAddress("wglSendPbufferToVideoNV"));
	wglGetVideoInfoNVPtr = reinterpret_cast<PFNWGLGETVIDEOINFONVPROC>(::wglGetProcAddress("wglGetVideoInfoNV"));

	return wglGetVideoDeviceNVPtr != NULL && wglReleaseVideoDeviceNVPtr != NULL && wglBindVideoImageNVPtr != NULL && wglReleaseVideoImageNVPtr != NULL && wglSendPbufferToVideoNVPtr != NULL && 
		wglGetVideoInfoNVPtr != NULL;
}

inline bool loadWGL_NV_swap_group()
{
	wglJoinSwapGroupNVPtr = reinterpret_cast<PFNWGLJOINSWAPGROUPNVPROC>(::wglGetProcAddress("wglJoinSwapGroupNV"));
	wglBindSwapBarrierNVPtr = reinterpret_cast<PFNWGLBINDSWAPBARRIERNVPROC>(::wglGetProcAddress("wglBindSwapBarrierNV"));
	wglQuerySwapGroupNVPtr = reinterpret_cast<PFNWGLQUERYSWAPGROUPNVPROC>(::wglGetProcAddress("wglQuerySwapGroupNV"));
	wglQueryMaxSwapGroupsNVPtr = reinterpret_cast<PFNWGLQUERYMAXSWAPGROUPSNVPROC>(::wglGetProcAddress("wglQueryMaxSwapGroupsNV"));
	wglQueryFrameCountNVPtr = reinterpret_cast<PFNWGLQUERYFRAMECOUNTNVPROC>(::wglGetProcAddress("wglQueryFrameCountNV"));
	wglResetFrameCountNVPtr = reinterpret_cast<PFNWGLRESETFRAMECOUNTNVPROC>(::wglGetProcAddress("wglResetFrameCountNV"));

	return wglJoinSwapGroupNVPtr != NULL && wglBindSwapBarrierNVPtr != NULL && wglQuerySwapGroupNVPtr != NULL && wglQueryMaxSwapGroupsNVPtr != NULL && wglQueryFrameCountNVPtr != NULL && 
		wglResetFrameCountNVPtr != NULL;
}

inline bool loadWGL_NV_gpu_affinity()
{
	wglEnumGpusNVPtr = reinterpret_cast<PFNWGLENUMGPUSNVPROC>(::wglGetProcAddress("wglEnumGpusNV"));
	wglEnumGpuDevicesNVPtr = reinterpret_cast<PFNWGLENUMGPUDEVICESNVPROC>(::wglGetProcAddress("wglEnumGpuDevicesNV"));
	wglCreateAffinityDCNVPtr = reinterpret_cast<PFNWGLCREATEAFFINITYDCNVPROC>(::wglGetProcAddress("wglCreateAffinityDCNV"));
	wglEnumGpusFromAffinityDCNVPtr = reinterpret_cast<PFNWGLENUMGPUSFROMAFFINITYDCNVPROC>(::wglGetProcAddress("wglEnumGpusFromAffinityDCNV"));
	wglDeleteDCNVPtr = reinterpret_cast<PFNWGLDELETEDCNVPROC>(::wglGetProcAddress("wglDeleteDCNV"));

	return wglEnumGpusNVPtr != NULL && wglEnumGpuDevicesNVPtr != NULL && wglCreateAffinityDCNVPtr != NULL && wglEnumGpusFromAffinityDCNVPtr != NULL && wglDeleteDCNVPtr != NULL;
}

inline bool loadWGL_AMD_gpu_association()
{
	wglGetGPUIDsAMDPtr = reinterpret_cast<PFNWGLGETGPUIDSAMDPROC>(::wglGetProcAddress("wglGetGPUIDsAMD"));
	wglGetGPUInfoAMDPtr = reinterpret_cast<PFNWGLGETGPUINFOAMDPROC>(::wglGetProcAddress("wglGetGPUInfoAMD"));
	wglGetContextGPUIDAMDPtr = reinterpret_cast<PFNWGLGETCONTEXTGPUIDAMDPROC>(::wglGetProcAddress("wglGetContextGPUIDAMD"));
	wglCreateAssociatedContextAMDPtr = reinterpret_cast<PFNWGLCREATEASSOCIATEDCONTEXTAMDPROC>(::wglGetProcAddress("wglCreateAssociatedContextAMD"));
	wglCreateAssociatedContextAttribsAMDPtr = reinterpret_cast<PFNWGLCREATEASSOCIATEDCONTEXTATTRIBSAMDPROC>(::wglGetProcAddress("wglCreateAssociatedContextAttribsAMD"));
	wglDeleteAssociatedContextAMDPtr = reinterpret_cast<PFNWGLDELETEASSOCIATEDCONTEXTAMDPROC>(::wglGetProcAddress("wglDeleteAssociatedContextAMD"));
	wglMakeAssociatedContextCurrentAMDPtr = reinterpret_cast<PFNWGLMAKEASSOCIATEDCONTEXTCURRENTAMDPROC>(::wglGetProcAddress("wglMakeAssociatedContextCurrentAMD"));
	wglGetCurrentAssociatedContextAMDPtr = reinterpret_cast<PFNWGLGETCURRENTASSOCIATEDCONTEXTAMDPROC>(::wglGetProcAddress("wglGetCurrentAssociatedContextAMD"));
	wglBlitContextFramebufferAMDPtr = reinterpret_cast<PFNWGLBLITCONTEXTFRAMEBUFFERAMDPROC>(::wglGetProcAddress("wglBlitContextFramebufferAMD"));

	return wglGetGPUIDsAMDPtr != NULL && wglGetGPUInfoAMDPtr != NULL && wglGetContextGPUIDAMDPtr != NULL && wglCreateAssociatedContextAMDPtr != NULL && wglCreateAssociatedContextAttribsAMDPtr != NULL && 
		wglDeleteAssociatedContextAMDPtr != NULL && wglMakeAssociatedContextCurrentAMDPtr != NULL && wglGetCurrentAssociatedContextAMDPtr != NULL && wglBlitContextFramebufferAMDPtr != NULL;
}

inline bool loadWGL_NV_video_capture()
{
	wglBindVideoCaptureDeviceNVPtr = reinterpret_cast<PFNWGLBINDVIDEOCAPTUREDEVICENVPROC>(::wglGetProcAddress("wglBindVideoCaptureDeviceNV"));
	wglEnumerateVideoCaptureDevicesNVPtr = reinterpret_cast<PFNWGLENUMERATEVIDEOCAPTUREDEVICESNVPROC>(::wglGetProcAddress("wglEnumerateVideoCaptureDevicesNV"));
	wglLockVideoCaptureDeviceNVPtr = reinterpret_cast<PFNWGLLOCKVIDEOCAPTUREDEVICENVPROC>(::wglGetProcAddress("wglLockVideoCaptureDeviceNV"));
	wglQueryVideoCaptureDeviceNVPtr = reinterpret_cast<PFNWGLQUERYVIDEOCAPTUREDEVICENVPROC>(::wglGetProcAddress("wglQueryVideoCaptureDeviceNV"));
	wglReleaseVideoCaptureDeviceNVPtr = reinterpret_cast<PFNWGLRELEASEVIDEOCAPTUREDEVICENVPROC>(::wglGetProcAddress("wglReleaseVideoCaptureDeviceNV"));

	return wglBindVideoCaptureDeviceNVPtr != NULL && wglEnumerateVideoCaptureDevicesNVPtr != NULL && wglLockVideoCaptureDeviceNVPtr != NULL && wglQueryVideoCaptureDeviceNVPtr != NULL && wglReleaseVideoCaptureDeviceNVPtr != NULL;
}

inline bool loadWGL_NV_copy_image()
{
	wglCopyImageSubDataNVPtr = reinterpret_cast<PFNWGLCOPYIMAGESUBDATANVPROC>(::wglGetProcAddress("wglCopyImageSubDataNV"));

	return wglCopyImageSubDataNVPtr != NULL;
}

inline bool loadWGL_NV_DX_interop()
{
	wglDXSetResourceShareHandleNVPtr = reinterpret_cast<PFNWGLDXSETRESOURCESHAREHANDLENVPROC>(::wglGetProcAddress("wglDXSetResourceShareHandleNV"));
	wglDXOpenDeviceNVPtr = reinterpret_cast<PFNWGLDXOPENDEVICENVPROC>(::wglGetProcAddress("wglDXOpenDeviceNV"));
	wglDXCloseDeviceNVPtr = reinterpret_cast<PFNWGLDXCLOSEDEVICENVPROC>(::wglGetProcAddress("wglDXCloseDeviceNV"));
	wglDXRegisterObjectNVPtr = reinterpret_cast<PFNWGLDXREGISTEROBJECTNVPROC>(::wglGetProcAddress("wglDXRegisterObjectNV"));
	wglDXUnregisterObjectNVPtr = reinterpret_cast<PFNWGLDXUNREGISTEROBJECTNVPROC>(::wglGetProcAddress("wglDXUnregisterObjectNV"));
	wglDXObjectAccessNVPtr = reinterpret_cast<PFNWGLDXOBJECTACCESSNVPROC>(::wglGetProcAddress("wglDXObjectAccessNV"));
	wglDXLockObjectsNVPtr = reinterpret_cast<PFNWGLDXLOCKOBJECTSNVPROC>(::wglGetProcAddress("wglDXLockObjectsNV"));
	wglDXUnlockObjectsNVPtr = reinterpret_cast<PFNWGLDXUNLOCKOBJECTSNVPROC>(::wglGetProcAddress("wglDXUnlockObjectsNV"));

	return wglDXSetResourceShareHandleNVPtr != NULL && wglDXOpenDeviceNVPtr != NULL && wglDXCloseDeviceNVPtr != NULL && wglDXRegisterObjectNVPtr != NULL && wglDXUnregisterObjectNVPtr != NULL && 
		wglDXObjectAccessNVPtr != NULL && wglDXLockObjectsNVPtr != NULL && wglDXUnlockObjectsNVPtr != NULL;
}

namespace Gx
{
	bool hasWGL_ARB_buffer_region = false;
	bool hasWGL_ARB_multisample = false; // no entry points
	bool hasWGL_ARB_extensions_string = false;
	bool hasWGL_ARB_pixel_format = false;
	bool hasWGL_ARB_make_current_read = false;
	bool hasWGL_ARB_pbuffer = false;
	bool hasWGL_ARB_render_texture = false;
	bool hasWGL_ARB_pixel_format_float = false; // no entry points
	bool hasWGL_ARB_framebuffer_sRGB = false; // no entry points
	bool hasWGL_ARB_create_context = false;
	bool hasWGL_ARB_create_context_profile = false; // no entry points
	bool hasWGL_ARB_create_context_robustness = false; // no entry points
	bool hasWGL_EXT_display_color_table = false;
	bool hasWGL_EXT_extensions_string = false;
	bool hasWGL_EXT_make_current_read = false;
	bool hasWGL_EXT_pbuffer = false;
	bool hasWGL_EXT_pixel_format = false;
	bool hasWGL_EXT_swap_control = false;
	bool hasWGL_EXT_depth_float = false; // no entry points
	bool hasWGL_NV_vertex_array_range = false;
	bool hasWGL_3DFX_multisample = false; // no entry points
	bool hasWGL_EXT_multisample = false; // no entry points
	bool hasWGL_OML_sync_control = false;
	bool hasWGL_I3D_digital_video_control = false;
	bool hasWGL_I3D_gamma = false;
	bool hasWGL_I3D_genlock = false;
	bool hasWGL_I3D_image_buffer = false;
	bool hasWGL_I3D_swap_frame_lock = false;
	bool hasWGL_I3D_swap_frame_usage = false;
	bool hasWGL_ATI_pixel_format_float = false; // no entry points
	bool hasWGL_NV_float_buffer = false; // no entry points
	bool hasWGL_3DL_stereo_control = false;
	bool hasWGL_EXT_pixel_format_packed_float = false; // no entry points
	bool hasWGL_EXT_framebuffer_sRGB = false; // no entry points
	bool hasWGL_NV_present_video = false;
	bool hasWGL_NV_video_output = false;
	bool hasWGL_NV_swap_group = false;
	bool hasWGL_NV_gpu_affinity = false;
	bool hasWGL_AMD_gpu_association = false;
	bool hasWGL_NV_video_capture = false;
	bool hasWGL_NV_copy_image = false;
	bool hasWGL_NV_multisample_coverage = false; // no entry points
	bool hasWGL_NV_DX_interop = false;
	bool hasWGL_NV_DX_interop2 = false; // no entry points
	bool hasWGL_EXT_swap_control_tear = false; // no entry points

	static std::string extensions;

	bool hasWGLExtension(const char* extensionName)
	{
		if ( extensions.find(extensionName) != std::string::npos )
		{
			return true;
		}

		return false;
	}

	void loadWGLFuntions()
	{
		HDC deviceContextHandle = wglGetCurrentDC();

		hasWGL_ARB_buffer_region = loadWGL_ARB_buffer_region();
		hasWGL_ARB_extensions_string = loadWGL_ARB_extensions_string();
		hasWGL_ARB_pixel_format = loadWGL_ARB_pixel_format();
		hasWGL_ARB_make_current_read = loadWGL_ARB_make_current_read();
		hasWGL_ARB_pbuffer = loadWGL_ARB_pbuffer();
		hasWGL_ARB_render_texture = loadWGL_ARB_render_texture();
		hasWGL_ARB_create_context = loadWGL_ARB_create_context();
		hasWGL_EXT_display_color_table = loadWGL_EXT_display_color_table();
		hasWGL_EXT_extensions_string = loadWGL_EXT_extensions_string();
		hasWGL_EXT_make_current_read = loadWGL_EXT_make_current_read();
		hasWGL_EXT_pbuffer = loadWGL_EXT_pbuffer();
		hasWGL_EXT_pixel_format = loadWGL_EXT_pixel_format();
		hasWGL_EXT_swap_control = loadWGL_EXT_swap_control();
		hasWGL_NV_vertex_array_range = loadWGL_NV_vertex_array_range();
		hasWGL_OML_sync_control = loadWGL_OML_sync_control();
		hasWGL_I3D_digital_video_control = loadWGL_I3D_digital_video_control();
		hasWGL_I3D_gamma = loadWGL_I3D_gamma();
		hasWGL_I3D_genlock = loadWGL_I3D_genlock();
		hasWGL_I3D_image_buffer = loadWGL_I3D_image_buffer();
		hasWGL_I3D_swap_frame_lock = loadWGL_I3D_swap_frame_lock();
		hasWGL_I3D_swap_frame_usage = loadWGL_I3D_swap_frame_usage();
		hasWGL_3DL_stereo_control = loadWGL_3DL_stereo_control();
		hasWGL_NV_present_video = loadWGL_NV_present_video();
		hasWGL_NV_video_output = loadWGL_NV_video_output();
		hasWGL_NV_swap_group = loadWGL_NV_swap_group();
		hasWGL_NV_gpu_affinity = loadWGL_NV_gpu_affinity();
		hasWGL_AMD_gpu_association = loadWGL_AMD_gpu_association();
		hasWGL_NV_video_capture = loadWGL_NV_video_capture();
		hasWGL_NV_copy_image = loadWGL_NV_copy_image();
		hasWGL_NV_DX_interop = loadWGL_NV_DX_interop();

		if ( hasWGL_ARB_extensions_string )
		{
			const char* result = wglGetExtensionsStringARB(deviceContextHandle);
			if ( result != NULL )
			{
				extensions = result;
			}
		}
		else if ( hasWGL_EXT_extensions_string )
		{
			const char* result = wglGetExtensionsStringEXT();
			if ( result != NULL )
			{
				extensions = result;
			}
		}

		hasWGL_ARB_multisample = hasWGLExtension("WGL_ARB_multisample");
		hasWGL_ARB_pixel_format_float = hasWGLExtension("WGL_ARB_pixel_format_float");
		hasWGL_ARB_framebuffer_sRGB = hasWGLExtension("WGL_ARB_framebuffer_sRGB");
		hasWGL_ARB_create_context_profile = hasWGLExtension("WGL_ARB_create_context_profile");
		hasWGL_ARB_create_context_robustness = hasWGLExtension("WGL_ARB_create_context_robustness");
		hasWGL_EXT_depth_float = hasWGLExtension("WGL_EXT_depth_float");
		hasWGL_3DFX_multisample = hasWGLExtension("WGL_3DFX_multisample");
		hasWGL_EXT_multisample = hasWGLExtension("WGL_EXT_multisample");
		hasWGL_ATI_pixel_format_float = hasWGLExtension("WGL_ATI_pixel_format_float");
		hasWGL_NV_float_buffer = hasWGLExtension("WGL_NV_float_buffer");
		hasWGL_EXT_pixel_format_packed_float = hasWGLExtension("WGL_EXT_pixel_format_packed_float");
		hasWGL_EXT_framebuffer_sRGB = hasWGLExtension("WGL_EXT_framebuffer_sRGB");
		hasWGL_NV_multisample_coverage = hasWGLExtension("WGL_NV_multisample_coverage");
		hasWGL_NV_DX_interop2 = hasWGLExtension("WGL_NV_DX_interop2");
		hasWGL_EXT_swap_control_tear = hasWGLExtension("WGL_EXT_swap_control_tear");
	}
}