#include "sampleshapesgame.h"

#include <gxframework/vertextype.h>

SampleShapesGame::SampleShapesGame()
{
	preferAntialising(4);
}

GxF32 rand(GxF32 a, GxF32 b)
{
	const GxF32 tmp = b - a;
	return (rand() % 100) / 100.0f * tmp + a;
}

void SampleShapesGame::initialize()
{
	SampleGame::initialize();

	//
	camera->lookAt(PxVec3(50, 110, 330), PxVec3(50, 20, 140));
}

void SampleShapesGame::release()
{
	SampleGame::release();
}

void SampleShapesGame::input(GxF32 elapsedTime)
{
	SampleGame::input(elapsedTime);

	if ( getKeyboard().isKeyPressed(Keys::Space) )
	{
		PxVec3 velocity = camera->getViewDir();
		velocity *= 150.0f;
		this->throwBox(camera->getPosition(), 2.0f, velocity, defaultPhysicsMaterial);
	}

	const GxF32 fps = getStepper().getFps();
	std::stringstream stream;
	stream << "Sample Shape | Fps: " << std::fixed << std::setprecision(1) << fps 
		<< " | Dynamic actors: " << scene->getNbActors(PxActorTypeSelectionFlag::eRIGID_DYNAMIC)
		<< " | Static actors: " << scene->getNbActors(PxActorTypeSelectionFlag::eRIGID_STATIC)
		<< " | Camera position: " << camera->getPosition().x << " ; " << camera->getPosition().y << " ; " << camera->getPosition().z;

	this->setTitle(stream.str());
}

void SampleShapesGame::update(GxF32 elapsedTime)
{
	SampleGame::update(elapsedTime);
}

void SampleShapesGame::render(GxF32 elapsedTime)
{
	SampleGame::render(elapsedTime);

	graphics->clear(Color::CornflowerBlue);

	effect->bind();
	effect->setProjMatrix(projectionMtx);
	effect->setViewMatrix(camera->getViewMatrix());

	this->renderScene(scene);

	effect->unbind();
}

/*
bool SampleShapesGame::loadRawHeightField(const char* filename, unsigned char* buffer, int& width, int& height)
{
	width = height = 0;

	FILE* f = NULL;
	fopen_s(&f, filename, "rb");

	if ( f )
	{
		char signature[16];
		fread(signature, 16, 1, f);

		if ( strcmp("RAW_HEIGHTMAP", signature) == 0 )
		{
			fread(&width, 4, 1, f);
			fread(&height, 4, 1, f);

			GX_ASSERT(width > 0 && height > 0, "Invalid heightmap dimensions.");

			if ( buffer != NULL )
			{
				fread(buffer, width * height, 1, f);
			}
		}

		fclose(f);

		return true;
	}

	return false;
}
*/

void SampleShapesGame::printHelp()
{
	SampleGame::printHelp();

	std::cout << std::endl << "# Dodawanie ksztaltow" << std::endl
		<< "Spacja - rzucenie pudelkiem w kierunku patrzenia" << std::endl
		<< "Z - dodanie stosu pudelek" << std::endl
		<< "X - dodanie sciany zbudowanej z pudelek" << std::endl
		<< "C - dodanie kapsuly" << std::endl
		<< "V - dodanie sfery" << std::endl;
}
