template<typename T>
T rzut(int i, T* y, T t)
{
	const static T g = 9.81; //-> jednostki, m/s^2

	switch (i)
	{
	case 0:
		return y[1];
	case 1:
		return g;
	default:
		throw std::runtime_error("Zy numer rwnania");
	}
}

template<typename T>
T oscylator_harmoniczny(int i, T* y, T t)
{
	const static T k = 1;

	switch (i)
	{
	case 0:
		return y[1];
	case 1:
		return -k*y[0];
	default:
		throw std::runtime_error("Zy numer rwnania");
	}
}

template<typename T>
T oscylatory_sprzezone(int i, T* y, T t)
{
	const static T k = 1;
	const static T l = 1;

	if (i % 2 == 0) return y[i + 1];
	else
	{
		T wynik = 0;
		if (i > 1) wynik += -k*(y[i - 1] - y[i - 3] - l);
		if (i < N - 1) wynik += -k*(y[i - 1] - y[i + 1] + l);
		return wynik;
	}
}

//--------------------------------------------------

#include <math.h>

//SI (m, s, kg)
const double jednostkaOdleglosci = 384403000; //384,493 tys.km; promie orbity Ksiyca
const double jednostkaMasy = 5.9736E24; //kg, masa Ziemi
const double jednostkaCzasu = 24 * 60 * 60; //s, dzien Ziemski

#define SQR(x) ((x)*(x))

template<typename T>
T grawitacja(int i, T* y, T t) //zagadnienie 2 cial w 2D
//y[0]=x1, y[1]=vx1, y[2]=y1, y[3]=vy1
//y[4]=x2, y[5]=vx2, y[6]=y2, y[7]=vy2
{
	static const T G = 6.6742867E-11;
	static const T M = jednostkaMasy;
	static const T m = 0.0123*jednostkaMasy;

	T odleglosc_x = y[4] - y[0]; //(r2-r1)x
	T odleglosc_y = y[6] - y[2]; //(r2-r1)y
	T kwadrat_odleglosci = SQR(odleglosc_x) + SQR(odleglosc_y); //r12^2
	T odleglosc = sqrt(kwadrat_odleglosci);
	T sila = G*M*m / kwadrat_odleglosci;
	
	T _x = odleglosc_x / odleglosc;
	T _y = odleglosc_y / odleglosc;

	switch (i)
	{
		//Ziemia
	case 0:
		return y[1];
	case 1:
		return sila*_x / M;
	case 2:
		return y[3];
	case 3:
		return sila*_y / M;
	case 4:
		return y[5];
	case 5:
		return -sila*_x / m;
	case 6:
		return y[7];
	case 7:
		return -sila*_y / m;
	default:
		throw std::runtime_error("Zy numer rwnania");
		return 0;
	}
}