﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Verlet
{
    class Program
    {
        #region Numeryka

        static void NewtonEuler(double x, double v, double a, double h, out double x_nast, out double v_nast)
        {
            v_nast = v + a * h;
            x_nast = x + v * h;
        }

        static void NewtonEulerPoprawiony(double x, double v, double a, double h, out double x_nast, out double v_nast)
        {
            v_nast = v + a * h;
            x_nast = x + v_nast * h;
        }

        static void NewtonVerlet(double x, double x_poprz, double a, double h, out double x_nast, out double v)
        {
            x_nast = -x_poprz + 2 * x + a * h * h;
            v = (x_nast - x_poprz) / (2 * h);
        }

        static void NewtonVerletPredkosciowy(double x, double v, double a, double h, out double x_nast, out double v_nast)
        {
            x_nast = x + v * h + (a / 2.0) * h * h;
            v_nast = v + ((x_nast + x) / 2) * h;
        }

        static void NewtonVerletSkokowy(double x, double v_2, double a, double h, out double x_nast, out double v_nast_2)
        {
            v_nast_2 = v_2 + h * a;
            x_nast = x + h * v_nast_2;
        }
        #endregion

        #region Fizyka
        static double PrzyspieszenieOscylatoraHarmonicznego(double x)
        {
            double k = 1;
            double m = 1;
            return -k * x / m;
        }
        #endregion

        static void Main(string[] args)
        {
            double x, v; //stan oscylatora
            double x_poprz;
            double x_nast, v_nast;            
            const double tmax = 100;
            const double h = 0.01;

            //warunki początkowe
            x = 1; v = 0; //dla Eulera
            //x = 1; x_poprz = x; //dla Verleta, implikuje v = 0;

            for(double t = 0; t<tmax; t+=h)
            {
                //NewtonEuler(x, v, PrzyspieszenieOscylatoraHarmonicznego(x), h, out x_nast, out v_nast);
                //NewtonEulerPoprawiony(x, v, PrzyspieszenieOscylatoraHarmonicznego(x), h, out x_nast, out v_nast);
                //NewtonVerlet(x, x_poprz, PrzyspieszenieOscylatoraHarmonicznego(x), h, out x_nast, out v);
                NewtonVerletPredkosciowy(x, v, PrzyspieszenieOscylatoraHarmonicznego(x), h, out x_nast, out v_nast);
                //NewtonVerletSkokowy(x, v, PrzyspieszenieOscylatoraHarmonicznego(x), h, out x_nast, out v_nast);

                //x = x_nast; v = v_nast; //Euler
                x_poprz = x; x = x_nast; //Verlet

                //Console.WriteLine("t=" + t + ", x=" + x + ", v=" + v);
                string s = t + "\t" + x + "\t" + v;                
                Console.WriteLine(s.Replace(',','.'));
            }
        }
    }
}
