﻿using System;
using System.Collections.Generic;

namespace LogisticGrowthEquation
{
    class FirstOrder
    {
        private double[] d, e;

        public List<Point2d> CalculatePoints(double a, double b,
            double ya, int n, Func<double, double, double> fxy)
        {
            double h = (b - a) / n, x, y;
            int fi = 1;
            Point2d pt = new Point2d();
            List<Point2d> pts = new List<Point2d>();

            d = new double[5];
            e = new double[3];
            e[1] = 1.0e-12;
            e[2] = 1.0e-10;

            for (int i = 1; i <= n; i++)
            {
                fi = i == 1 ? 1 : 0;
                x = a + i * h;
                pt.x = x;
                y = Solve(ref x, a, x, ya, fi, fxy);
                pt.y = y;
                pts.Add(pt);
            }

            return pts;
        }

        private double Solve(ref double x, double a, double b, double ya, int fi,
            Func<double, double, double> fxy)
        {
            double y = 0.0;
            rk1(ref x, a, b, ref y, ya, fxy, e, d, fi);
            return y;
        }

        private void rk1(ref double x, double a, double b, ref double y, double ya,
            Func<double, double, double> fxy, double[] e, double[] d, int fi)
        {
            int last = 0, first, reject, test, ta, tb;
            double e1, e2, xl, yl, h, ind, hmin, absh, k0, k1, k2, k3, k4,
                k5, discr, tol, mu, mu1 = 0, fh, hl = 0;

            if (fi == 1)
            {
                d[3] = a;
                d[4] = ya;
            }
            d[1] = 0.0;
            xl = d[3];
            yl = d[4];
            if (fi == 1) d[2] = b - d[3];
            absh = h = Math.Abs(d[2]);
            if (b - xl < 0.0) h = -h;
            ind = Math.Abs(b - xl);
            hmin = ind * e[1] + e[2];
            e1 = e[1] / ind;
            e2 = e[2] / ind;
            first = 1;
            test = 1;
            if (fi == 1)
            {
                last = 1;
                test = 0;
            }
            while (true)
            {
                if (test == 1)
                {
                    absh = Math.Abs(h);
                    if (absh < hmin)
                    {
                        h = (h > 0.0) ? hmin : -hmin;
                        absh = hmin;
                    }
                    ta = (h >= b - xl) ? 1 : 0;
                    tb = (h >= 0.0) ? 1 : 0;
                    if ((ta == 1 && tb == 1) || (!(ta == 1 || tb == 1)))
                    {
                        d[2] = h;
                        last = 1;
                        h = b - xl;
                        absh = Math.Abs(h);
                    }
                    else
                        last = 0;
                }
                test = 1;
                x = xl;
                y = yl;
                k0 = fxy(x, y) * h;
                x = xl + h / 4.5;
                y = yl + k0 / 4.5;
                k1 = fxy(x, y) * h;
                x = xl + h / 3.0;
                y = yl + (k0 + k1 * 3.0) / 12.0;
                k2 = fxy(x, y) * h;
                x = xl + h * 0.5;
                y = yl + (k0 + k2 * 3.0) / 8.0;
                k3 = fxy(x, y) * h;
                x = xl + h * 0.8;
                y = yl + (k0 * 53.0 - k1 * 135.0 + k2 * 126.0 + k3 * 56.0) / 125.0;
                k4 = fxy(x, y) * h;
                x = (last == 1) ? b : xl + h;
                y = yl + (k0 * 133.0 - k1 * 378.0 + k2 * 276.0 + k3 * 112.0 + k4 * 25.0) / 168.0;
                k5 = fxy(x, y) * h;
                discr = Math.Abs(k0 * 21.0 - k2 * 162.0 + k3 * 224.0 - k4 * 125.0 + k5 * 42.0) / 14.0;
                tol = Math.Abs(k0) * e1 + absh * e2;
                reject = discr > tol ? 1 : 0;
                mu = tol / (tol + discr) + 0.45;
                if (reject == 1)
                {
                    if (absh <= hmin)
                    {
                        d[1] += 1.0;
                        y = yl;
                        first = 1;
                        if (b == x) break;
                        xl = x;
                        yl = y;
                    }
                    else
                        h *= mu;
                }
                else
                {
                    if (first == 1)
                    {
                        first = 0;
                        hl = h;
                        h *= mu;
                    }
                    else
                    {
                        fh = mu * h / hl + mu - mu1;
                        hl = h;
                        h *= fh;
                    }
                    mu1 = mu;
                    y = yl + (-k0 * 63.0 + k1 * 189.0 - k2 * 36.0 - k3 * 112.0 + k4 * 50.0) / 28.0;
                    k5 = fxy(x, y) * hl;
                    y = yl + (k0 * 35.0 + k2 * 162.0 + k4 * 125.0 + k5 * 14.0) / 336.0;
                    if (b == x) break;
                    xl = x;
                    yl = y;
                }
            }
            if (!(last == 1)) d[2] = h;
            d[3] = x;
            d[4] = y;
        }
    }
}
