﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Windows.Forms;

namespace LogisticGrowthEquation
{
    public partial class MainForm : Form
    {
        private double N;
        private double r;
        private double ya;
        private FirstOrder fo;
        private Random random;

        public MainForm()
        {
            InitializeComponent();
            comboBox1.SelectedIndex = 0;
            comboBox2.SelectedIndex = 0;
            fo = new FirstOrder();
            random = new Random();
        }

        private double fxy(double x, double y)
        {
            return r * y * (1.0 - y / N); 
        }

        private void button1_Click(object sender, EventArgs e)
        {
            
            r = double.Parse((string)comboBox1.SelectedItem);
            N = double.Parse((string)comboBox2.SelectedItem);
            do
            {
                ya = N * random.NextDouble();
            } while (ya < 2);
            List<Point2d> pts = fo.CalculatePoints(0.0, 30.0, ya, 1000, fxy);
            DrawGraphForm dgf = new DrawGraphForm(2, "P(t)", pts);
            dgf.Show();
        }
    }
}