#include "MojeOkno.h"
#include "Varia.h"
#include "resource.h"
#include <sstream>
#include "SolarSystem.h"

CMojeOknoGL::CMojeOknoGL()
:COknoGL(),zpm(NULL),przesunDoSrodkaMasy(false),
algorytm(algorytmVerleta),krokCzasowy(0.002),iloscKrokowWSerii(1),
pauza(false),typRzutowania(false),symulacja_start(false)
{			
	zpm = new SolarSystem(10, 1.18404e-4, Wektor(-60, 60, 60), Wektor(60, -60, -60));
	
	#ifdef _DEBUG
	if(zpm==NULL) MessageBox(uchwytOkna,"Brak zbioru punktw materialnych","Debug info",MB_OK);
	#endif
}

CMojeOknoGL::~CMojeOknoGL()
{
	delete zpm;
	zpm=NULL;
}

void CMojeOknoGL:: RysujPojemnik_Szescian(void)
{
	float wsp = 100;
	
	glBindTexture(GL_TEXTURE_2D, indeksTekstury[10]);
	glEnable(GL_TEXTURE_2D);
	glBegin(GL_QUADS);

	glTexCoord2f(0.0f, 0.0f);	glVertex3f(-wsp, -wsp, wsp);
	glTexCoord2f(wsp, 0.0f);	glVertex3f(wsp, -wsp, wsp);
	glTexCoord2f(wsp, wsp);		glVertex3f(wsp, wsp, wsp);
	glTexCoord2f(0.0f, wsp);	glVertex3f(-wsp, wsp, wsp);
	glDisable(GL_TEXTURE_2D);
	glEnd();
	
	glBindTexture(GL_TEXTURE_2D, indeksTekstury[11]);
	glEnable(GL_TEXTURE_2D);
	glBegin(GL_QUADS);

	//kierunek 2
	glTexCoord2f(0.0f, 0.0f);	glVertex3f(wsp, wsp, wsp);
	glTexCoord2f(wsp, 0.0f);	glVertex3f(wsp, wsp, -wsp);
	glTexCoord2f(wsp, wsp);		glVertex3f(wsp, -wsp, -wsp);
	glTexCoord2f(0.0f, wsp);	glVertex3f(wsp, -wsp, wsp);

	glDisable(GL_TEXTURE_2D);
	glEnd();
	
	glBindTexture(GL_TEXTURE_2D, indeksTekstury[12]);
	glEnable(GL_TEXTURE_2D);
	glBegin(GL_QUADS);

	//kierunek 2
	glTexCoord2f(0.0f, 0.0f);	glVertex3f(wsp, wsp, -wsp);
	glTexCoord2f(wsp, 0.0f);	glVertex3f(-wsp, wsp, -wsp);
	glTexCoord2f(wsp, wsp);		glVertex3f(-wsp, -wsp, -wsp);
	glTexCoord2f(0.0f, wsp);	glVertex3f(wsp, -wsp, -wsp);

	glDisable(GL_TEXTURE_2D);
	glEnd();

	// new face
	glBindTexture(GL_TEXTURE_2D, indeksTekstury[13]);
	glEnable(GL_TEXTURE_2D);
	glBegin(GL_QUADS);

	//kierunek 2
	glTexCoord2f(0.0f, 0.0f);	glVertex3f(-wsp, -wsp, -wsp);
	glTexCoord2f(wsp, 0.0f);	glVertex3f(-wsp, -wsp, wsp);
	glTexCoord2f(wsp, wsp);		glVertex3f(-wsp, wsp, wsp);
	glTexCoord2f(0.0f, wsp);	glVertex3f(-wsp, wsp, -wsp);

	glDisable(GL_TEXTURE_2D);
	glEnd();
	
	glBindTexture(GL_TEXTURE_2D, indeksTekstury[14]);
	glEnable(GL_TEXTURE_2D);
	glBegin(GL_QUADS);

	//kierunek 2
	glTexCoord2f(0.0f, 0.0f);	glVertex3f(-wsp, wsp, -wsp);
	glTexCoord2f(wsp, 0.0f);	glVertex3f(wsp, wsp, -wsp);
	glTexCoord2f(wsp, wsp);		glVertex3f(wsp, wsp, wsp);
	glTexCoord2f(0.0f, wsp);	glVertex3f(-wsp, wsp, wsp);

	glDisable(GL_TEXTURE_2D);
	glEnd();
	
	glBindTexture(GL_TEXTURE_2D, indeksTekstury[15]);
	glEnable(GL_TEXTURE_2D);
	glBegin(GL_QUADS);
	
	//kierunek 2
	glTexCoord2f(0.0f, 0.0f);	glVertex3f(-wsp, -wsp, -wsp);
	glTexCoord2f(wsp, 0.0f);	glVertex3f(wsp, -wsp, -wsp);
	glTexCoord2f(wsp, wsp);		glVertex3f(wsp, -wsp, wsp);
	glTexCoord2f(0.0f, wsp);	glVertex3f(-wsp, -wsp, wsp);

	glDisable(GL_TEXTURE_2D);
	glEnd();
	glBindTexture(GL_TEXTURE_2D, NULL);
	
}

double CMojeOknoGL::Symulacja() {

	return zpm->Symulacja();

}

void CMojeOknoGL::RysujOrbity(ZbiorPunktowMaterialnych* zpm, const double jednostkaDlugosci, const float gruboscLinii, bool koloruj) const {

	glPushMatrix();

	glLineWidth(gruboscLinii);
	PunktMaterialny* Soce = zpm->PobierzPunktMaterialny(0);
	Wektor polozenieSoca = Soce->Polozenie();
	glTranslatef(polozenieSoca.X, polozenieSoca.Y, polozenieSoca.Z);
	
	for (int indeks = 1; indeks<zpm->LiczbaPunktow(); ++indeks)
	{
		PunktMaterialny* punkt = zpm->PobierzPunktMaterialny(indeks);
		Wektor polozeniePunktu = jednostkaDlugosci*punkt->Polozenie();
		Wektor r12 = polozenieSoca - punkt->Polozenie();
		double odleglosc = r12.Dlugosc();
		if (koloruj) glColor4fv(punkt->Kolor());
		glBegin(GL_LINE_STRIP);
		
		for (float kt = 0.0f; kt < 6.283185307f; kt += 0.05f)
		{
			glVertex3f(sin(kt) * odleglosc, cos(kt) * odleglosc, 0.0f);
		}
		glVertex3f(0.0f, odleglosc, 0.0f);

		glEnd();
	}
	glTranslatef(-polozenieSoca.X, -polozenieSoca.Y, -polozenieSoca.Z);
	glPopMatrix();
}


void CMojeOknoGL::RysujZPM(ZbiorPunktowMaterialnych* zpm, const double jednostkaDlugosci, bool koloruj) const
{
	//koloruj = true;
	static float obrotX[10] = { 0 };
	static float obrotY[10] = { 0 };
	static float obrotZ[10] = { 0 };
	static float kat[10] = { 0,0.19169,0.79437,0.00325,0.00335,0.00135,0.00145,0.00234,0.00219,0.0};
	float mnoznik = 10000;
	if (zpm == NULL) return;

	RysujOrbity(zpm, jednostkaDlugosci, 1, false);
	glPushMatrix();

	//zero ukladu wspolrzednych w srodku masy	
	if (przesunDoSrodkaMasy)
	{
		Wektor srodekMasy = jednostkaDlugosci*zpm->SrodekMasy();
		glTranslated(-srodekMasy.X, -srodekMasy.Y, -srodekMasy.Z);
	}

	GLUquadricObj* kwadryka = gluNewQuadric();
	gluQuadricDrawStyle(kwadryka, GLU_FILL);
	glShadeModel(GL_SMOOTH);

	const int ilePunktowWKazdymWymiarze = 20; //jakosc sfery (moze byc zalezna np. od tego, czy trwa przeciaganie)

	for (int indeks = 0; indeks<zpm->LiczbaPunktow(); ++indeks)
	{
		PunktMaterialny* punkt = zpm->PobierzPunktMaterialny(indeks);
		Wektor polozeniePunktu = jednostkaDlugosci*punkt->Polozenie();

		if (koloruj) glColor4fv(punkt->Kolor());

		glPushMatrix();
		glTranslated(polozeniePunktu.X, polozeniePunktu.Y, polozeniePunktu.Z);

		glBindTexture(GL_TEXTURE_2D, indeksTekstury[indeks]);
		glEnable(GL_TEXTURE_2D);
		gluQuadricTexture(kwadryka, GL_TRUE);

		obrotX[indeks] += kat[indeks] * mnoznik;
		if (obrotX[indeks]>360) obrotX[indeks] -= 360;
		
		glRotatef(obrotX[indeks], 0, 0, 1);

		gluSphere(kwadryka, jednostkaDlugosci*punkt->Promien(), ilePunktowWKazdymWymiarze, ilePunktowWKazdymWymiarze);

		gluQuadricTexture(kwadryka, GL_FALSE);
		glDisable(GL_TEXTURE_2D);


		glPopMatrix();
	}

	gluDeleteQuadric(kwadryka);
	glPopMatrix();
}

LRESULT CMojeOknoGL::WndProc(HWND hWnd, UINT message, WPARAM wParam,LPARAM lParam)
{	
	const int IDT_TIMER_OBLICZEN=3;
	const int IDT_TIMER_RYSOWANIA=4;
	const int IDT_TIMER_POCISK = 5;

	long wynik=COknoGL::WndProc(hWnd,message,wParam,lParam);		

	switch (message)
	{
		case WM_CREATE: 
			if (SetTimer(hWnd,IDT_TIMER_OBLICZEN,USER_TIMER_MINIMUM,NULL)==0)
				MessageBox(hWnd,"Nie udao si ustawi timera obliczen","",MB_OK | MB_ICONERROR);
			if (SetTimer(hWnd,IDT_TIMER_RYSOWANIA,50,NULL)==0)
				MessageBox(hWnd,"Nie udao si ustawi timera rysowania","",MB_OK | MB_ICONERROR);
			if (SetTimer(hWnd, IDT_TIMER_POCISK, 100, NULL) == 0)
				MessageBox(hWnd, "Nie udao si ustawi timera obliczen", "", MB_OK | MB_ICONERROR);
			poprzedniCzas=GetTickCount();
			break;
		case WM_TIMER:

			if (pauza) break;
			switch(wParam)
			{
				case IDT_TIMER_OBLICZEN:
					if (zpm!=NULL)
						for(int i=0;i<iloscKrokowWSerii;i++) 
							zpm->KrokNaprzod(krokCzasowy,algorytm);					
					break;
				case IDT_TIMER_RYSOWANIA:
					RysujScene();
					break;
				case IDT_TIMER_POCISK:
					if (symulacja_start) {

						double stan = Symulacja();
						if (stan!=0.0) {

							if(stan<0) 
								zpm->ZerujNrKrokow();
							else {
								
								std::stringstream w;
								w <<"Ustalona warto Trzeciej Prdkoci Kosmicznej: "<< stan;
								symulacja_start = false;
								MessageBox(uchwytOkna, w.str().c_str(), "Wynik dowiadczenia", MB_OK);
								zpm->ZerujNrKrokow();

							}	
						}
					}
					break;
			}
			wynik=0;

			break;
		case WM_DESTROY:
			glDeleteTextures(16, indeksTekstury);
			KillTimer(uchwytOkna,IDT_TIMER_OBLICZEN);
			KillTimer(uchwytOkna,IDT_TIMER_RYSOWANIA);
			KillTimer(uchwytOkna, IDT_TIMER_POCISK);
			break;

		case WM_KEYDOWN:
			{
				PunktMaterialny* punkt0=zpm->PobierzPunktMaterialny(0);
				double zmianaPolozenia=0.05;

				bool wywolacRysujScene=true;
				switch(wParam)
				{
					case 'C':
						typRzutowania=!typRzutowania;
						UstawienieSceny(typRzutowania);
						break;
					case VK_SPACE:
						pauza=!pauza;
						wywolacRysujScene=false;
						break;
					case VK_TAB:
						if(!symulacja_start) symulacja_start = true;
						break;
				}
				if (wywolacRysujScene) RysujScene();
				break;
			}
	}
	
	return wynik;
}

void CMojeOknoGL::PrzygotujTekstury() {

	int teksturaSzer[16];
	int teksturaWys[16];
	char* plikiTekstury[16] = {"sun.bmp","mercury.bmp","venus.bmp","earth.bmp","mars.bmp","jupiter.bmp","saturn.bmp","uranus.bmp","neptune.bmp","mars2.bmp","hipp81.bmp","hipp82.bmp","hipp83.bmp","hipp84.bmp","hipp85.bmp","hipp86.bmp" };
	
	glGenTextures(16, indeksTekstury);

	unsigned long* tekstura[16];
	for (unsigned int i = 0; i < 16; ++i) {
		
		tekstura[i] = WczytajTeksture(uchwytOkna, plikiTekstury[i], teksturaSzer[i], teksturaWys[i], false, 128);
	}

	for (unsigned int i = 0; i < 16;++i){

			glBindTexture(GL_TEXTURE_2D, indeksTekstury[i]);
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
			glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

			glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, teksturaSzer[i], teksturaWys[i], 0, GL_RGBA, GL_UNSIGNED_BYTE, tekstura[i]);
			delete[] tekstura[i];
		}
		
	
}

void CMojeOknoGL::RysujAktorow()
{	
	const double jednostkaDlugosci=1;

	//srodek ukladu wspolrzednych
	glColor3f(1,1,1);
	glPointSize(1);
	glBegin(GL_POINTS);
	glVertex3f(0,0,0);
	glEnd();	

	static bool teksturaZainicjowana = false;

	if (!teksturaZainicjowana) {
		PrzygotujTekstury();
		teksturaZainicjowana = true;
	}

	glPointSize(3);
	RysujPojemnik_Szescian();
	RysujZPM(zpm, jednostkaDlugosci, false);
}

#pragma region Zrodla swiatla
//zrodla swiatla
/*
void CMojeOknoGL::ZrodlaSwiatla()
{
	natezenie_swiatla_tla=0.5f;
	MlecznaZarowka(0.5f);
	
}


void CMojeOknoGL::MlecznaZarowka(float jasnosc)
{	
	const float kolor[4]={jasnosc,jasnosc,jasnosc,1.0f};
	const float pozycja[4]={5.0f,0.0f,5.0f,1.0f};	
	glLightfv(GL_LIGHT1,GL_POSITION,pozycja);
	glLightfv(GL_LIGHT1,GL_DIFFUSE,kolor);
	glEnable(GL_LIGHT1);
}

void CMojeOknoGL::ZoltaIZielonaMleczneZarowki()
{
	//zolta mleczna zarowka
	const float kolor_zolta[4]={1.0f,1.0f,0.0f,1.0f};
	const float pozycja_zolta[4]={-2.0f,0.0f,1.0f,1.0f};
	glLightfv(GL_LIGHT2,GL_POSITION,pozycja_zolta);
	glLightfv(GL_LIGHT2,GL_DIFFUSE,kolor_zolta);
	//glEnable(GL_LIGHT2);

	//zielona mleczna zarowka
	const float kolor_zielony[4]={0.0f,1.0f,0.0f,1.0f};
	const float pozycja_zielony[4]={2.0f,0.0f,1.0f,1.0f};
	glLightfv(GL_LIGHT3,GL_POSITION,pozycja_zielony);
	glLightfv(GL_LIGHT3,GL_DIFFUSE,kolor_zielony);
	//glEnable(GL_LIGHT3);
}

void CMojeOknoGL::Reflektor(float jasnoscRozblysk,float jasnoscRozproszone)
{
	const float kolor_rozproszone[4]={jasnoscRozproszone,jasnoscRozproszone,jasnoscRozproszone,1.0f};
	const float kolor_rozblysk[4]={jasnoscRozblysk,jasnoscRozblysk,jasnoscRozblysk,1.0};
	const float pozycja[4]={-10.0f,-10.0f,10.0f,1.0f};	
	const float kierunek[4]={1.0,1.0,-1.0,1.0};   
	const float szerokosc_wiazki=30.0f; //w stopniach
	const float wygaszanie=1.0f;
   
	glLightfv(GL_LIGHT4,GL_POSITION,pozycja);
	glLightfv(GL_LIGHT4,GL_DIFFUSE,kolor_rozproszone);

	glLightfv(GL_LIGHT4,GL_SPECULAR,kolor_rozblysk);
	glLightfv(GL_LIGHT4,GL_SPOT_DIRECTION,kierunek);
	glLightf(GL_LIGHT4,GL_SPOT_CUTOFF,szerokosc_wiazki);
	glLightf(GL_LIGHT4,GL_SPOT_EXPONENT,wygaszanie);
	//glEnable(GL_LIGHT4);
}*/
#pragma endregion
