﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using KsiegaGosciMVC.Models;

namespace KsiegaGosciMVC.Controllers
{
    public class KsiegaGosciController : Controller
    {
        //
        // GET: /KsiegaGosci/

        public ActionResult Index()
        {
            ViewData.Add("wpisy", wpisy);
            return View(new Wpis());
        }

        const string nazwaPlikuXml=@"c:\Prywatne\Wpisy.xml";
        Wpisy wpisy = new Wpisy(nazwaPlikuXml);

        [HttpPost]
        //public ActionResult Index(FormCollection formularz)
        public ActionResult Index(Wpis nowyWpis)
        {
            /*
            string nazwaUżytkownika = formularz["NazwaUżytkownika"];
            string treśćWpisu = formularz["Treść"];

            if (nazwaUżytkownika != "" && treśćWpisu != "")
            {
                Wpis wpis = new Wpis(nazwaUżytkownika.Trim(), treśćWpisu.Trim(), DateTime.Now, Request.UserHostAddress);
                wpisy.Dodaj(wpis);

                ZapamiętajNazwęUżytkownika(nazwaUżytkownika);
                ViewData.Add("nazwaOstatniegoUżytkownika", nazwaUżytkownika);
            }

            ViewData.Add("wpisy", wpisy);
            return View(new Wpis());
            */

            nowyWpis.Data = DateTime.Now;
            if (ModelState.IsValid)
            {
                wpisy.Dodaj(nowyWpis);
            }

            ViewData.Add("wpisy", wpisy);
            return View(new Wpis());
        }

        void ZapamiętajNazwęUżytkownika(string nazwaUżytkownika)
        {
            HttpCookie ciasteczko = new HttpCookie("imie", nazwaUżytkownika) { Expires = DateTime.Today.AddDays(3) };
            ciasteczko.Expires = DateTime.Today.AddDays(3);
            Response.Cookies.Add(ciasteczko);
        }
    }
}
