namespace Sample.Mvvm.App.Sl.Utils
{
    using System;
    using System.ComponentModel;
    using System.Linq.Expressions;

    public class PropertyChangedBase : INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler PropertyChanged;

        protected void RaisePropertyChanged(string property)
        {
            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(property));
        }

        protected void RaisePropertyChanged<T>(Expression<Func<T>> propertyExpression)
        {
            if (propertyExpression.Body.NodeType == ExpressionType.MemberAccess)
            {
                var memberExpr = propertyExpression.Body as MemberExpression;
                if (memberExpr != null)
                {
                    var propertyName = memberExpr.Member.Name;
                    this.RaisePropertyChanged(propertyName);
                }
            }
        }
        
    }
}