namespace Sample.Mvvm.App.Sl.ViewModel
{
    using System.Collections.Generic;
    using Sample.Mvvm.App.Sl.Commands;
    using Sample.Mvvm.App.Sl.Model;
    using Sample.Mvvm.App.Sl.Repositories;

    public class UserManagementViewModel : ViewModelBase
    {
        private IList<User> users;
        private User editedUser = new User();
        private readonly IUserRepository repository;
        private string message = string.Empty;

        public UserManagementViewModel()
        {
            this.repository = new FakeUserRepository();
        }

        protected override void InitializeCommands()
        {
            this.GetUsersCommand = new RelayCommand(x => this.Users = this.repository.GetAll());

            this.ValidateUserCommand = new RelayCommand(x =>
                                                            {
                                                                if (this.EditedUser.IsValid())
                                                                {
                                                                    this.SaveUserCommand.UpdateCanExecuteState();
                                                                    this.Message = "OK";
                                                                }
                                                                else
                                                                {
                                                                    this.Message = "Fill required fields!";
                                                                }
                                                            }
                );

            this.SaveUserCommand = new RelayCommand(x =>
                                                        {
                                                            this.repository.Save(this.EditedUser);
                                                            this.Message = string.Empty;
                                                            this.Users = this.repository.GetAll();
                                                            this.EditedUser = new User();
                                                        },
                                                    x => this.EditedUser.IsValid());

            this.DeleteUserCommand = new RelayCommand(x =>
                                                          {
                                                              this.repository.Delete(this.EditedUser);
                                                              this.Users = this.repository.GetAll();
                                                              this.EditedUser = new User();
                                                          });
        }

        public RelayCommand GetUsersCommand { get; set; }

        public RelayCommand ValidateUserCommand { get; set; }

        public RelayCommand SaveUserCommand { get; set; }

        public RelayCommand DeleteUserCommand { get; set; }

        public IList<User> Users
        {
            get
            {
                return this.users;
            }
            set
            {
                this.users = value;
                this.RaisePropertyChanged(() => this.Users);
            }
        }

        public User EditedUser
        {
            get
            {
                if (this.editedUser == null)
                {
                    this.editedUser = new User();
                }
                return this.editedUser;
            }
            set
            {
                this.editedUser = value;
                this.RaisePropertyChanged(() => this.EditedUser);
            }
        }

        public string Message
        {
            get
            {
                return this.message;
            }
            set
            {
                this.message = value;
                this.RaisePropertyChanged(() => this.Message);
            }
        }
    }
    
}