﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Pierwszy.Models;

namespace Pierwszy.Controllers
{    
    //Tworząc wybrałem MVC Controller, read/write actions and views using Entity Framework
    //model class: Książka, musi mieć ID (inaczej niedostępna)
    //data context class: KsiążkaContext

    //test: http://localhost:1277/Ksi%C4%85%C5%BCka

    public class KsiążkaController : Controller
    {
        private KsiążkaContext db = new KsiążkaContext();

        //
        // GET: /Książka/

        public ActionResult Index()
        {
            return View(db.Książki.ToList());
        }

        //
        // GET: /Książka/Details/5

        public ActionResult Details(int id = 0)
        {
            Książka książka = db.Książki.Find(id);
            if (książka == null)
            {
                return HttpNotFound();
            }
            return View(książka);
        }

        //
        // GET: /Książka/Create

        public ActionResult Create()
        {
            return View();
        }

        //
        // POST: /Książka/Create

        [HttpPost]
        public ActionResult Create(Książka książka)
        {
            if (ModelState.IsValid)
            {
                db.Książki.Add(książka);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            return View(książka);
        }

        //
        // GET: /Książka/Edit/5

        public ActionResult Edit(int id = 0)
        {
            Książka książka = db.Książki.Find(id);
            if (książka == null)
            {
                return HttpNotFound();
            }
            return View(książka);
        }

        //
        // POST: /Książka/Edit/5

        [HttpPost]
        public ActionResult Edit(Książka książka)
        {
            if (ModelState.IsValid)
            {
                db.Entry(książka).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(książka);
        }

        //
        // GET: /Książka/Delete/5

        public ActionResult Delete(int id = 0)
        {
            Książka książka = db.Książki.Find(id);
            if (książka == null)
            {
                return HttpNotFound();
            }
            return View(książka);
        }

        //
        // POST: /Książka/Delete/5

        [HttpPost, ActionName("Delete")]
        public ActionResult DeleteConfirmed(int id)
        {
            Książka książka = db.Książki.Find(id);
            db.Książki.Remove(książka);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            db.Dispose();
            base.Dispose(disposing);
        }
    }
}