﻿using GalaSoft.MvvmLight;
using GalaSoft.MvvmLight.Command;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using GalaSoft.MvvmLight.Messaging;
using projekt05.Messages;

namespace projekt05.ViewModel
{
    public class OptionsViewModel : ViewModelBase
    {
        #region Save Options Command
        private RelayCommand<int> _saveCommand;

        public RelayCommand<int> SaveOptions
        {
            get
            {
                if (_saveCommand == null)
                    _saveCommand = new RelayCommand<int>(
                        x =>
                        {
                            Messenger.Default.Send<ChangeOptionsMessage>(new ChangeOptionsMessage(x));
                        });

                return _saveCommand;
            }
        }
        #endregion
    }
}
