﻿using ModuleA.Models;
using System;
using System.Collections.Generic;

namespace ModuleA
{
    public class HardcodedProductRepository : IProductRepository
    {
        private List<Product> products = new List<Product>()
        {
            new Product(0, "Apple", 0.25m),
            new Product(1, "Orange", 0.33m),
            new Product(2, "Strawberry", 0.10m),
        };

        public void Add(Models.Product product)
        {
			product.Id = products.Count;
            products.Add(product);
        }

        public void Update(Models.Product product)
        {
            if (products != null)
                products[(int)product.Id] = product;
        }

        public IEnumerable<Models.Product> GetAll()
        {
            return products.ToArray();
        }
    }
}
