﻿using Microsoft.Practices.Prism.Commands;
using Microsoft.Practices.Prism.Regions;
using ModuleA.Models;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ModuleA.ViewModels
{
	public class EditorCatalogViewModel : CatalogViewModel
	{
		public DelegateCommand AddProductCommand { get; set; }
		public DelegateCommand<Product> UpdateProductCommand { get; set; }

		public EditorCatalogViewModel(IProductRepository productsRepository) : base(productsRepository)
		{
			AddProductCommand = new DelegateCommand(AddProduct);
			UpdateProductCommand = new DelegateCommand<Product>(UpdateProduct);
		}

		private void AddProduct()
		{
			var sampleProduct = new Product(0, "Name", 0.00m);
			base.productsRepository.Add(sampleProduct);
			base.Products.Add(sampleProduct);
		}

		private void UpdateProduct(Product product)
		{
			if(product != null)
				base.productsRepository.Update(product);
		}
	}
}
