﻿using System;

namespace LightsOut.Data
{
    public class PlayerScore : IComparable<PlayerScore>
    {
        #region Public properties
        public string PlayerName { get; set; }
        public int NumberOfMoves { get; set; }
        public long TimeSpanTicks { get; set; }
        #endregion

        #region Constructors
        public PlayerScore() { }

        public PlayerScore(string playerName, int numberOfMoves, long timeSpanTicks)
        {
            PlayerName = playerName;
            NumberOfMoves = numberOfMoves;
            TimeSpanTicks = timeSpanTicks;
        }
        #endregion

        #region Icomparable<PlayerScore> implementation
        public int CompareTo(PlayerScore other)
        {
            if (NumberOfMoves < other.NumberOfMoves)
                return -1;
            if (NumberOfMoves == other.NumberOfMoves)
            {
                if (TimeSpanTicks < other.TimeSpanTicks)
                    return -1;
                if (TimeSpanTicks > other.TimeSpanTicks)
                    return 1;
                return 0;
            }
            return 1;
        }
        #endregion

        #region Overrides
        public override string ToString()
        {
            return string.Format("{0} | {1} | {2}", PlayerName, NumberOfMoves, new TimeSpan(TimeSpanTicks));
        }
        #endregion
    }
}
