﻿using System;
using LightsOut.Events;

namespace LightsOut.Interfaces
{
    public interface ILightsOutGame
    {
        int RowCount { get; }
        int ColumnCount { get; }
        int LightsOnCount { get; }
        bool IsGameOver { get; }
        int MoveCount { get; }
        bool this[int row, int column] { get; set; }

        event EventHandler<GameEndedEventArgs> GameEnded;
        event EventHandler<LightSwitchedEventArgs> LightSwitched;

        /// <summary>
        /// Carry out player's action at the specified row and column coordinates
        /// </summary>
        /// <param name="row">Row coordinate</param>
        /// <param name="column">Column coordinate</param>
        void PlayerAction(int row, int column);

        /// <summary>
        /// Start a new game
        /// </summary>
        void NewGame();
    }
}