﻿using Windows.Storage;
using Windows.UI.Popups;
using MiniLightsOut.Common;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Navigation;

namespace MiniLightsOut
{
    public sealed partial class PageMainMenu : Page
    {
        private readonly NavigationHelper _navigationHelper;

        public NavigationHelper NavigationHelper
        {
            get { return this._navigationHelper; }
        }

        public PageMainMenu()
        {
            this.InitializeComponent();
            this._navigationHelper = new NavigationHelper(this);
            TextBoxName.Text = ApplicationData.Current.RoamingSettings.Values["lastPlayerName"] as string ?? string.Empty;
        }

        #region NavigationHelper registration
        protected override void OnNavigatedTo(NavigationEventArgs e)
        {
            _navigationHelper.OnNavigatedTo(e);
        }

        protected override void OnNavigatedFrom(NavigationEventArgs e)
        {
            _navigationHelper.OnNavigatedFrom(e);
        }

        #endregion

        #region Events
        private void ButtonStartGame_Clicked(object sender, RoutedEventArgs e)
        {
            if (TextBoxName.Text.Length < 3 || TextBoxName.Text.Length > 10)
            {
                const string message = "Imię musi mieć długość od 3 do 10 znaków!";
                new MessageDialog(message).ShowAsync();
                return;
            }

            var roamingSettings = ApplicationData.Current.RoamingSettings;
            roamingSettings.Values["lastPlayerName"] = TextBoxName.Text;
            this.Frame.Navigate(typeof(PageGame), TextBoxName.Text);
        }

        private void ButtonHighScores_Clicked(object sender, RoutedEventArgs e)
        {
            this.Frame.Navigate(typeof(PageHighScores));
        }
        #endregion
    }
}
