﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using SQLite.Net;
using DeliveryHelper.Model;
using SQLiteNetExtensions;
using SQLiteNetExtensions.Attributes;
using SQLiteNetExtensions.Extensions;

namespace DeliveryHelper
{
    public class DataSource
    {
        public SQLite.Net.SQLiteConnection sqliteConnection;

        public DataSource(SQLite.Net.SQLiteConnection connection)
        {
            this.sqliteConnection = connection;
        }

        public DataSource()
        {
            this.sqliteConnection = Database.SQLiteConnection;
        }


        public List<Delivery> GetDeliveries()
        {
            var List = this.sqliteConnection.GetAllWithChildren<Delivery>();
            return List;
        }

        public void InsertDelivery(object obj)
        {
            this.sqliteConnection.InsertWithChildren(obj);
        }

        public void Update(object obj)
        {
            this.sqliteConnection.UpdateWithChildren(obj);
        }

        public void UpdateCollection(System.Collections.IEnumerable objects)
        {
            foreach (var ob in objects)
            {
                this.sqliteConnection.UpdateWithChildren(ob);
            }
        }

        public void DeleteCollection(System.Collections.IEnumerable objects)
        {
                this.sqliteConnection.DeleteAll(objects);
        }

        public void Delete(object obj)
        {
            this.sqliteConnection.Delete(obj);
        }
    }
}
