﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;

using SQLite.Net;
using SQLite.Net.Attributes;
using SQLite.Net.Platform.WinRT;
using SQLiteNetExtensions;
using DeliveryHelper.Model;
using Windows.Storage;

namespace DeliveryHelper
{
    public class Database
    {
        private static string dbName = Path.Combine(ApplicationData.Current.LocalFolder.Path, "DeliveryHelper.db");

        private static Database instance = null;

        private static SQLiteConnection sqliteConnection;

        private Database()
        {
            //SQLitePlatformWinRT supports both desktop and phone
            sqliteConnection = new SQLite.Net.SQLiteConnection(new SQLitePlatformWinRT(), dbName);   
            CreateIfNotPresent();
        }

        public static Database Instance
        {
            get
            {
                if (instance == null)
                {
                    instance = new Database();
                }

                return instance;
            }
        }

        public static SQLite.Net.SQLiteConnection SQLiteConnection
        {
            get
            {
                if (instance == null)
                {
                    instance = new Database();
                }

                return sqliteConnection;
            }
        }

        private static void CreateIfNotPresent()
        {
            sqliteConnection.CreateTable<Delivery>();
        }        
    }
}
