﻿using System;
using System.Collections.Generic;
using System.Linq;
using SQLite;
using SQLiteNetExtensions.Attributes;
using SQLite.Net.Attributes;

namespace DeliveryHelper.Model
{
    public enum State { Active, Delayed, Completed };

    [Table("Deliveries")]
    public class Delivery
    {
        [PrimaryKey, AutoIncrement]
        public int IdDelivery { get; set; }

        public string Destination { get; set; }
        public string ContactInfo { get; set; }
        public string ContactNumber { get; set; }
        public DateTime Date { get; set; }
        public int Amount { get; set; }
        public string OrderNo { get; set; }

        public State State { get; set; }

        public double? Longtitude { get; set; }
        public double? Latitude { get; set; }

        [Ignore]
        public int DeliveryOrder { get; set; }

        [Ignore]
        public Windows.Devices.Geolocation.Geopoint Location { get; set; }

        [Ignore]
        public Windows.UI.Xaml.Controls.Grid Pin { get; set; }

        [Ignore]
        public string ContactInfoFormatted { get { return ContactInfo + ((ContactInfo != "" && ContactNumber != "") ? ", " : "") + ContactNumber; } }


        public override string ToString()
        {
            return Destination;
        }
    }
}
