﻿using System.Collections.Generic;
using System.Text;
using DeliveryHelper.Model;
using System.Collections.ObjectModel;
using Windows.UI.Xaml.Media;


namespace DeliveryHelper
{
    public class ListCount
    {        
        public string ListName { get; set; }
        public int Count { get; set; }
        public Brush ListColor { get; set; }
    }

    static class DataHelper
    {
        private static DataSource DS = new DataSource();

        public static ObservableCollection<Delivery> Active = new ObservableCollection<Delivery>();
        public static ObservableCollection<Delivery> Delayed = new ObservableCollection<Delivery>();
        public static ObservableCollection<Delivery> Completed = new ObservableCollection<Delivery>();

        public static ListCount ActiveListCount = new ListCount() { ListName = "Aktywne", ListColor = new SolidColorBrush(Windows.UI.Colors.DodgerBlue) };
        public static ListCount DelayedListCount = new ListCount() { ListName = "Odłożone", ListColor = new SolidColorBrush(Windows.UI.Colors.Green) };
        public static ListCount CompletedListCount = new ListCount() { ListName = "Wykonane", ListColor = new SolidColorBrush(Windows.UI.Colors.Black) };

        public static ObservableCollection<ListCount> ListCounts = new ObservableCollection<ListCount>();

        public static List<Delivery> AllDeliveries = new List<Delivery>();

        public static void LoadDeliveries()
        {
            AllDeliveries = DS.GetDeliveries();

            Active.Clear();
            Delayed.Clear();
            Completed.Clear();

            foreach (var D in AllDeliveries.FindAll(x => x.State == State.Active))
                Active.Add(D);

            foreach (var D in AllDeliveries.FindAll(x => x.State == State.Delayed))
                Delayed.Add(D);

            foreach (var D in AllDeliveries.FindAll(x => x.State == State.Completed))
                Completed.Add(D);
            
            CalculateListsCounts();
            
            foreach(var D in AllDeliveries)
            {
                if (D.ContactNumber == null)
                    D.ContactNumber = "";
            }
        }
               
        private static void CalculateListsCounts()
        {
            ActiveListCount.Count = Active.Count;
            DelayedListCount.Count = Delayed.Count;
            CompletedListCount.Count = Completed.Count;

            ListCounts.Clear();
            ListCounts.Add(ActiveListCount);
            ListCounts.Add(DelayedListCount);
            ListCounts.Add(CompletedListCount);
        }

        public static void CompletedDelivery(Delivery Delivery)
        {
            switch (Delivery.State)
            {
                case State.Active:
                    Delivery.State = State.Completed;
                    DataHelper.Active.Remove(Delivery);
                    DataHelper.Completed.Add(Delivery);
                    DataHelper.UpdateDatabase(Delivery);
                    break;

                case State.Delayed:
                    Delivery.State = State.Completed;
                    DataHelper.Delayed.Remove(Delivery);
                    DataHelper.Completed.Add(Delivery);
                    DataHelper.UpdateDatabase(Delivery);
                    break;

                case State.Completed:
                    break;
                default:
                    break;
            }
            CalculateListsCounts();
            DeliveryMapHelper.Instance.SetPins();
        }

        public static void DelayDelivery(Delivery Delivery)
        {
            switch (Delivery.State)
            {
                case State.Active:
                    Delivery.State = State.Delayed;
                    DataHelper.Delayed.Add(Delivery);
                    DataHelper.Active.Remove(Delivery);
                    DataHelper.UpdateDatabase(Delivery);
                    break;

                default:
                    break;
            }
            CalculateListsCounts();
            DeliveryMapHelper.Instance.SetPins();
        }

        public static void RestoreDelivery(Delivery Delivery)
        {
            switch (Delivery.State)
            {
                case State.Delayed:
                    Delivery.State = State.Active;
                    DataHelper.Active.Add(Delivery);
                    DataHelper.Delayed.Remove(Delivery);
                    DataHelper.UpdateDatabase(Delivery);
                    break;

                case State.Completed:
                    Delivery.State = State.Active;
                    DataHelper.Active.Add(Delivery);
                    DataHelper.Completed.Remove(Delivery);
                    DataHelper.UpdateDatabase(Delivery);
                    break;

                default:
                    break;
            }
            CalculateListsCounts();
            DeliveryMapHelper.Instance.SetPins();
        }


        public static void UpdateDatabase(object Obj)
        {
            DS.Update(Obj);
        }

        public static void AddNewDelivery(Delivery Del)
        {
            DS.InsertDelivery(Del);
            LoadDeliveries();
        }

        public static void DeleteDeliveriesCollection(List<Delivery> L)
        {
            DS.DeleteCollection(L);
            LoadDeliveries();
        }

        public static void DeleteDelivery(Delivery Del)
        {
            switch (Del.State)
            {
                case State.Active:
                    Active.Remove(Del);
                    break;
                case State.Delayed:
                    Delayed.Remove(Del);
                    break;
                case State.Completed:
                    Completed.Remove(Del);
                    break;
            }

            DS.Delete(Del);           
        }

    }
}
