﻿using System;
using System.Collections.Generic;
using System.Text;
using Windows.UI.Xaml.Controls;
using Windows.Devices.Geolocation;
using System.Threading.Tasks;
using Windows.UI.Core;
using Graf;
using DeliveryHelper.Model;
using Windows.Devices.Geolocation.Geofencing;
using Windows.UI.Xaml;
using Windows.ApplicationModel.Background;

namespace DeliveryHelper
{
    public class DistanceData
    {
        public int A, B;
        public double Distance;

        public string ToString()
        {
            return A + " -> " + B + ": " + Distance;
        }
    }

    class DeliveryMapHelper
    {
        public Grid CurrentPositionPushpin = null;
        public Geopoint CurrentPosition = null;

        public bool DisplayCompleted = true;

        public UniversalMap _map;
        public UniversalMap Map
        {
            get
            { return _map; }
            set
            {
                _map = value;                
                //GeolocationHelper._geolocator.MovementThreshold = 3;
                GeolocationHelper._geolocator.ReportInterval = 2000;
                GeolocationHelper._geolocator.PositionChanged += this.OnPositionChanged;
                var x = GeolocationHelper._geolocator.LocationStatus;
                
                GetAndSetCurrentPositionPin();
                SetPins(true);
            }
        }

        #region GeoFencing
        public TextBox GeofenceInfo;
        public Windows.Devices.Geolocation.Geofencing.Geofence geofence;
        public async Task RegisterFence()
        {
            GeolocationHelper.GetPosition();

            Geopoint Pos;
            if(CurrentPosition != null)
                Pos = CurrentPosition;
            else
            Pos = await GeolocationHelper.GetPosition();
            
            Geocircle Cir = new Geocircle(Pos.Position, 30);
            MonitoredGeofenceStates GeoFenceStates = MonitoredGeofenceStates.Entered;
            GeoFenceStates |= MonitoredGeofenceStates.Exited;
            TimeSpan dwellTime;
            dwellTime = TimeSpan.FromSeconds(1);
            DateTimeOffset GeoFenceStartTime = DateTimeOffset.Now;

            geofence = new Geofence("geofence", Cir, GeoFenceStates, false, dwellTime, GeoFenceStartTime, TimeSpan.FromDays(1));
            GeofenceMonitor.Current.Geofences.Clear();
            GeofenceMonitor.Current.Geofences.Add(geofence);
            GeofenceMonitor.Current.GeofenceStateChanged += Current_GeofenceStateChanged;

        }

        public static string GFString = "";
        private async void Current_GeofenceStateChanged(GeofenceMonitor sender, object args)
        {
            var Reports = sender.ReadReports();

            if (Reports.Count == 0)
                GFString = "0-" + GFString;
            else
                GFString = "" + Reports.Count;

            List<GeofenceStateChangeReport> ReportsList = new List<GeofenceStateChangeReport>();
            foreach (var R in Reports)
            {
                ReportsList.Add(R);
                GFString += R.NewState + ", ";
            }

            int g = 0;

            Windows.ApplicationModel.Core.CoreApplication.MainView.CoreWindow.Dispatcher.RunAsync(CoreDispatcherPriority.Normal,
                () =>
                {
                    GeofenceInfo.Text = GFString;
                });
        }

        //private async void RegisterBackgroundTask(object sender, RoutedEventArgs e)
        //{
        //    BackgroundAccessStatus accessStatus =
        //      await BackgroundExecutionManager.RequestAccessAsync();
        //    if (accessStatus ==
        //      BackgroundAccessStatus.AllowedMayUseActiveRealTimeConnectivity ||
        //     accessStatus ==
        //       BackgroundAccessStatus.AllowedWithAlwaysOnRealTimeConnectivity)
        //    {
        //        BackgroundTaskBuilder taskBuilder = new BackgroundTaskBuilder();
        //        taskBuilder.Name = "MyGeoBackground";
        //        taskBuilder.TaskEntryPoint =
        //          "WindowsRuntimeComponent1.MyBackgroundTask";
        //        LocationTrigger trigger = new LocationTrigger(LocationTriggerType.Geofence);
        //        taskBuilder.SetTrigger(trigger);
        //        taskBuilder.Register();
        //    }
        //}
        #endregion GeoFencing

#if WINDOWS_APP
        public Bing.Maps.Directions.Route FirstSegment;
        public Bing.Maps.Directions.Route RestSegment;
#endif
        public List<DistanceData> Distances = new List<DistanceData>();


        private static DeliveryMapHelper instance = null;
        public static DeliveryMapHelper Instance
        {
            get
            {
                if (instance == null)
                {
                    instance = new DeliveryMapHelper();
                }

                return instance;
            }
        }

        private DeliveryMapHelper()
        { }

        public async Task GetLocations(bool all = false)
        {
            foreach (var Delivery in DataHelper.Active)
            {
                if (Delivery.Location == null)
                {
                    if (Delivery.Longtitude != null && Delivery.Longtitude != null)
                    {
                        Delivery.Location = new Windows.Devices.Geolocation.Geopoint(
                            new Windows.Devices.Geolocation.BasicGeoposition() { Longitude = (double)Delivery.Longtitude, Latitude = (double)Delivery.Latitude });
                    }
                    else
                    {
                        //Geopoint Point = await Map.GetByAddress(Delivery.Destination);
                        var Point = await Map.GetByAddress(Delivery.Destination);

                        Delivery.Latitude = Point.Position.Latitude;
                        Delivery.Longtitude = Point.Position.Longitude;
                        DataHelper.UpdateDatabase(Delivery);

                        Delivery.Location = Point;
                    }
                }
            }
            foreach (var Delivery in DataHelper.Delayed)
            {
                if (Delivery.Location == null)
                {
                    if (Delivery.Longtitude != null && Delivery.Longtitude != null)
                    {
                        Delivery.Location = new Windows.Devices.Geolocation.Geopoint(
                            new Windows.Devices.Geolocation.BasicGeoposition() { Longitude = (double)Delivery.Longtitude, Latitude = (double)Delivery.Latitude });
                    }
                    else
                    {
                        //Geopoint Point = await Map.GetByAddress(Delivery.Destination);
                        var Point = await Map.GetByAddress(Delivery.Destination);

                        Delivery.Latitude = Point.Position.Latitude;
                        Delivery.Longtitude = Point.Position.Longitude;
                        DataHelper.UpdateDatabase(Delivery);

                        Delivery.Location = Point;
                    }
                }
            }

            if (all)
            {
                foreach (var Delivery in DataHelper.Completed)
                {
                    if (Delivery.Location == null)
                    {
                        if (Delivery.Longtitude != null && Delivery.Longtitude != null)
                        {
                            Delivery.Location = new Windows.Devices.Geolocation.Geopoint(
                                new Windows.Devices.Geolocation.BasicGeoposition() { Longitude = (double)Delivery.Longtitude, Latitude = (double)Delivery.Latitude });
                        }
                        else
                        {
                            //Geopoint Point = await Map.GetByAddress(Delivery.Destination);
                            var Point = await Map.GetByAddress(Delivery.Destination);

                            Delivery.Latitude = Point.Position.Latitude;
                            Delivery.Longtitude = Point.Position.Longitude;
                            DataHelper.UpdateDatabase(Delivery);

                            Delivery.Location = Point;
                        }
                    }
                }

            }

        }

        public async Task SetPins(bool setView = false)
        {
            await GetLocations(DisplayCompleted);

            foreach (var Delivery in DataHelper.AllDeliveries)
            {
                if (Delivery.Pin != null)
                {
                    Map.RemovePin(Delivery.Pin);
                    Delivery.Pin = null;
                }
            }

            int iActive = 0;
            foreach (var Delivery in DataHelper.Active)
            {
                if (Delivery.Location != null)
                {
                    var Pin = Map.AddPushpin(Delivery.Location, (iActive + 1).ToString());
                    Delivery.Pin = Pin;
                }
                iActive++;
            }


            int iDelayed = 0;
            foreach (var Delivery in DataHelper.Delayed)
            {
                if (Delivery.Location != null)
                {
                    var Pin = Map.AddPushpin(Delivery.Location, (iDelayed + 1).ToString(), UniversalMap.PinColor.Green);
                    Delivery.Pin = Pin;
                }
                iDelayed++;
            }


            if (DisplayCompleted)
            {
                int iCompleted = 0;
                foreach (var Delivery in DataHelper.Completed)
                {
                    if (Delivery.Location != null)
                    {
                        var Pin = Map.AddPushpin(Delivery.Location, (iCompleted + 1).ToString(), UniversalMap.PinColor.Black);
                        Delivery.Pin = Pin;
                    }
                    iCompleted++;
                }
            }

            if (setView)
                SetViewAll();

            return;
        }

        public async void SetViewAll()
        {
            List<Geopoint> List = new List<Geopoint>();
            foreach (var Delivery in DataHelper.Active)
            {
                if (Delivery.Pin != null && Delivery.Location != null)
                {
                    List.Add(Delivery.Location);
                }
            }

            foreach (var Delivery in DataHelper.Delayed)
            {
                if (Delivery.Pin != null && Delivery.Location != null)
                {
                    List.Add(Delivery.Location);
                }
            }

            if (DisplayCompleted)
            {
                foreach (var Delivery in DataHelper.Completed)
                {
                    if (Delivery.Pin != null && Delivery.Location != null)
                    {
                        List.Add(Delivery.Location);
                    }
                }
            }

            //TODO uncomment
            //var CurrentPosition = await GeolocationHelper.GetPosition();
            if (CurrentPosition != null)
                List.Add(CurrentPosition);

            if (List.Count <= 0)
                return;

            Map.SetViewAll(List);
        }

        public void OnPositionChanged(Geolocator G, PositionChangedEventArgs Args)
        {
            bool isFirstTme = CurrentPosition == null;

            var x = Args.Position.Coordinate.PositionSource;
            
            Windows.ApplicationModel.Core.CoreApplication.MainView.CoreWindow.Dispatcher.RunAsync(CoreDispatcherPriority.Normal,
                () =>
                {
                    Geoposition GPos = Args.Position;
                    Geopoint Point = GPos.Coordinate.Point;

                    CurrentPosition = Point;

                    UpdateCurrentPositionPin(Point, isFirstTme);                    
                });
        }

        public void UpdateCurrentPositionPin(Geopoint Point, bool setV = true)
        {
            var Pin = Map.AddPushpin(Point, "-", DeliveryHelper.UniversalMap.PinColor.Red);
            if (CurrentPositionPushpin != null)
            {
                Map.RemovePin(CurrentPositionPushpin);
            }
            CurrentPositionPushpin = Pin;

            if(setV)
                SetViewAll();
        }

        public async void GetAndSetCurrentPositionPin()
        {
            var Point = await GeolocationHelper.GetPosition();
            CurrentPosition = Point;
            UpdateCurrentPositionPin(Point);
        }

        public async Task GetDistances()
        {
            await GetLocations();

            Distances.Clear();

            foreach (var Del1 in DataHelper.Active)
            {
                foreach (var Del2 in DataHelper.Active)
                {
                    if (Del1.IdDelivery != Del2.IdDelivery && Del1.Location != null && Del2.Location != null)
                    {
                        Distances.Add(new DistanceData()
                        {
                            A = Del1.IdDelivery,
                            B = Del2.IdDelivery,
                            Distance = MiscTools.DistanceBetweenPlaces(Del1.Location.Position.Longitude, Del1.Location.Position.Latitude,
                                                                       Del2.Location.Position.Longitude, Del2.Location.Position.Latitude)
                        });
                    }
                }

                if (CurrentPosition == null)
                    GetAndSetCurrentPositionPin();



                var DistToCurrent = MiscTools.DistanceBetweenPlaces(Del1.Location.Position.Longitude, Del1.Location.Position.Latitude,
                                                                    CurrentPosition.Position.Longitude, CurrentPosition.Position.Latitude);

                Distances.Add(new DistanceData()
                {
                    A = -1,
                    B = Del1.IdDelivery,
                    Distance = DistToCurrent
                });

                Distances.Add(new DistanceData()
                {
                    A = Del1.IdDelivery,
                    B = -1,
                    Distance = DistToCurrent
                });
            }

        }

        public async void SetShortestRouteOrder()
        {
            if (CurrentPosition == null)
                await GeolocationHelper.GetPosition();

            await GetDistances();

            Graf<int> graf = new Graf<int>();

            // Current Position
            graf.DodajWierzcholek(-1);

            foreach (var Delivery in DataHelper.Active)
            {
                graf.DodajWierzcholek(Delivery.IdDelivery);
            }

            foreach (var Dist in Distances)
            {
                graf.DodajKrawedz(graf.ZnajdzWierzcholek(Dist.A), graf.ZnajdzWierzcholek(Dist.B),
                    false, true, (int)(Dist.Distance * 1000));
            }

            List<Krawedz<int>> Route = graf.Komiwojazer();

            List<int> Points = new List<int>();

            if (Route.Count > 0)
            {
                int Current = -1;

                do
                {
                    Points.Add(Current);
                    Krawedz<int> Segment = Route.Find(x => x.poczatek.wartosc == Current);
                    Current = Segment.koniec.wartosc;
                } while (Current != -1);
            }

            System.Collections.Generic.List<Delivery> ActiveList = new List<Delivery>(DataHelper.Active);

            for (int i = 0; i < Points.Count; i++)
            {
                if (Points[i] != -1)
                {
                    ActiveList.Find(x => x.IdDelivery == Points[i]).DeliveryOrder = i;
                }
            }

            DataHelper.Active.Sort(x => x.DeliveryOrder);

            await SetPins();

            List<Geopoint> RoutePoints = new List<Geopoint>();

            //var CurrentPosition = await GeolocationHelper.GetPosition();
            RoutePoints.Add(CurrentPosition);

            foreach (var Del in DataHelper.Active)
            {
                RoutePoints.Add(Del.Location);
            }
            RoutePoints.Add(CurrentPosition);

            await _map.AddRoute(RoutePoints, true);
        }
    }
}
