﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Graf;

namespace Graf
{
    public class KomiwojazerMLB<T>
    {
        public int[,] M;
        public int LowerBound;
        int LP;

        public List<Krawedz<T>> Zawarte;
        public List<Krawedz<T>> Odrzucone;

        public Graf<T> Gr;

        public List<int> wiersze;
        public List<int> kolumny;

        public KomiwojazerMLB(int [,] Mat, Graf<T> G)
        {
            LP = 0;

            M = (int [,])Mat.Clone();
            
            wiersze = new List<int>();
            kolumny = new List<int>();

            for (int i = 0; i < M.GetLength(0); i++ )
            {
                wiersze.Add(i);
            }


            for (int i = 0; i < M.GetLength(1); i++)
            {
                kolumny.Add(i);
            }


            LowerBound = 0;
            Zawarte = new List<Krawedz<T>>();
            Odrzucone = new List<Krawedz<T>>();

            Gr = G;
            
        }

        public KomiwojazerMLB(KomiwojazerMLB<T> K, Graf<T> G)
        {
            LP = K.LP + 1;

            M = (int[,])K.M.Clone();

            wiersze = new List<int>(K.wiersze);
            kolumny = new List<int>(K.kolumny);

            LowerBound = K.LowerBound;

            Zawarte = new List<Krawedz<T>>(K.Zawarte);
            Odrzucone = new List<Krawedz<T>>(K.Odrzucone);

            Gr = G;
        }

        public void redukuj()
        {
            // usuniecie potencjalnych cykli
            if (M.Length > 4)
            {
                foreach (Krawedz<T> StartK in Zawarte)
                {
                    Wierzcholek<T> Start = StartK.poczatek;

                    Wierzcholek<T> cur = StartK.koniec;


                    int tmp = Zawarte.FindIndex(kr => kr.poczatek == cur);

                    while(tmp >= 0)
                    {
                        cur = Zawarte.ElementAt(tmp).koniec;
                        tmp = Zawarte.FindIndex(kr => kr.poczatek == cur);
                    }

                    int i1 = Gr.V1.FindIndex(W => W == cur);
                    int i2 = Gr.V1.FindIndex(W => W == Start);

                    int wrs = wiersze.FindIndex(w => w == i1);
                    int klm = kolumny.FindIndex(k => k == i2);

                    if (wrs >= 0 && klm >= 0)
                    {
                        M[wrs, klm] = -1;
                    }
                    
                }

            }

            LowerBound += Graf<T>.ZerujWiersze(this.M);
            LowerBound += Graf<T>.ZerujKolumny(this.M);  
        }


    }
}
