﻿using System;
using System.Collections.Generic;
using System.Reflection;
using System.IO;
using System.Runtime.Serialization;
using System.Collections.ObjectModel;
using DeliveryHelper.Model;
using System.Linq;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Controls;

public static class MiscTools
{
     public static double DistanceBetweenPlaces(double lon1, double lat1, double lon2, double lat2)
    {
        double R = 6371; // km

        double sLat1 = Math.Sin(Radians(lat1));
        double sLat2 = Math.Sin(Radians(lat2));
        double cLat1 = Math.Cos(Radians(lat1));
        double cLat2 = Math.Cos(Radians(lat2));
        double cLon = Math.Cos(Radians(lon1) - Radians(lon2));

        double cosD = sLat1 * sLat2 + cLat1 * cLat2 * cLon;

        double d = Math.Acos(cosD);

        double dist = R * d;

        return dist;
    }

    public static double Radians(double deg)
    {
        return 0.0174532925 * deg;
    }
}

// rozserzenie observablecollection o sort
public static class ObservableCollection
{
    public static void Sort<TSource, TKey>(this ObservableCollection<TSource> source, Func<TSource, TKey> keySelector)
    {
        List<TSource> sortedList = source.OrderBy(keySelector).ToList();
        source.Clear();
        foreach (var sortedItem in sortedList)
        {
            source.Add(sortedItem);
        }
    }
}
