﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Runtime.InteropServices.WindowsRuntime;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;
using DeliveryHelper.Common;
using DeliveryHelper.Model;
using Windows.Devices.Geolocation;
using Bing.Maps;
using WinRTXamlToolkit.Controls.DataVisualization.Charting;
using System.Collections.ObjectModel;
using Windows.UI.Xaml.Shapes;

// The Universal Hub Application project template is documented at http://go.microsoft.com/fwlink/?LinkID=391955

namespace DeliveryHelper
{
    /// <summary>
    /// A page that displays a grouped collection of items.
    /// </summary>
    public sealed partial class HubPage : Page
    {
        private NavigationHelper navigationHelper;
        private ObservableDictionary defaultViewModel = new ObservableDictionary();

        /// <summary>
        /// Gets the NavigationHelper used to aid in navigation and process lifetime management.
        /// </summary>
        public NavigationHelper NavigationHelper
        {
            get { return this.navigationHelper; }
        }

        /// <summary>
        /// Gets the DefaultViewModel. This can be changed to a strongly typed view model.
        /// </summary>
        public ObservableDictionary DefaultViewModel
        {
            get { return this.defaultViewModel; }
        }

        public HubPage()
        {
            this.InitializeComponent();
            this.navigationHelper = new NavigationHelper(this);
            this.navigationHelper.LoadState += this.NavigationHelper_LoadState;
        }

        /// <summary>
        /// Populates the page with content passed during Wgation.  Any saved state is also
        /// provided when recreating a page from a prior session.
        /// </summary>
        /// <param name="sender">
        /// The source of the event; typically <see cref="NavigationHelper"/>
        /// </param>
        /// <param name="e">Event data that provides both the navigation parameter passed to
        /// <see cref="Frame.Navigate(Type, object)"/> when this page was initially requested and
        /// a dictionary of state preserved by this page during an earlier
        /// session.  The state will be null the first time a page is visited.</param>
        private async void NavigationHelper_LoadState(object sender, LoadStateEventArgs e)
        {
            this.DefaultViewModel["DeliveriesActive"] = DataHelper.Active;
            this.DefaultViewModel["DeliveriesDelayed"] = DataHelper.Delayed;
            this.DefaultViewModel["DeliveriesCompleted"] = DataHelper.Completed;
            this.defaultViewModel["ListsCounts"] = DataHelper.ListCounts;

            List<ObservableCollection<Delivery>> DelsList1 = new List<ObservableCollection<Delivery>>();
            DelsList1.Add(DataHelper.Active);


            List<ObservableCollection<Delivery>> DelsList2 = new List<ObservableCollection<Delivery>>();
            DelsList2.Add(DataHelper.Delayed);

            List<ObservableCollection<Delivery>> DelsList3 = new List<ObservableCollection<Delivery>>();
            DelsList3.Add(DataHelper.Completed);
        
            Chart.Name = "Zlecenia";            
        }

        /// <summary>
        /// Invoked when a HubSection header is clicked.
        /// </summary>
        /// <param name="sender">The Hub that contains the HubSection whose header was clicked.</param>
        /// <param name="e">Event data that describes how the click was initiated.</param>

        void DeliveryClick(object sender, ItemClickEventArgs e)
        {
            Delivery ClickedDelivery = e.ClickedItem as Delivery;
        }


        /// <summary>
        /// Invoked when an item within a section is clicked.
        /// </summary>
        /// <param name="sender">The GridView or ListView
        /// displaying the item clicked.</param>
        /// <param name="e">Event data that describes the item clicked.</param>
        void ItemView_ItemClick(object sender, ItemClickEventArgs e)
        {        
        }
        #region NavigationHelper registration

        /// <summary>
        /// The methods provided in this section are simply used to allow
        /// NavigationHelper to respond to the page's navigation methods.
        /// Page specific logic should be placed in event handlers for the  
        /// <see cref="Common.NavigationHelper.LoadState"/>
        /// and <see cref="Common.NavigationHelper.SaveState"/>.
        /// The navigation parameter is available in the LoadState method 
        /// in addition to page state preserved during an earlier session.
        /// </summary>
        protected override void OnNavigatedTo(NavigationEventArgs e)
        {
            this.navigationHelper.OnNavigatedTo(e);
        }

        protected override void OnNavigatedFrom(NavigationEventArgs e)
        {
            this.navigationHelper.OnNavigatedFrom(e);
        }

        #endregion

        private void CompletedButton_Click(object sender, RoutedEventArgs e)
        {
            var element = sender as FrameworkElement;
            var Delivery = element.DataContext as Delivery;

            ClearCharts();
            DataHelper.CompletedDelivery(Delivery);
            //RefreshCharts();
        }

        private void DelayButton_Click(object sender, RoutedEventArgs e)
        {
            var element = sender as FrameworkElement;
            var Delivery = element.DataContext as Delivery;

            ClearCharts();
            DataHelper.DelayDelivery(Delivery);
            //RefreshCharts();
        }

        private void RestoreButton_Click(object sender, RoutedEventArgs e)
        {
            var element = sender as FrameworkElement;
            var Delivery = element.DataContext as Delivery;

            ClearCharts();
            DataHelper.RestoreDelivery(Delivery);
            //RefreshCharts();
        }

        private void ClearCharts()
        {
            return;
            (Chart.Series[0] as PieSeries).ItemsSource = null;
        }

        private void RefreshCharts()
        {
            //return;
            //(Chart.Series[0] as PieSeries).ItemsSource = DataHelper.ListCounts;

            //(PieChart.Series[0] as PieSeries).ItemsSource = null;
            //(PieChart.Series[0] as PieSeries).ItemsSource = DataHelper.ListCounts;
        }

        private async void PrzeliczButton_Click(object sender, RoutedEventArgs e)
        {
            DeliveryMapHelper.Instance.SetShortestRouteOrder();
        } 

        private async void DodajButton_Clicked(object sender, RoutedEventArgs e)
        {
            Delivery Del = new Delivery();
            Del.Destination = AddDestination.Text;
            Del.ContactInfo = AddContactInfo.Text;
            Del.ContactNumber = AddContactNumber.Text;
            Del.Date = DateTime.Now;
            Del.OrderNo = AddOrderNo.Text;

            DataHelper.AddNewDelivery(Del);
        }

        private void Map_Loaded(object sender, RoutedEventArgs e)
        {
            UniversalMap Map = sender as UniversalMap;
            DeliveryMapHelper.Instance.Map = Map;
            Map.Register("ArcyxmcG4wP7JXZFogqqwN0YQx9yt32fHB9_tac5br_bgs-16ofI1EtF88Et7B7r");
        }

        private void GFenceText_Loaded(object sender, RoutedEventArgs e)
        {
            TextBox TB = sender as TextBox;
            DeliveryMapHelper.Instance.GeofenceInfo = TB;
            TB.Text = "Loaded";
        }

        private void ColumnSeries_Loaded(object sender, RoutedEventArgs e)
        {
            LinearAxis LAxis = (Chart.ActualAxes[1] as LinearAxis);

            if (LAxis == null)
                LAxis = (Chart.ActualAxes[0] as LinearAxis);

            if (LAxis != null)
            {
                LAxis.Interval = 1.0;
                LAxis.Minimum = 0.0;
                LAxis.ShowGridLines = true;
                //var Setters = LAxis.GridLineStyle.Setters;
                //Setters.Add(new Setter(Line.StrokeProperty, "Black"));
                //Setters.Add(new Setter(Line.StrokeThicknessProperty, 1));
                //Setters.Add(new Setter(Line.OpacityProperty, 0.4));
                //Setters.Add(new Setter(Line.StrokeDashArrayProperty, "6,4"));
            }
        }

        private void RemoveButton_DoubleTapped(object sender, DoubleTappedRoutedEventArgs e)
        {
            var element = sender as FrameworkElement;
            var Delivery = element.DataContext as Delivery;

            DataHelper.DeleteDelivery(Delivery);
        }
    }
}
