﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
//using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Kolory
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            trackBar1_ValueChanged(this, null);
        }

        private void trackBar1_ValueChanged(object sender, EventArgs e)
        {
            panel1.BackColor = Color.FromArgb(trackBar1.Value, trackBar2.Value, trackBar3.Value);
            textBox1.Text =
                "#" +
                ((trackBar1.Value < 10) ? "0" : "") + trackBar1.Value.ToString("X") +
                ((trackBar2.Value < 10) ? "0" : "") + trackBar2.Value.ToString("X") +
                ((trackBar3.Value < 10) ? "0" : "") + trackBar3.Value.ToString("X");
            progressBar1.Value = (trackBar1.Value + trackBar2.Value + trackBar3.Value) / 3;
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            DialogResult dr = MessageBox.Show(
                "Czy jesteś pewien?",
                "Zamykanie",
                MessageBoxButtons.YesNo,
                MessageBoxIcon.Question,
                MessageBoxDefaultButton.Button2);

            switch (dr)
            {
                case DialogResult.Yes:
                    //e.CloseReason = CloseReason.UserClosing;
                    break;
                case DialogResult.No:
                    e.Cancel = true;
                    break;
                default:
                    throw new Exception("Nie rozpoznana ewentualność");
            }
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            Properties.Settings.Default.R = trackBar1.Value;
            Properties.Settings.Default.G = trackBar2.Value;
            Properties.Settings.Default.B = trackBar3.Value;
            Properties.Settings.Default.Save();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            trackBar1.Value = Properties.Settings.Default.R;
            trackBar2.Value = Properties.Settings.Default.G;
            trackBar3.Value = Properties.Settings.Default.B;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            Clipboard.SetText(textBox1.Text);
        }
    }
}
