﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace pl.umk
{
    public struct Ulamek
    {
        private int licznik, mianownik;

        //w domu: zastapic pole licznik i wlasnosc Licznik przez auto-implemented property

        public int Licznik
        {
            get
            {
                return licznik;
            }
            set
            {
                licznik = value;
            }
        }

        public int Mianownik
        {
            get
            {
                return mianownik;
            }
            set
            {
                if (value == 0) throw new ArgumentException("Mianownik nie może być równy zeru");
                mianownik = value;
            }
        }

        public Ulamek(int licznik, int mianownik)
        {
            this.licznik = licznik;
            this.mianownik = mianownik;
            if (mianownik == 0) throw new ArgumentException("Mianownik nie może być równy zeru"); //DRY!!
            //Licznik = licznik;
            //Mianownik = mianownik;
        }

        public override string ToString()
        {
            return licznik.ToString() + "/" + mianownik.ToString();
        }

        public Ulamek Odwrotnosc()
        {
            return new Ulamek(this.Mianownik, this.Licznik);
        }

        public static Ulamek Odwrotnosc(Ulamek u)
        {
            return u.Odwrotnosc();
        }

        public static Ulamek operator *(Ulamek u1, Ulamek u2)
        {
            return new Ulamek(u1.Licznik * u2.Licznik, u1.Mianownik * u2.Mianownik);
        }

        public static Ulamek operator /(Ulamek u1, Ulamek u2)
        {
            return u1 * u2.Odwrotnosc();
        }

        public static Ulamek operator +(Ulamek u1, Ulamek u2)
        {
            return new Ulamek(u1.Licznik * u2.Mianownik + u2.Licznik * u1.Mianownik,u1.Mianownik*u2.Mianownik);
        }

        public static Ulamek operator -(Ulamek u)
        {
            return new Ulamek(-u.Licznik, u.Mianownik);
        }

        public static Ulamek operator -(Ulamek u1, Ulamek u2)
        {
            return new Ulamek(u1.Licznik * u2.Mianownik - u2.Licznik * u1.Mianownik, u1.Mianownik * u2.Mianownik);
        }

        public double ToDouble()
        {
            return this.Licznik / (double)this.Mianownik;
        }

        public static explicit operator double(Ulamek u)
        {
            return u.ToDouble();
        }        

        public void Uprosc()
        {
			//NWD
			int mniejsza=(Math.Abs(licznik)<Math.Abs(mianownik))
						 ?Math.Abs(licznik):Math.Abs(mianownik);
			for(int i=mniejsza;i>0;i--)
				if ((licznik%i==0) && (mianownik%i==0))
				{
					licznik/=i;
					mianownik/=i;
				}
			//znaki
			if (licznik*mianownik<0)
			{
				licznik=-Math.Abs(licznik);
				mianownik=Math.Abs(mianownik);
			}
			else
			{
				licznik=Math.Abs(licznik);
				mianownik=Math.Abs(mianownik);
			}
        }
    }
}
