﻿using pl.umk;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace Ulamek_TestyJednostkowe
{
    /// <summary>
    ///This is a test class for UlamekTest and is intended
    ///to contain all UlamekTest Unit Tests
    ///</summary>
    [TestClass()]
    public class UlamekTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes
        // 
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //Use ClassCleanup to run code after all tests in a class have run
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //Use TestInitialize to run code before running each test
        //[TestInitialize()]
        //public void MyTestInitialize()
        //{
        //}
        //
        //Use TestCleanup to run code after each test has run
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        ///A test for ToDouble
        ///</summary>
        [TestMethod()]
        public void ToDoubleTest()
        {
            Ulamek target = new Ulamek(1,2);
            double expected = 0.5;
            double actual;
            actual = target.ToDouble();
            Assert.AreEqual(expected, actual);

            target = new Ulamek(1, 3);
            expected = 0.33;
            actual = target.ToDouble();
            Assert.AreNotEqual(expected, actual);

            target = new Ulamek(1, 3);
            expected = 0.333333333333333333333333333333333333333333;
            actual = target.ToDouble();
            Assert.AreEqual(expected, actual);
        }

        /// <summary>
        ///A test for op_Addition
        ///</summary>
        [TestMethod()]
        public void op_AdditionTest()
        {
            Ulamek u1 = new Ulamek(1,2);
            Ulamek u2 = new Ulamek(1,3);
            Ulamek expected = new Ulamek(5,6);
            Ulamek actual;
            actual = u1 + u2;
            actual.Uprosc();
            Assert.AreEqual(expected, actual);
        }

        /// <summary>
        ///A test for Uprosc
        ///</summary>
        [TestMethod()]
        public void UproscTest()
        {
            Ulamek expected = new Ulamek(-1,2);
            Ulamek actual = new Ulamek(6,-12);
            actual.Uprosc();
            Assert.AreEqual(expected, actual);
        }
    }
}
