﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Para_AplikacjaTestowa
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            Para<int> p1 = new Para<int>() { Pierwszy = 1, Drugi = 3 };
            //Para<Button> p2 = new Para<Button>() { Pierwszy = new Button(), Drugi = new Button() };
            Para<double> p3 = new Para<double>() { Pierwszy = 0.1, Drugi = 3.0 };

            Para<int>[] tpi = new Para<int>[10];
            Random r=new Random();
            for (int i = 0; i < tpi.Length; ++i)
            {
                tpi[i] = new Para<int> { Pierwszy = r.Next(100), Drugi = r.Next(100) };
            }
            string s = "Pary (przed sortowaniem):\n";
            foreach (Para<int> p in tpi)
            {
                s += p.Pierwszy.ToString() + ", " + p.Drugi.ToString() + "\n";
            }
            MessageBox.Show(s);
            
            Array.Sort(tpi);

            s = "Pary (po sortowaniu):\n";
            foreach (Para<int> p in tpi)
            {
                s += p.Pierwszy.ToString() + ", " + p.Drugi.ToString() + "\n";
            }
            MessageBox.Show(s);
        }
    }

    public class Para<T> 
        : IComparable<Para<T>>
        where T : IComparable<T>
    {
        public T Pierwszy;
        public T Drugi;

        public int CompareTo(Para<T> inny)
        {
            int w1 = this.Pierwszy.CompareTo(inny.Pierwszy);
            if (w1 != 0) return w1;
            else
            {
                return this.Drugi.CompareTo(inny.Drugi);
            }
        }
    }
}
