﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace AplikacjaBazodanowa
{
    public partial class Form1 : Form
    {
        bool daneZmienione = false;

        public Form1()
        {
            InitializeComponent();

            this.Text = "Tabela: " + bazaDanychDataSet.Osoby.ToString();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            // TODO: This line of code loads data into the 'bazaDanychDataSet.Osoby' table. You can move, or remove it, as needed.
            this.osobyTableAdapter.Fill(this.bazaDanychDataSet.Osoby);

            //BazaDanychDataSet.OsobyRow or = this.bazaDanychDataSet.Osoby[0];
            //MessageBox.Show(or.Imię + " " + or.Nazwisko);

            daneZmienione = false;

            Form2 form2 = new Form2();
            form2.Visible = true;
            form2.Left = this.Left + this.Width + 30;
            form2.Top = this.Top;            
        }

        private void dataGridView1_CellValueChanged(object sender, DataGridViewCellEventArgs e)
        {
            daneZmienione = true;
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (!daneZmienione) return;

            DialogResult dr = MessageBox.Show("Czy zapisać zmiany w bazie danych?","Aplikacja bazodanowa",MessageBoxButtons.YesNoCancel);
            switch (dr)
            {
                case DialogResult.Cancel:
                    e.Cancel = true;
                    break;
                case DialogResult.Yes:
                    try
                    {
                        this.Validate();
                        this.osobyBindingSource.EndEdit();
                        this.osobyTableAdapter.Update(bazaDanychDataSet.Osoby);
                        MessageBox.Show("Zmiany w danych zostały zapisane");
                    }
                    catch (Exception exc)
                    {
                        MessageBox.Show("Błąd przy zapisie danych: " + exc.Message);
                    }
                    break;
                case DialogResult.No:
                    break;
            }
        }
    }
}
