﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.Threading;

namespace MonteCarloPi
{
    class Program
    {
        static Random r = new Random();
        static int ileWątków = Environment.ProcessorCount;
        static double pi = 0;

        static void Main(string[] args)
        {
            int tickCountStart = Environment.TickCount;            
            Console.WriteLine("Liczba procesorów: " + ileWątków.ToString());

            ParameterizedThreadStart pts = new ParameterizedThreadStart(uruchomObliczeniaPi);
            Thread[] tt = new Thread[ileWątków];
            for (int i = 0; i < ileWątków; ++i)
            {
                tt[i] = new Thread(pts);
                tt[i].Priority = ThreadPriority.Highest;
                tt[i].Start(i);
            }

            foreach (Thread t in tt)
            {
                t.Join();
                Console.WriteLine("Zakończył się wątek nr " + t.ManagedThreadId);
            }
            Console.WriteLine("Zakończyły się wszystkie wątki");

            pi /= ileWątków;
            Console.WriteLine("Ostatecznie, Pi={0}, blad={1}", pi, Math.PI - pi);

            int tickCountStop = Environment.TickCount;
            int tickCountDuration = tickCountStop - tickCountStart;
            Console.WriteLine(tickCountDuration.ToString());
        }

        static double obliczPi(long liczbaProb)
        {
            Random r = new Random(Program.r.Next());
            double x, y;
            double liczbaPunktowWKole = 0;
            
            for (long i = 0; i < liczbaProb; ++i)
            {
                x = r.NextDouble();
                y = r.NextDouble();
                //if(i%10000==0) Console.WriteLine("x=" + x.ToString() + ", y=" + y.ToString());
                /*
                if (i == liczbaProb / 2)
                {                    
                    lock(Program.r)
                    {
                        Console.WriteLine("Synchronizacja-początek: " + Thread.CurrentThread.ManagedThreadId.ToString());
                        Thread.Sleep(1000);
                        Console.WriteLine("Synchronizacja-koniec: " + Thread.CurrentThread.ManagedThreadId.ToString());
                    }
                }
                */
                if (x * x + y * y < 1) liczbaPunktowWKole++;
            }
            return 4 * liczbaPunktowWKole / liczbaProb;
        }

        static void uruchomObliczeniaPi(object parametr)
        {
            int i = -1;
            if (parametr is int) i = (int)parametr;
            else
            {
                Console.WriteLine("Wątek nr {0} - błędny parametr", Thread.CurrentThread.ManagedThreadId);
                return;
            }


            Console.WriteLine("Parametr i=" + i.ToString());

            try
            {
                double pi = obliczPi(100000000/ileWątków);
                Program.pi += pi;
                Console.WriteLine("Pi={0}, blad={1}", pi, Math.PI - pi);
                Console.WriteLine("Wątek nr {0}", Thread.CurrentThread.ManagedThreadId);
            }
            catch (ThreadAbortException exc)
            {
                Console.WriteLine("Obliczenia zostały przerwane wywołaniem metody Abort");
                Console.WriteLine(exc.Message);
            }
            catch (Exception exc)
            {
                Console.WriteLine(exc.Message);
            }
        }
    }
}
