﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;

using System.Threading;
using System.Threading.Tasks;

using Windows.System.Threading;

// The Blank Page item template is documented at http://go.microsoft.com/fwlink/?LinkId=234238

namespace TPL
{
    /// <summary>
    /// An empty page that can be used on its own or navigated to within a Frame.
    /// </summary>
    public sealed partial class MainPage : Page
    {
        public MainPage()
        {
            this.InitializeComponent();
        }

        /// <summary>
        /// Invoked when this page is about to be displayed in a Frame.
        /// </summary>
        /// <param name="e">Event data that describes how this page was reached.  The Parameter
        /// property is typically used to configure the page.</param>
        protected override void OnNavigatedTo(NavigationEventArgs e)
        {
            ts = TaskScheduler.FromCurrentSynchronizationContext();
        }

        TaskScheduler ts;

        private void msg(string komunikat)
        {
            
            Task.Factory.StartNew(
                () =>
                {
                    string taskId = Task.CurrentId.HasValue ? Task.CurrentId.Value.ToString() : "UI";
                    infoLabel.Text += "(" + taskId + ") " + komunikat + "\n";
                }, CancellationToken.None, TaskCreationOptions.None, ts);
        }

        private void TworzenieZadan()
        {
            SpinWait sw = new SpinWait();
            int ileZadan = 10;

            Action<object> a = async (object o) =>
            {
                EventWaitHandle ewh = o as EventWaitHandle;
                string taskId = Task.CurrentId.HasValue ? Task.CurrentId.Value.ToString() : "UI";
                msg("Start zadania nr " + taskId.ToString());
                
		//await Task.Delay(1000);
		Task.Delay(1000).Wait();
                //for (int i = 0; i < 1000; ++i) sw.SpinOnce();
                
		msg("Koniec zadania nr " + taskId.ToString());
                ewh.Set();
            };

            List<Task> listaZadan = new List<Task>(ileZadan);
            List<EventWaitHandle> listaEWH = new List<EventWaitHandle>(ileZadan);
            for (int i = 0; i < ileZadan; ++i)
            {
                EventWaitHandle ewh = new EventWaitHandle(false, EventResetMode.ManualReset);
                listaEWH.Add(ewh);
                listaZadan.Add(new Task(a, ewh));
            }
            msg("Zadania utworzone");
            foreach (Task t in listaZadan) t.Start();
            msg("Zadania uruchomione");
            //foreach (Task t in listaZadan) t.Wait();
            foreach (EventWaitHandle ewh in listaEWH) ewh.WaitOne();
            msg("Zadania zakończone");
        }

        #region Pula wątków
                
        Random r = new Random();
        long całkowitaIlośćTrafień = 0;
        const long ilośćPróbWWątku = 1000000;

        long obliczPi(long ilośćPrób/*, CancellationToken ct*/)
        {
            Random r = new Random(this.r.Next());

            try
            {
                long ilośćTrafień = 0;
                for (long i = 0; i < ilośćPrób; ++i)
                {
                    //msg("*");
                    //Console.Write("*");

                    //zamykanie watku
                    //lock (r) { if (zakonczWatek) return -1; } //słaby punkt

                    //ct.ThrowIfCancellationRequested();
                    //if (ct.IsCancellationRequested) return -1;

                    /*
                    //wstrzymywanie watku
                    while (wstrzymajWatek)
                    {
                        Thread.Sleep(10);
                    }
                    */

                    double x = r.NextDouble();
                    double y = r.NextDouble();
                    if (x * x + y * y < 1) ilośćTrafień++;
                }
                //return 4.0 * ilośćTrafień / ilośćPrób;
                return ilośćTrafień;
            }
            catch (Exception exc)
            {
                //Console.ForegroundColor = ConsoleColor.Yellow;
                msg("Wystąpił błąd w metodzie wątku: " + exc.Message);
            }
            return -1;
        }

        void uruchomObliczenia(object parametr)
        {
            //CancellationToken ct = (CancellationToken)parametr;

            //msg("Uruchamiam obliczenia...");

            long ilośćTrafień = obliczPi(ilośćPróbWWątku/*, ct*/);
            Interlocked.Add(ref całkowitaIlośćTrafień,ilośćTrafień);
            /*
            if (pi == -1) msg("Działanie wątku zakończyło się przedwcześnie");
            else
            {
                msg("Pi=" + pi);
                msg("Obliczenia zakończone");
            }
            */

            //msg("Obliczenia zakończone");
        }

        private void PulaWatkow()
        {
            całkowitaIlośćTrafień = 0;

            //int ileWatkow = Environment.ProcessorCount;
            int ileWatkow = 100;

            int czasPoczatkowy = Environment.TickCount;
            int ileDzialajacychWatkow = 0;

            //tworzenie watkow
            WorkItemHandler metodaWatku = uruchomObliczenia;
            for (int i = 0; i < ileWatkow; ++i)
            {
                Interlocked.Increment(ref ileDzialajacychWatkow);
                IAsyncAction threadPoolWorkItem = ThreadPool.RunAsync(metodaWatku);
                threadPoolWorkItem.Completed = new AsyncActionCompletedHandler(
                    (IAsyncAction source,AsyncStatus status) =>
                    {
                        //msg("Zadanie wykonane");
                        Interlocked.Decrement(ref ileDzialajacychWatkow);
                    });                
            }

            do { }
            while (ileDzialajacychWatkow > 0);

            msg("Wszystkie działające wątki zostały zakończone");

            double pi = 4.0 * całkowitaIlośćTrafień / (ileWatkow * ilośćPróbWWątku);
            msg("Obliczone pi=" + pi.ToString());
            
            int czasKoncowy = Environment.TickCount;
            int roznica = czasKoncowy - czasPoczatkowy;
            msg("Czas obliczeń: " + roznica.ToString());
        }
        #endregion

        private void Button_Click_1(object sender, RoutedEventArgs e)
        {
            infoLabel.Text = "";
            msg("START");

            //TworzenieZadan();
            PulaWatkow();

            msg("KONIEC");
        }
    }
}
