﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

using System.IO;
using System.Xml.Linq;

using Model;

namespace KsięgaGości
{
    //klasa encji - definiowanie w Wpisy.dbml

    //model
    public class Wpisy
    {
        WpisyDataContext sql = new WpisyDataContext();

        public bool ZapiszDoBazyDanychPoKażdymDodaniuWpisu = true;

        public void Dodaj(Wpis nowyWpis)
        {
            int noweId = 0;
            if (sql.Wpis.Count() > 0) noweId = sql.Wpis.Max(wpis => wpis.Id) + 1;
            nowyWpis.Id=noweId;

            sql.Wpis.InsertOnSubmit(nowyWpis);

            if (ZapiszDoBazyDanychPoKażdymDodaniuWpisu) sql.SubmitChanges();
        }

        public int Liczba
        {
            get
            {
                return sql.Wpis.Count();
            }
        }

        public Wpis this[int id]
        {
            get
            {
                return sql.Wpis.First(wpis => wpis.Id==id);
            }
        }
    }
}