﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.Drawing;
using System.Drawing.Drawing2D;
using System.Drawing.Imaging;

using System.IO;

namespace Zdjecia
{
    public partial class DodawanieZdjecia : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {

        }

        const int rozmiarMiniatury = 200;

        private static void PrzygotujMiniature(string nazwaPlikuOryginalnegoObrazu, string nazwaPlikuMiniatury, out int szerokosc, out int wysokosc)
        {
            Bitmap oryginalnyObraz = new Bitmap(nazwaPlikuOryginalnegoObrazu);

            if (oryginalnyObraz.Width > oryginalnyObraz.Height)
            {
                szerokosc = rozmiarMiniatury;
                wysokosc = rozmiarMiniatury * oryginalnyObraz.Height / oryginalnyObraz.Width;
            }
            else
            {
                wysokosc = rozmiarMiniatury;
                szerokosc = rozmiarMiniatury * oryginalnyObraz.Width / oryginalnyObraz.Height;
            }

            Bitmap miniatura = new Bitmap(szerokosc, wysokosc);
            
            using (Graphics g = Graphics.FromImage(miniatura))
            {
                g.InterpolationMode = InterpolationMode.HighQualityBicubic;
                g.SmoothingMode = SmoothingMode.AntiAlias;
                g.PixelOffsetMode = PixelOffsetMode.HighQuality;
                g.DrawImage(oryginalnyObraz, 0, 0, szerokosc, wysokosc);                
            }

            miniatura.Save(nazwaPlikuMiniatury, ImageFormat.Jpeg);
        }

        ZdjeciaDataContext bazaDanych = new ZdjeciaDataContext();
        const int maksymalnyRozmiarPliku = 2 * 1024 * 1024; //2MB
        const string katalogNaPrzeslanePliki = @"C:\Prywatne\Zdjecia_PobranePliki";
        const string katalogNaMiniatury = "~/Zdjecia_Miniatury";

        protected void Button1_Click(object sender, EventArgs e)
        {
            if(!CheckBox2.Checked)
            {
                Label2.Text += "<br /><font color=red>Musisz zaznaczyć pole opcji, które wg regulaminu oznacza, że możemy z Twoim zdjęciem zrobić co chcemy.</font>";
                return;
            }

            string katalogNaPrzeslanyPlik = Path.Combine(katalogNaPrzeslanePliki, DropDownList1.SelectedValue);
            if(!Directory.Exists(katalogNaPrzeslanyPlik)) Directory.CreateDirectory(katalogNaPrzeslanyPlik);

            if(FileUpload1.HasFile)
            {
                string nazwaPliku = FileUpload1.FileName;

                //sprawdzanie rozszerzenia
                string rozszerzeniePliku = Path.GetExtension(nazwaPliku);
                rozszerzeniePliku = rozszerzeniePliku.ToLower();
                if (!(rozszerzeniePliku == ".jpeg" || rozszerzeniePliku == ".jpg" || rozszerzeniePliku == ".jpe" ||
                    rozszerzeniePliku == ".gif" || rozszerzeniePliku == ".bmp"))
                {
                    Label2.Text += "<br /><font color=red>Rozszerzenie nazwy pliku nie wskazuje na obsługiwany format graficzny.</font>";
                    return;
                }

                //sprawdzanie rozmiaru                
                int rozmiarPliku = FileUpload1.PostedFile.ContentLength;
                if (rozmiarPliku > maksymalnyRozmiarPliku)
                {
                    Label2.Text += "<br /><font color=red>Wielkość pliku przekracza dozwolony rozmiar.</font>";
                    return;
                }

                //unikalne nazwy
                string data = DateTime.Now.ToString().Replace(':', '_');
                nazwaPliku = "(" + data + ") " + nazwaPliku;

                //upload
                string ściezkaPliku = Path.Combine(katalogNaPrzeslanyPlik, nazwaPliku);
                try
                {
                    FileUpload1.SaveAs(ściezkaPliku);
                    Label2.Text += "<br /><font color=green>Plik został pomyślnie przesłany i zapisany jako " + ściezkaPliku + " (rozmiar pliku: "+ rozmiarPliku +" b).</font>";

                    //tworzenie miniatury
                    string katalogNaMiniature = Path.Combine(katalogNaMiniatury, DropDownList1.SelectedValue);
                    string nazwaPlikuMiniatury = "miniatura_"+Path.GetFileNameWithoutExtension(nazwaPliku)+".jpg";
                    string urlPlikuMiniatury = Path.Combine(katalogNaMiniature,nazwaPlikuMiniatury);
                    string ścieżkaFizycznaKataloguNaMiniatury = Server.MapPath(katalogNaMiniature);
                    if(!Directory.Exists(ścieżkaFizycznaKataloguNaMiniatury)) Directory.CreateDirectory(ścieżkaFizycznaKataloguNaMiniatury);
                    string ścieżkaFizycznaPlikuMiniatury = Server.MapPath(urlPlikuMiniatury);
                    int szerokosc, wysokosc;
                    PrzygotujMiniature(ściezkaPliku, ścieżkaFizycznaPlikuMiniatury, out szerokosc, out wysokosc);

                    //ostartni obraz (Image1)
                    Image1.ImageUrl = urlPlikuMiniatury;
                    Image1.Visible = true;
                    Label1.Visible = true;

                    //baza danych
                    int idZdjecia = ((bazaDanych.Zdjecies.Count() == 0) ? 0 : (bazaDanych.Zdjecies.Max(zdjecie => zdjecie.Id) + 1));
                    Zdjecie noweZdjecie = new Zdjecie()
                    {
                        Id = idZdjecia,
                        ŚcieżkaPliku = ściezkaPliku,
                        ŚcieżkaPlikuMiniatury = urlPlikuMiniatury,
                        Kategoria = DropDownList1.SelectedValue,
                        DataUmieszczeniaWZbiorze = DateTime.Now,
                        Opis = TextBox1.Text,
                        Publiczny = CheckBox1.Checked,
                        Szerokość = szerokosc,
                        Wysokość = wysokosc
                    };
                    bazaDanych.Zdjecies.InsertOnSubmit(noweZdjecie);
                    bazaDanych.SubmitChanges();

                    Label2.Text += "<font color=green>Unikalny identyfikator zdjęcia: " + noweZdjecie.Id + "</font>";
                }
                catch (Exception exc)
                {
                    Label2.Text += "<br /><font color=red>Błąd podczas przesyłania pliku: " + exc.Message + ".</font>";
                }
                finally
                {
                    //tu może powinno być zamknięcie pliku
                }
            }
            else
            {
                Label2.Text+="<br /><font color=red>Musisz najpierw wybrać plik</font>";
            }
        }
    }
}