﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.Data.Entity;

namespace EF
{
    public partial class Form1 : Form
    {
        WpisyEntities bazaDanych = new WpisyEntities();

        public Form1()
        {
            InitializeComponent();

            button3_Click(null, null);
        }

        private void button1_Click(object sender, EventArgs e)
        {
            using (WpisyEntities bazaDanych = new WpisyEntities())
            {
                string s = "Lista osób:\n";
                foreach (Osoba o in bazaDanych.Osoby)
                {
                    s += o.Imię + " " + o.Nazwisko + " (" + o.Wiek + ")\n";
                }
                MessageBox.Show(s);

                if (!checkBox1.Checked) return;

                int noweId = bazaDanych.Osoby.Max(o => o.Id) + 1;
                Osoba nowaOsoba = new Osoba() { Id = noweId, Imię = "Katarzyna", Nazwisko = "Matulewska", Email = "km@costma.pl", Wiek = 43 };
                bazaDanych.Osoby.Add(nowaOsoba);                
                
                int ileElementówDopisanych = bazaDanych.SaveChanges();                
                MessageBox.Show("Dopisałem " + ileElementówDopisanych + " rekordów");

                s = "Lista osób:\n";
                foreach (Osoba o in bazaDanych.Osoby)
                {
                    s += o.Imię + " " + o.Nazwisko + " (" + o.Wiek + ")\n";
                }
                MessageBox.Show(s);                
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            using (WpisyEntities bazaDanych = new WpisyEntities())
            {
                /*
                var osobyPełnoletnie = from Osoba o in bazaDanych.Osoby
                                       where o.Wiek <= 30
                                       orderby o.Nazwisko descending
                                       //select o;
                                       //select new { o.Imię, o.Nazwisko, o.Wiek };
                                       select o.Imię + " " + o.Nazwisko + " (" + o.Wiek + ")";
                */

                var osobyPełnoletnie = from Osoba o in bazaDanych.Osoby.ToList()
                                       where o.Wiek <= 30
                                       orderby o.Nazwisko descending
                                       //select o;
                                       //select new { o.Imię, o.Nazwisko, o.Wiek };
                                       select o.Imię + " " + o.Nazwisko + " (" + o.Wiek + ")";

                string s = "Lista osób:\n";
                foreach (var o in osobyPełnoletnie)
                {
                    //s += o.Imię + " " + o.Nazwisko + " (" + o.Wiek + ")\n";
                    s += o + "\n";
                }
                MessageBox.Show(s);
            }
        }

        /*
        private void button3_Click(object sender, EventArgs e)
        {
            bazaDanych.Osoby.Load();            
            dataGridView1.DataSource = bazaDanych.Osoby.Local.ToBindingList();
        }
        */

        private async void button3_Click(object sender, EventArgs e)
        {
            //MessageBox.Show("Początek button3_Click");
            await bazaDanych.Osoby.LoadAsync();
            dataGridView1.DataSource = bazaDanych.Osoby.Local.ToBindingList();
            //MessageBox.Show("Koniec button3_Click");
        }

        private void button4_Click(object sender, EventArgs e)
        {
            bazaDanych.SaveChanges();
        }
    }

    public static class Rozszerzenia
    {
        public static Task LoadAsync<T>(this DbSet<T> ds) where T : class
        {
            Task zadanie = new Task(() =>
            {
                //MessageBox.Show("Początek wczytywanie");
                ds.Load();
                //System.Threading.Thread.Sleep(10000);
                //MessageBox.Show("Koniec wczytywania");
            });
            zadanie.Start();
            return zadanie;
        }
    }
}
