﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.Media;
using Microsoft.Win32;
using Choinka.Properties;

namespace Choinka
{
    public partial class Form1 : Form
    {
        SoundPlayer sp = null;
        Settings ustawienia = new Settings();

        private Point PictureLocation;
        private short actPic = 0;
        private Image[] im = new Image[4];

        public Form1()
        {
            InitializeComponent();

            string katalog = Application.StartupPath;
            sp = new SoundPlayer(System.IO.Path.Combine(katalog, "Choinka.wav"));
            this.Width = Screen.PrimaryScreen.Bounds.Width;
            this.Height = this.BackgroundImage.Height;
            Console.WriteLine(Screen.PrimaryScreen.Bounds.Height);
            this.Location = new Point(Screen.PrimaryScreen.Bounds.Width / 2 - this.Width / 2, 0);


            im[0] = Resources.santa1;
            im[1] = Resources.santa2;
            im[2] = Resources.santa3;
            im[3] = Resources.santa4;

            pictureBox1.BackColor = Color.Transparent;
          //  this.BackColor = Color.Transparent;

            pictureBox1.Width = im[0].Width;
            pictureBox1.Height = im[0].Height;
            PictureLocation = new Point(0, this.Height - pictureBox1.Height );

            ukryjToolStripMenuItem.Tag = false;            
        }

        private void Form1_Paint(object sender, PaintEventArgs e)
        {
           // e.Graphics.DrawImage(obraz, 0, 0, obraz.Width, obraz.Height);
        }

        private void Form1_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Escape) Close();
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            notifyIcon1.Visible = false;
            ustawienia.x = this.Left;
            ustawienia.y = this.Top;
            ustawienia.dzwiek = toolStripMenuItem2.Checked;
            ustawienia.Save();

            for (; Opacity > 0; Opacity -= 0.01) System.Threading.Thread.Sleep(5);
        }
        
        Point? przenoszeniePoczatek = null;

        private void Form1_MouseDown(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Left) przenoszeniePoczatek = new Point(e.X, e.Y);            
        }

        private void Form1_MouseMove(object sender, MouseEventArgs e)
        {            
            if(przenoszeniePoczatek.HasValue) 
            {
                int dx = e.X - przenoszeniePoczatek.Value.X;
                int dy = e.Y - przenoszeniePoczatek.Value.Y;
                this.Left += dx;
                this.Top += dy;
            }
        }

        private void Form1_MouseUp(object sender, MouseEventArgs e)
        {
            przenoszeniePoczatek = null;
        }

        private void zamknijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void zawszeNaWierzchuToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.TopMost = zawszeNaWierzchuToolStripMenuItem.Checked;
        }

        

        private void ukryjToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (!(bool)ukryjToolStripMenuItem.Tag)
            {
                this.Hide();
                ukryjToolStripMenuItem.Text = "Pokaż";
                ukryjToolStripMenuItem.Tag = true;
            }
            else
            {
                this.Show();
                ukryjToolStripMenuItem.Text = "Ukryj";
                ukryjToolStripMenuItem.Tag = false;
            }
        }

        private void oAutorzeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            MessageBox.Show("Kurs .NET 2013/2014");
        }

        private void stronaUMKToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Process.Start("http://www.umk.pl");
        }

        private void notifyIcon1_DoubleClick(object sender, EventArgs e)
        {
            notifyIcon1.BalloonTipTitle = "Gwiazdka " + DateTime.Now.Year;
            notifyIcon1.BalloonTipText = "Wszystkiego najlepszego od studentów kursu .NET";
            notifyIcon1.BalloonTipText += "\n" + notifyIcon1.Text;
            notifyIcon1.ShowBalloonTip(2000);
        }

        private void notifyIcon1_MouseMove(object sender, MouseEventArgs e)
        {
            notifyIcon1.Text = "Do gwiazdki pozostało jeszcze " + (24 - DateTime.Now.Day).ToString() + " dni!";
        }

        private void toolStripMenuItem2_Click(object sender, EventArgs e)
        {
            if (toolStripMenuItem2.Checked) sp.PlayLooping();
            else sp.Stop();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            this.Left = ustawienia.x;
            this.Top = ustawienia.y;
            toolStripMenuItem2.Checked = ustawienia.dzwiek; toolStripMenuItem2_Click(null, null);
            if (toolStripMenuItem2.Checked) sp.PlayLooping();
            this.Location = new Point(Screen.PrimaryScreen.Bounds.Width / 2 - this.Width / 2, Screen.PrimaryScreen.Bounds.Height-this.BackgroundImage.Height-50);
        }

        private void toolStripMenuItem3_Click(object sender, EventArgs e)
        {
            try
            {
                RegistryKey kluczRejestruRun = Registry.CurrentUser.OpenSubKey(@"Software\Microsoft\Windows\CurrentVersion\Run", true);
                if (kluczRejestruRun.GetValueNames().Contains("Choinka")) kluczRejestruRun.DeleteValue("Choinka");
                kluczRejestruRun.SetValue("Choinka", "\"" + Application.ExecutablePath + "\"");
                kluczRejestruRun.Close();
                MessageBox.Show("Dodano zapis w rejestrze");
            }
            catch(Exception exc)
            {
                MessageBox.Show("Dodanie zapisu w rejestrze nie powiodło się.\nBłąd: "+exc.Message,"Choinka",MessageBoxButtons.OK,MessageBoxIcon.Error);
            }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            if (actPic >= 4)
                actPic = 0;

            pictureBox1.Image = im[actPic];
            PictureLocation.X += 5;
            pictureBox1.Location = PictureLocation;

            if (pictureBox1.Location.X > this.Width)
            {
                Point tmp = new Point(pictureBox1.Location.X, pictureBox1.Location.Y);
                tmp.X = -40;
                PictureLocation = tmp;
            }
            actPic++;
        }
    }
}
