﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.Data.Entity;

namespace EF_2014
{    
    public partial class Form1 : Form
    {
        BazaDanychEntities bazaDanych = new BazaDanychEntities();
        bool daneWSiatceZmienione = false;

        private Task ŁadujDaneAsync()
        {
            Cursor = Cursors.WaitCursor;
            //MessageBox.Show("0-"+System.Threading.Thread.CurrentThread.ManagedThreadId.ToString());
            return Task.Run(() => 
            {
                
                //MessageBox.Show("1-" + Task.CurrentId.ToString());
                System.Threading.Thread.Sleep(1000);
                bazaDanych.Osoba.Load(); 
            });
            //MessageBox.Show("2-" + Task.CurrentId.ToString());
        }

        private async void InicjujDane()
        {
            //MessageBox.Show("3-" + Task.CurrentId.ToString());
            await ŁadujDaneAsync();
            dataGridView1.DataSource = bazaDanych.Osoba.Local.ToBindingList<Osoba>();
            daneWSiatceZmienione = false;
            Cursor = Cursors.Default;
            //MessageBox.Show("4-" + Task.CurrentId.ToString());
        }

        public Form1()
        {
            InitializeComponent();

            //bazaDanych.Osoba.Load();
            //dataGridView1.DataSource = bazaDanych.Osoba.Local.ToBindingList<Osoba>();

            //MessageBox.Show("5-" + Task.CurrentId.ToString());
            InicjujDane();
            //MessageBox.Show("6-" + Task.CurrentId.ToString());

            new Form2().Show();
        }

        #region Varia
        private void button1_Click(object sender, EventArgs e)
        {
            Varia.DodawanieRekordu();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            Varia.DemoLinq();
        }

        private void button3_Click(object sender, EventArgs e)
        {
            Varia.DemoStoredProcedure();
        }
        #endregion

        private void dataGridView1_CellValueChanged(object sender, DataGridViewCellEventArgs e)
        {
            daneWSiatceZmienione = true;
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (!daneWSiatceZmienione) return;
            DialogResult dr = MessageBox.Show("Dane zostały zmienione. Czy chcesz je zapisać?", this.Text, MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question, MessageBoxDefaultButton.Button3);
            switch (dr)
            {
                case DialogResult.Yes:
                    bazaDanych.SaveChanges();
                    e.Cancel = false;
                    break;
                case DialogResult.No:
                    e.Cancel = false;
                    break;
                case DialogResult.Cancel:
                    e.Cancel = true;
                    break;
            }
        }

        private void button4_Click(object sender, EventArgs e)
        {
            using (BazaDanychEntities bazaDanych = new BazaDanychEntities())
            {
                Osoba osoba = bazaDanych.Osoba.First();
                Rozmówcy rozmówca = osoba.Rozmówcy.First();
                MessageBox.Show(rozmówca.Osoba.Imię + " " + rozmówca.Osoba.Nazwisko);
                MessageBox.Show(rozmówca.CzasRozmowy.ToString());
            }
        }
    }
}
