﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Windows.Forms;

namespace EF_2014
{
    class Varia
    {
        private static void PokażDaneZTabeliOsoba(BazaDanychEntities bazaDanych)
        {
            string s = "Lista osób:\n";
            foreach (Osoba o in bazaDanych.Osoba.OrderBy(o => o.Wiek)) s += o.Imię + " " + o.Nazwisko + " (" + o.Wiek + ")\n";
            MessageBox.Show(s);
        }

        public static void DodawanieRekordu()
        {
            using (BazaDanychEntities bazaDanych = new BazaDanychEntities())
            {
                //odczyt danych
                PokażDaneZTabeliOsoba(bazaDanych);

                //tworzenie nowego rekordu
                int noweId = bazaDanych.Osoba.Max(o => o.Id) + 1;
                Osoba nowaOsoba = new Osoba()
                {
                    Id = noweId,
                    Imię = "Wiktor",
                    Nazwisko = "Janukowycz",
                    Wiek = 60,
                    Email = "wiktor@nauslugach.zsrr"
                };

                //dodajemy nowy rekord do bazy danych
                bazaDanych.Osoba.Add(nowaOsoba);
                bazaDanych.SaveChanges();

                //ponowny odczyt danych
                PokażDaneZTabeliOsoba(bazaDanych);
            }
        }

        public static void DemoLinq()
        {
            using (BazaDanychEntities bazaDanych = new BazaDanychEntities())
            {
                //LINQ
                var osobyPelnoletnie = from o in bazaDanych.Osoba
                                       where o.Wiek >= 18
                                       orderby o.Wiek descending
                                       select o;

                string s = "Lista osób:\n";
                foreach (Osoba o in osobyPelnoletnie) s += o.Imię + " " + o.Nazwisko + " (" + o.Wiek.ToString() + ")\n";
                MessageBox.Show(s);
            }
        }

        public static void DemoStoredProcedure()
        {
            using (BazaDanychEntities bazaDanych = new BazaDanychEntities())
            {
                List<OsobyStarszeNiż_Result> osoby45Plus = bazaDanych.OsobyStarszeNiż(45).ToList();

                string s = "Lista osób 45+:\n";
                foreach (OsobyStarszeNiż_Result o in osoby45Plus) s += o.Imię + " " + o.Nazwisko + " (" + o.Wiek.ToString() + ")\n";
                MessageBox.Show(s);
            }
        }
    }
}
